/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;

public class DuplicateHeaderTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIMDuplicateHeaderTestAPI";
    private final String apiVersion = "1.0.0";
    private final String applicationName = "APIMDuplicateHeaderTestApp";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String apiContext = "duplicateHeaderAPI";
    private String accessToken;
    private String providerNameApi;
    private String tenantAdmin;
    private final String tenantKey = "user1";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(TestUserMode.TENANT_ADMIN);
        this.providerNameApi = this.publisherContext.getContextTenant().getTenantUser("user1").getUserName();
        User tenantUser = this.publisherContext.getContextTenant().getTenantUser("user1");
        this.tenantAdmin = tenantUser.getUserName();
        String apiEndpointPostfixUrl = "t/wso2.com/webapps/duplicate-header-backend/duplicateHeaderBackend";
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(tenantUser.getUserName(), tenantUser.getPassword());
        this.apiStore.login(tenantUser.getUserName(), tenantUser.getPassword());
        String backendEndPoint = this.getBackendEndServiceEndPointHttp(apiEndpointPostfixUrl);
        APIRequest apiRequest = new APIRequest("APIMDuplicateHeaderTestAPI", this.apiContext, new URL(backendEndPoint));
        apiRequest.setProvider(this.tenantAdmin);
        apiRequest.setVersion("1.0.0");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse serviceResponse = this.apiPublisher.addAPI(apiRequest);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIMDuplicateHeaderTestAPI", this.tenantAdmin, APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiStore.addApplication("APIMDuplicateHeaderTestApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIMDuplicateHeaderTestAPI", this.tenantAdmin);
        subscriptionRequest.setApplicationName("APIMDuplicateHeaderTestApp");
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APIMDuplicateHeaderTestApp");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        this.accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)this.accessToken);
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy with the  given Require Re-Subscription option")
    public void testPublishNewCopyGivenRequireReSubscription() throws Exception {
        String userDomain = this.storeContext.getContextTenant().getTenantUser("user1").getUserDomain();
        String gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + userDomain + "/" + this.apiContext + "/" + "1.0.0";
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(gatewayUrl);
        httpGet.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse backendResponse = httpclient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((int)backendResponse.getHeaders("cookie").length, (int)2, (String)"Expected two headers with the same name");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIMDuplicateHeaderTestAPI", "1.0.0", this.providerNameApi, "APIMDuplicateHeaderTestApp");
        this.apiStore.removeApplication("APIMDuplicateHeaderTestApp");
        this.apiPublisher.deleteAPI("APIMDuplicateHeaderTestAPI", "1.0.0", this.providerNameApi);
    }
}

