/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.io.IOException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class ESBJAVA3447PreserveCharsetInContentTypeTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(ESBJAVA3447PreserveCharsetInContentTypeTestCase.class);
    private WireMonitorServer wireServer;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.wireServer = new WireMonitorServer(8992);
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl());
        String session = login.login("admin", "admin", "localhost");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "CONTENT_TYPE_TEST.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)session);
        Thread.sleep(5000L);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    @Test(groups={"wso2.am"}, description="Test for preserving Charset in Content-Type header in the request")
    public void testPreserveCharsetInContentTypeHeader() throws Exception {
        this.wireServer.start();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(this.gatewayUrlsWrk.getWebAppURLNhttp() + "charset");
        httpget.setHeader("Content-type", "text/xml; charset=UTF-8");
        try {
            httpclient.execute((HttpUriRequest)httpget);
        }
        catch (IOException e) {
            log.error((Object)"Error in executing GET request for CharsetAPI", (Throwable)e);
        }
        String[] wireResponse = this.wireServer.getCapturedMessage().split(System.lineSeparator());
        String charSet = "";
        for (String line : wireResponse) {
            if (!line.contains("Content-Type")) continue;
            charSet = line;
            break;
        }
        Assert.assertTrue((boolean)charSet.contains("text/xml; charset=UTF-8"), (String)"Content-Type header has dropped Charset");
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.cleanUp();
    }
}

