/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class HeaderSplitingTestCase
extends APIMIntegrationBaseTest {
    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
    @Test(groups={"wso2.am"}, description="Test for gateway header splitting")
    public void testHeaderSplitting() throws Exception {
        String apiInvocationUrl = this.getAPIInvocationURLHttp("SampleAPI");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("SplitHeader", "Sample");
        HttpResponse httpResponse = HeaderSplitingTestCase.doGet(apiInvocationUrl, headers);
        if (httpResponse.getHeaders() != null) {
            Assert.assertNull(httpResponse.getHeaders().get("SplitHeader"), (String)"The Header spliting patch failed.");
        } else {
            Assert.assertFalse((boolean)true, (String)"The Header spliting patch failed.");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpResponse doGet(String endpoint, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse;
        if (!endpoint.startsWith("http://")) {
            return null;
        }
        URL url = new URL(endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setReadTimeout(30000);
        if (headers != null && headers.size() > 0) {
            Iterator<String> sb = headers.keySet().iterator();
            String rd = sb.next();
            conn.setRequestProperty(rd, headers.get(rd));
        }
        conn.connect();
        StringBuilder sb1 = new StringBuilder();
        try (BufferedReader rd1 = null;){
            String ignored;
            rd1 = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((ignored = rd1.readLine()) != null) {
                sb1.append(ignored);
            }
            httpResponse = new HttpResponse(sb1.toString(), conn.getResponseCode());
            httpResponse.setResponseMessage(conn.getResponseMessage());
        }
        Iterator<String> itr1 = conn.getHeaderFields().keySet().iterator();
        headers = new HashMap<String, String>();
        while (itr1.hasNext()) {
            String key = itr1.next();
            if (key == null) continue;
            headers.put(key, conn.getHeaderField(key));
        }
        httpResponse.setHeaders(headers);
        return httpResponse;
    }
}

