/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;

public class BackendJWTUtil {
    public static void verifySignature(Header jwtheader) throws UnsupportedEncodingException {
        String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
        String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
        boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
        AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
    }

    public static void verifyJWTHeader(String decodedJWTHeaderString) throws JSONException {
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        Assert.assertFalse((boolean)jsonHeaderObject.has("kid"));
    }

    public static void verifyWrongClaims(JSONObject decodedJWTJSONObject) {
        boolean exceptionOccured = false;
        try {
            decodedJWTJSONObject.getString("http://wso2.org/claims/wrongclaim");
        }
        catch (JSONException e) {
            exceptionOccured = true;
        }
        AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)exceptionOccured);
    }
}

