/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.nimbusds.jose.JOSEException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.jwt.idp.JWTGeneratorUtil;
import org.wso2.andes.util.Strings;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.identity.application.common.model.idp.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.idp.xsd.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.Property;
import org.wso2.carbon.identity.application.common.model.xsd.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceIdentityApplicationManagementException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceIdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.idp.mgt.stub.IdentityProviderMgtServiceIdentityProviderManagementExceptionException;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceUserStoreExceptionException;
import org.wso2.carbon.user.core.UserStoreException;

public class FederatedUserJWTTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(FederatedUserJWTTestCase.class);
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private final String DEFAULT_PROFILE = "default";
    String[] users = new String[]{"subscriberUser2", "subscriberUser2@wso2.com", "subscriberUser2@abc.com"};
    String enduserPassword = "password@123";
    URL tokenEndpointURL;
    WireMockServer wireMockServer;
    private String apiName = "JWTUserClaimAPI";
    private String apiContext = "jwtTest";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String oauthApplicationName = "FederatedOauthAppForJWTTest";
    private String jwtApplicationName = "FederatedJWTAppForJWTTest";
    private String endpointURL;
    private String oauthApplicationId;
    private String jwtApplicationId;
    private String apiId;
    private int idpPort;
    private String callbackUrl = "https://localhost:9943/services/Version";
    private String authorizeURL;

    @Factory(dataProvider="userModeDataProvider")
    public FederatedUserJWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private static CloseableHttpResponse executeRequest(HttpUriRequest request, HttpClientContext context) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().disableAutomaticRetries().disableRedirectHandling().build();){
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(request, (HttpContext)context);
            return closeableHttpResponse;
        }
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.authorizeURL = this.getKeyManagerURLHttps() + "/oauth2/authorize";
        this.idpPort = this.getAvailablePort(9950, 9999);
        if (this.idpPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range 9950-9999 was found");
        }
        log.info((Object)("Selected port " + this.idpPort + " to start backend server"));
        this.startIdp(this.idpPort);
        this.tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        this.providerName = this.user.getUserName();
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication(this.oauthApplicationName, "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.oauthApplicationId = applicationDTO.getData();
        applicationDTO = this.restAPIStore.createApplication(this.jwtApplicationName, "JWT Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtApplicationId = applicationDTO.getData();
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.endpointURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.providerName);
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("oauth2");
        securitySchemes.add("api_key");
        apiRequest.setSecurityScheme(securitySchemes);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.apiId, this.oauthApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiId, this.jwtApplicationId, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        grantTypes.add("authorization_code");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.oauthApplicationId, "36000", this.callbackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        ApplicationKeyDTO applicationKeyDTO1 = this.restAPIStore.generateKeys(this.jwtApplicationId, "36000", this.callbackUrl, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.createUser();
        this.configureIDP();
        this.createClaimMapping();
        this.configureIDPtoFederationInServiceProvider(applicationKeyDTO.getConsumerKey());
        this.configureIDPtoFederationInServiceProvider(applicationKeyDTO1.getConsumerKey());
    }

    private void startIdp(int idpPort) throws JSONException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, JOSEException, IOException {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(idpPort).extensions(new Extension[]{new ResponseTemplateTransformer(false)}));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).willReturn(WireMock.aResponse().withHeader("Location", new String[]{"https://localhost:9943/commonauth?code=" + UUID.randomUUID().toString() + "&state={{request.query.state}}"}).withStatus(302).withTransformers(new String[]{"response-template"})));
        this.wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(200).withBody(this.getMockTokenResponse()).withHeader("Content-Type", new String[]{"application/json"})));
        this.wireMockServer.start();
    }

    private String getMockTokenResponse() throws JSONException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, JOSEException, IOException {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore.jks").toFile();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("azp", "consumerKey1");
        attributes.put("given_name", "first");
        attributes.put("family_name ", "last");
        attributes.put("email", "first@gmail.com");
        attributes.put("phone_number", "424479772294778");
        attributes.put("organization", "abc.com");
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", "https://localhost.idp.com", attributes);
        JSONObject token = new JSONObject();
        token.put("access_token", (Object)UUID.randomUUID().toString());
        token.put("refresh_token", (Object)UUID.randomUUID().toString());
        token.put("scope", (Object)"openid");
        token.put("token_type", (Object)"Bearer");
        token.put("expires_in", 3600);
        token.put("id_token", (Object)generatedJWT);
        return token.toString();
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for JWT Based App")
    public void testEnableJWTAndClaimsForJWTApp() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        this.updateServiceProviderWithRequiredClaims(applicationKeyDTO.getConsumerKey());
        for (String endUser : this.users) {
            String accessToken = this.generateUserToken(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"openid"});
            log.info((Object)("Access Token Generated in JWT ==" + accessToken));
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + accessToken);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
            String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
            boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
            AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
            Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
            Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            this.checkDefaultUserClaims(jsonObject, this.jwtApplicationName);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            String claim = jsonObject.getString("http://wso2.org/claims/givenname");
            AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name".concat(endUser)));
            claim = jsonObject.getString("http://wso2.org/claims/lastname");
            AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name".concat(endUser)));
            claim = jsonObject.getString("mobile");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("94123456987"));
            claim = jsonObject.getString("organization");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("ABC".concat(endUser)));
            boolean bExceptionOccured = false;
            try {
                jsonObject.getString("http://wso2.org/claims/wrongclaim");
            }
            catch (JSONException e) {
                bExceptionOccured = true;
            }
            AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)bExceptionOccured);
        }
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for JWT Based App", dependsOnMethods={"testEnableJWTAndClaimsForJWTApp"})
    public void testVerifyJWTClaimsInFederatedUserJWTAPP() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        String accessToken = this.generateTokenFromFederation(applicationKeyDTO);
        log.info((Object)("Access Token Generated in JWT ==" + accessToken));
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
        String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
        boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
        AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        this.checkDefaultUserClaims(jsonObject, this.jwtApplicationName);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        String claim = jsonObject.getString("http://wso2.org/claims/givenname");
        AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first"));
        claim = jsonObject.getString("http://wso2.org/claims/telephone");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("424479772294778"));
        claim = jsonObject.getString("http://wso2.org/claims/organization");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("abc.com"));
        claim = jsonObject.getString("http://wso2.org/claims/emailaddress");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("first@gmail.com"));
        boolean bExceptionOccured = false;
        try {
            jsonObject.getString("http://wso2.org/claims/wrongclaim");
        }
        catch (JSONException e) {
            bExceptionOccured = true;
        }
        AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)bExceptionOccured);
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for JWT Based App", dependsOnMethods={"testVerifyJWTClaimsInFederatedUserJWTAPP"})
    public void testVerifyJWTClaimsInFederatedUserOauthAPP() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.oauthApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        String accessToken = this.generateTokenFromFederation(applicationKeyDTO);
        log.info((Object)("Access Token Generated in oauth ==" + accessToken));
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + tokenJti);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
        String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
        boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
        AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        this.checkDefaultUserClaims(jsonObject, this.oauthApplicationName);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        String claim = jsonObject.getString("http://wso2.org/claims/givenname");
        AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first"));
        claim = jsonObject.getString("http://wso2.org/claims/telephone");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("424479772294778"));
        claim = jsonObject.getString("http://wso2.org/claims/organization");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("abc.com"));
        claim = jsonObject.getString("http://wso2.org/claims/emailaddress");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("first@gmail.com"));
        boolean bExceptionOccured = false;
        try {
            jsonObject.getString("http://wso2.org/claims/wrongclaim");
        }
        catch (JSONException e) {
            bExceptionOccured = true;
        }
        AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)bExceptionOccured);
    }

    /*
     * Exception decompiling
     */
    private String generateTokenFromFederation(ApplicationKeyDTO applicationKeyDTO) throws IOException, APIManagerIntegrationTestException, JSONException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getURLParameter(String url, String attribute) {
        try {
            Pattern p = Pattern.compile(attribute + "=([^&]+)");
            Matcher m = p.matcher(url);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.deleteClaimMapping();
        this.wireMockServer.stop();
        for (String user : this.users) {
            this.userManagementClient.deleteUser(user);
        }
        this.restAPIStore.deleteApplication(this.oauthApplicationId);
        this.restAPIStore.deleteApplication(this.jwtApplicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.identityProviderMgtClient.deleteIdp("federated-idp");
        super.cleanUp();
    }

    private void checkDefaultUserClaims(JSONObject jsonObject, String applicationName) throws JSONException {
        String claim = jsonObject.getString("iss");
        AssertJUnit.assertTrue((String)"JWT assertion is invalid", (boolean)claim.contains("wso2.org/products/am"));
        claim = jsonObject.getString("http://wso2.org/claims/subscriber");
        AssertJUnit.assertTrue((String)("JWT claim subscriber invalid. Received " + claim), (boolean)claim.contains(this.user.getUserName()));
        claim = jsonObject.getString("http://wso2.org/claims/applicationname");
        AssertJUnit.assertTrue((String)("JWT claim applicationname invalid. Received " + claim), (boolean)claim.contains(applicationName));
        claim = jsonObject.getString("http://wso2.org/claims/applicationtier");
        AssertJUnit.assertTrue((String)("JWT claim applicationtier invalid. Received " + claim), (boolean)claim.contains("50PerMin"));
        claim = jsonObject.getString("http://wso2.org/claims/keytype");
        AssertJUnit.assertTrue((String)("JWT claim keytype invalid. Received " + claim), (boolean)claim.contains("PRODUCTION"));
    }

    private void createUser() throws RemoteException, RemoteUserStoreManagerServiceUserStoreExceptionException, UserStoreException {
        for (String user : this.users) {
            this.remoteUserStoreManagerServiceClient.addUser(user, this.enduserPassword, new String[0], new ClaimValue[0], "default", false);
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/givenname", "first name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/lastname", "last name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/organization", "ABC".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/mobile", "94123456987", "default");
        }
    }

    private String generateUserToken(String consumerKey, String consumerSecret, String enduserName, String enduserPassword, User user, String[] scopes) throws APIManagerIntegrationTestException, JSONException {
        String username = enduserName.concat("@").concat(user.getUserDomain());
        String requestBody = "grant_type=password&username=" + username + "&password=" + enduserPassword + "&scope=" + Strings.join((String)" ", (Object[])scopes);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, this.tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        return accessTokenGenerationResponse.getString("access_token");
    }

    private String generateAuthCodeToken(String consumerKey, String consumerSecret, String authCode) throws APIManagerIntegrationTestException, JSONException {
        String requestBody = "grant_type=authorization_code&code=" + authCode + "&redirect_uri=" + this.callbackUrl;
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, this.tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        return accessTokenGenerationResponse.getString("access_token");
    }

    private void configureIDP() throws RemoteException, IdentityProviderMgtServiceIdentityProviderManagementExceptionException {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setIdentityProviderName("federated-idp");
        identityProvider.setEnable(true);
        FederatedAuthenticatorConfig federatedAuthenticatorConfig = this.addFederatedAuthenticatorConfigs();
        identityProvider.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{federatedAuthenticatorConfig});
        identityProvider.setDefaultAuthenticatorConfig(federatedAuthenticatorConfig);
        this.identityProviderMgtClient.addIDP(identityProvider);
    }

    private Claim getClaim(String claimUri) {
        Claim claim = new Claim();
        claim.setClaimUri(claimUri);
        return claim;
    }

    private FederatedAuthenticatorConfig addFederatedAuthenticatorConfigs() {
        FederatedAuthenticatorConfig federatedAuthenticatorConfig = new FederatedAuthenticatorConfig();
        federatedAuthenticatorConfig.setName("OpenIDConnectAuthenticator");
        federatedAuthenticatorConfig.setEnabled(true);
        federatedAuthenticatorConfig.setDisplayName("openidconnect");
        Property[] properties = new Property[9];
        Property property = new Property();
        property.setName("ClientId");
        property.setValue(UUID.randomUUID().toString());
        properties[0] = property;
        property = new Property();
        property.setName("OAuth2AuthzEPUrl");
        property.setValue("http://localhost:" + this.idpPort + "/authorize");
        properties[1] = property;
        property = new Property();
        property.setName("OAuth2TokenEPUrl");
        property.setValue("http://localhost:" + this.idpPort + "/token");
        properties[2] = property;
        property = new Property();
        property.setName("ClientSecret");
        property.setValue(UUID.randomUUID().toString());
        property.setConfidential(true);
        properties[3] = property;
        property = new Property();
        property.setName("IsUserIdInClaims");
        properties[4] = property;
        property.setValue("false");
        property = new Property();
        property.setName("commonAuthQueryParams");
        properties[5] = property;
        property = new Property();
        property.setName("callbackUrl");
        property.setValue("https://localhost:9943:/commonauth");
        properties[6] = property;
        property = new Property();
        property.setName("OIDCLogoutEPUrl");
        properties[7] = property;
        property = new Property();
        property.setName("IsBasicAuthEnabled");
        property.setValue("true");
        properties[8] = property;
        federatedAuthenticatorConfig.setProperties(properties);
        return federatedAuthenticatorConfig;
    }

    private void configureIDPtoFederationInServiceProvider(String consumerKey) throws Exception {
        OAuthConsumerAppDTO oAuthApplicationData = this.oAuthAdminServiceClient.getOAuthApplicationData(consumerKey);
        String applicationName = oAuthApplicationData.getApplicationName();
        ServiceProvider application = this.applicationManagementClient.getApplication(applicationName);
        application.getLocalAndOutBoundAuthenticationConfig().setSkipLogoutConsent(true);
        application.getLocalAndOutBoundAuthenticationConfig().setSkipConsent(true);
        application.getLocalAndOutBoundAuthenticationConfig().setAuthenticationType("federated");
        AuthenticationStep authStep = new AuthenticationStep();
        org.wso2.carbon.identity.application.common.model.xsd.IdentityProvider idp = new org.wso2.carbon.identity.application.common.model.xsd.IdentityProvider();
        idp.setIdentityProviderName("federated-idp");
        authStep.setFederatedIdentityProviders(new org.wso2.carbon.identity.application.common.model.xsd.IdentityProvider[]{idp});
        application.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(new AuthenticationStep[]{authStep});
        application.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(null);
        this.applicationManagementClient.updateApplication(application);
    }

    private void updateServiceProviderWithRequiredClaims(String consumerKey) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException, IdentityApplicationManagementServiceIdentityApplicationManagementException {
        String[] requestedClaims = new String[]{"http://wso2.org/claims/givenname", "http://wso2.org/claims/lastname", "http://wso2.org/claims/mobile", "http://wso2.org/claims/organization", "http://wso2.org/claims/telephone", "http://wso2.org/claims/emailaddress"};
        OAuthConsumerAppDTO oAuthApplicationData = this.oAuthAdminServiceClient.getOAuthApplicationData(consumerKey);
        String applicationName = oAuthApplicationData.getApplicationName();
        ServiceProvider application = this.applicationManagementClient.getApplication(applicationName);
        ClaimConfig claimConfig = new ClaimConfig();
        for (String claimUri : requestedClaims) {
            ClaimMapping claimMapping = new ClaimMapping();
            org.wso2.carbon.identity.application.common.model.xsd.Claim claim = new org.wso2.carbon.identity.application.common.model.xsd.Claim();
            claim.setClaimUri(claimUri);
            claimMapping.setLocalClaim(claim);
            claimMapping.setRemoteClaim(claim);
            claimMapping.setRequested(true);
            claimMapping.setMandatory(false);
            claimConfig.addClaimMappings(claimMapping);
        }
        application.setClaimConfig(claimConfig);
        this.applicationManagementClient.updateApplication(application);
    }

    private void createClaimMapping() throws ClaimMetadataManagementServiceClaimMetadataException, RemoteException, OAuthAdminServiceIdentityOAuthAdminException {
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "mobile", "http://wso2.org/claims/mobile");
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "organization", "http://wso2.org/claims/organization");
        this.oAuthAdminServiceClient.updateScope("openid", new String[]{"given_name", "family_name", "mobile", "organization", "phone_number", "email"}, new String[0]);
    }

    private void deleteClaimMapping() throws Exception {
        this.oAuthAdminServiceClient.updateScope("openid", new String[0], new String[]{"given_name", "family_name", "mobile", "organization", "phone_number", "email"});
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "organization");
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "mobile");
    }
}

