/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.jwt.idp.JWTGeneratorUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.identity.application.common.model.idp.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.LocalRole;
import org.wso2.carbon.identity.application.common.model.idp.xsd.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.RoleMapping;

public class JWTGrantTestCase
extends APIManagerLifecycleBaseTest {
    private final String jwtAudience = UUID.randomUUID().toString();
    private final String jwtIssuer = "jwtgrant_test_issuer";
    private final String keystoreFileValid = "extidpjwt.jks";
    private final String keystoreFileValidPass = "extidpjwt";
    private final String keystoreFileValidAlias = "extidpjwt";
    private final String scopeToRequest = "scope-jwt";
    private String jwtApplicationId;
    private String consumerKey;
    private String consumerSecret;
    private String scopeId;
    private String tokenUrl;
    List<String> grantTypesWithJWT = new ArrayList<String>();

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public JWTGrantTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.tokenUrl = this.getKeyManagerURLHttps() + "/oauth2/token";
        this.grantTypesWithJWT.add("urn:ietf:params:oauth:grant-type:jwt-bearer");
        String applicationName = "JWTGrantApp";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication(applicationName, "Unlimited", null, applicationName + " description");
        Assert.assertNotNull((Object)applicationDTO, (String)"consumerKey generation of the application doesn't work as expected");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationDTO.getApplicationId()), (String)"application is not created as expected");
        this.jwtApplicationId = applicationDTO.getApplicationId();
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.jwtApplicationId, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypesWithJWT);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Assert.assertNotNull((Object)this.consumerKey, (String)"consumerKey generation of the application doesn't work as expected");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"consumerSecret generation of the application doesn't work as expected");
        this.addValidIdentityProvider();
        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setName("scope-jwt");
        scopeDTO.setBindings((List)new ArrayList<String>(){
            {
                this.add("admin");
            }
        });
        scopeDTO.setDisplayName("Scope for JWT grant test");
        ScopeDTO addedScope = this.restAPIPublisher.addSharedScope(scopeDTO);
        this.scopeId = addedScope.getId();
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token with a registered IDP for it")
    public void testGenerateTokenWithValidRegisteredIDP() throws Exception {
        String jwt = this.generateJWTTokenForValidIDP();
        HttpResponse res = this.invokeTokenEndpoint(jwt);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not 200 as expected");
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't find accessToken");
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token without a registered IDP for it")
    public void testGenerateTokenForNonRegisteredIDP() throws Exception {
        String assertDescPrefix = "Checking the JWT grant with non-registered IDP as issuer, didn't get the expected ";
        String errorDescExpected = "No Registered IDP found";
        String jwt = this.generateJWTTokenForInvalidIDP();
        HttpResponse res = this.invokeTokenEndpoint(jwt);
        this.assertErrorResponse("Checking the JWT grant with non-registered IDP as issuer, didn't get the expected ", "No Registered IDP found", res);
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token which is expired")
    public void testGenerateTokenWithExpiredJWT() throws Exception {
        String assertDescPrefix = "Checking the JWT grant with expired jwt, didn't get the expected ";
        String errorDescExpected = "JSON Web Token is expired";
        String jwt = this.generateExpiredJWTToken();
        HttpResponse res = this.invokeTokenEndpoint(jwt);
        this.assertErrorResponse("Checking the JWT grant with expired jwt, didn't get the expected ", "JSON Web Token is expired", res);
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token which is tampered")
    public void testGenerateTokenWithTamperedJWT() throws Exception {
        String assertDescPrefix = "Checking the JWT grant with tampered jwt, didn't get the expected ";
        String errorDescExpected = "Signature or Message Authentication invalid";
        String jwt = this.generateTamperedJWTToken();
        HttpResponse res = this.invokeTokenEndpoint(jwt);
        this.assertErrorResponse("Checking the JWT grant with tampered jwt, didn't get the expected ", "Signature or Message Authentication invalid", res);
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token signed with a different cert not matching IDP")
    public void testGenerateTokenWithJWTSignedWithDifferentCert() throws Exception {
        String assertDescPrefix = "Checking the JWT grant with jwt signed with different cert, didn't get the expected ";
        String errorDescExpected = "Signature or Message Authentication invalid";
        String jwt = this.generateJWTTokenSignedFromDifferentCertificate();
        HttpResponse res = this.invokeTokenEndpoint(jwt);
        this.assertErrorResponse("Checking the JWT grant with jwt signed with different cert, didn't get the expected ", "Signature or Message Authentication invalid", res);
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token without IDP roles/mappings are added and try to generate a token with a scope which is restricted by a role. The Scope shouldn't be returned.", dependsOnMethods={"testGenerateTokenWithValidRegisteredIDP"})
    public void testGenerateTokenWithScopesUsingJWTBeforeAddingIdpRoles() throws Exception {
        if (this.userMode == TestUserMode.TENANT_ADMIN) {
            return;
        }
        String jwt = this.generateJWTTokenForValidIDPWithIdpRoles();
        HttpResponse res = this.invokeTokenEndpoint(jwt, new String[]{"scope-jwt"});
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not 200 as expected");
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't find accessToken");
        String scope = response.getString("scope");
        Assert.assertFalse((boolean)scope.contains("scope-jwt"), (String)"Received scopes contains requested scope (scope-jwt) even without adding role mappings to the IDP.");
    }

    @Test(groups={"wso2.am"}, description="Testing JWT grant for a JWT token with IDP roles and generate token with scope which is restricted by a role. This should succeed.", dependsOnMethods={"testGenerateTokenWithScopesUsingJWTBeforeAddingIdpRoles"})
    public void testGenerateTokenWithScopesUsingJWTWithIdpRoles() throws Exception {
        String jwt = this.generateJWTTokenForValidIDPWithIdpRoles();
        this.updateIdentityProviderWithRoleMappings("jwtgrant_test_issuer");
        HttpResponse res = this.invokeTokenEndpoint(jwt, new String[]{"scope-jwt"});
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't find accessToken");
        String scope = response.getString("scope");
        Assert.assertTrue((boolean)scope.contains("scope-jwt"), (String)"Received scopes doesn't contain requested scope (scope-jwt) even after adding role mappings to the IDP.");
    }

    private void assertErrorResponse(String assertDescPrefix, String errorDescExpected, HttpResponse res) throws JSONException {
        Assert.assertEquals((int)res.getResponseCode(), (int)400, (String)(assertDescPrefix + " 400 status code."));
        JSONObject response = new JSONObject(res.getData());
        String errorDescriptionKey = "error_description";
        String errorDescription = response.getString(errorDescriptionKey);
        Assert.assertTrue((boolean)errorDescription.contains(errorDescExpected), (String)(assertDescPrefix + "'" + errorDescExpected + "' in the error_description but was '" + errorDescription + "'"));
    }

    private HttpResponse invokeTokenEndpoint(String jwt) throws IOException {
        return this.invokeTokenEndpoint(jwt, new String[0]);
    }

    private HttpResponse invokeTokenEndpoint(String jwt, String[] scopes) throws IOException {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        HashMap<String, String> headers = new HashMap<String, String>();
        String base64EncodedAppCredentials = TokenUtils.getBase64EncodedAppCredentials((String)this.consumerKey, (String)this.consumerSecret);
        headers.put("Authorization", "Basic " + base64EncodedAppCredentials);
        urlParameters.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer"));
        urlParameters.add(new BasicNameValuePair("assertion", jwt));
        if (scopes != null && scopes.length > 0) {
            urlParameters.add(new BasicNameValuePair("scope", String.join((CharSequence)" ", scopes)));
        }
        return HTTPSClientUtils.doPost((String)this.tokenUrl, headers, urlParameters);
    }

    private String generateJWTTokenForValidIDP() throws Exception {
        return this.generateJWTTokenFromExternalIDP("extidpjwt.jks", "extidpjwt", "extidpjwt", this.jwtAudience, "jwtgrant_test_issuer", System.currentTimeMillis());
    }

    private String generateJWTTokenForValidIDPWithIdpRoles() throws Exception {
        HashMap<String, Object> idpRoles = new HashMap<String, Object>();
        idpRoles.put("http://extidp.org/claims/role", new String[]{"idp_admin"});
        return this.generateJWTTokenFromExternalIDP("extidpjwt.jks", "extidpjwt", "extidpjwt", this.jwtAudience, "jwtgrant_test_issuer", System.currentTimeMillis(), idpRoles);
    }

    private String generateJWTTokenForInvalidIDP() throws Exception {
        return this.generateJWTTokenFromExternalIDP("extidpjwt.jks", "extidpjwt", "extidpjwt", this.jwtAudience, "jwtgrant_test_issuer_invalid", System.currentTimeMillis());
    }

    private String generateJWTTokenFromExternalIDP(String keyStoreFile, String pwd, String keyAlias, String aud, String issuer, long notBeforeTime) throws Exception {
        return this.generateJWTTokenFromExternalIDP(keyStoreFile, pwd, keyAlias, aud, issuer, notBeforeTime, new HashMap<String, Object>());
    }

    private String generateJWTTokenFromExternalIDP(String keyStoreFile, String pwd, String keyAlias, String aud, String issuer, long notBeforeTime, Map<String, Object> additionalClaims) throws Exception {
        File keyStoreFileAbs = Paths.get(this.getAMResourceLocation(), "configFiles", "jwtgrant", keyStoreFile).toFile();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("azp", aud);
        attributes.put("aud", aud);
        attributes.putAll(additionalClaims);
        return JWTGeneratorUtil.generatedJWT(keyStoreFileAbs, UUID.randomUUID().toString(), keyAlias, pwd, pwd, "ext-user", issuer, notBeforeTime, attributes);
    }

    private String generateTamperedJWTToken() throws Exception {
        String jwt = this.generateJWTTokenForValidIDP();
        String[] jwtParts = jwt.split("\\.");
        String base64EncodedHeader = jwtParts[0];
        String base64EncodedPayload = jwtParts[1];
        String base64EncodedSignature = jwtParts[2];
        String jwtPayload = new String(Base64.decodeBase64((String)base64EncodedPayload), Charset.defaultCharset());
        jwtPayload = jwtPayload.replace("ext-user", "attacker");
        byte[] encoded = Base64.encodeBase64((byte[])jwtPayload.getBytes());
        return base64EncodedHeader + "." + new String(encoded).replace("=", "") + "." + base64EncodedSignature;
    }

    private String generateExpiredJWTToken() throws Exception {
        return this.generateJWTTokenFromExternalIDP("extidpjwt.jks", "extidpjwt", "extidpjwt", this.jwtAudience, "jwtgrant_test_issuer", System.currentTimeMillis() - 1800000L);
    }

    private String generateJWTTokenSignedFromDifferentCertificate() throws Exception {
        String keystoreFileInvalid = "other-keystore.jks";
        String keystoreFileInvalidPass = "wso2carbon";
        String keystoreFileInvalidAlias = "idptest";
        return this.generateJWTTokenFromExternalIDP(keystoreFileInvalid, keystoreFileInvalidPass, keystoreFileInvalidAlias, this.jwtAudience, "jwtgrant_test_issuer", System.currentTimeMillis() - 1800000L);
    }

    private void addValidIdentityProvider() throws Exception {
        this.addIdentityProvider(this.jwtAudience, "jwtgrant_test_issuer", "extidpjwt.jks", "extidpjwt", "extidpjwt");
    }

    private void addIdentityProvider(String alias, String issuer, String keystoreFile, String pwd, String certAlias) throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "jwtgrant", keystoreFile).toFile();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fileInputStream = new FileInputStream(keyStoreFile);
        keyStore.load(fileInputStream, pwd.toCharArray());
        Certificate publicCert = keyStore.getCertificate("extidpjwt");
        byte[] encoded = Base64.encodeBase64((byte[])publicCert.getEncoded());
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setEnable(true);
        identityProvider.setAlias(alias);
        identityProvider.setDisplayName("disp_name");
        identityProvider.setCertificate(new String(encoded));
        identityProvider.setIdentityProviderName(issuer);
        this.identityProviderMgtServiceClient.addIdP(identityProvider);
        String idpAddFailureError = "Identity provider was not added correctly";
        IdentityProvider addedIdp = this.identityProviderMgtServiceClient.getIdPByName("jwtgrant_test_issuer");
        Assert.assertNotNull((Object)addedIdp, (String)"Identity provider was not added correctly");
        Assert.assertEquals((String)addedIdp.getIdentityProviderName(), (String)"jwtgrant_test_issuer", (String)"Identity provider was not added correctly");
    }

    private void updateIdentityProviderWithRoleMappings(String name) throws Exception {
        IdentityProvider identityProvider = this.identityProviderMgtServiceClient.getIdPByName(name);
        identityProvider.setClaimConfig(JWTGrantTestCase.getClaimConfig());
        identityProvider.setPermissionAndRoleConfig(JWTGrantTestCase.getPermissionsAndRoleConfig());
        this.identityProviderMgtServiceClient.updateIdP(name, identityProvider);
        IdentityProvider updatedIdp = this.identityProviderMgtServiceClient.getIdPByName(name);
        Assert.assertNotNull((Object)updatedIdp.getClaimConfig());
        Assert.assertNotNull((Object)updatedIdp.getClaimConfig().getClaimMappings());
        Assert.assertEquals((int)updatedIdp.getClaimConfig().getClaimMappings().length, (int)1);
        Assert.assertNotNull((Object)updatedIdp.getPermissionAndRoleConfig());
        Assert.assertNotNull((Object)updatedIdp.getPermissionAndRoleConfig().getIdpRoles());
        Assert.assertEquals((int)updatedIdp.getPermissionAndRoleConfig().getIdpRoles().length, (int)1);
    }

    private static ClaimConfig getClaimConfig() {
        ClaimConfig claimConfig = new ClaimConfig();
        ClaimMapping[] claimMappings = new ClaimMapping[1];
        ClaimMapping claimMapping = new ClaimMapping();
        Claim localRoleClaim = new Claim();
        localRoleClaim.setClaimUri("http://wso2.org/claims/role");
        Claim idpRoleClaim = new Claim();
        idpRoleClaim.setClaimUri("http://extidp.org/claims/role");
        claimMapping.setLocalClaim(localRoleClaim);
        claimMapping.setRemoteClaim(idpRoleClaim);
        claimMappings[0] = claimMapping;
        claimConfig.setClaimMappings(claimMappings);
        claimConfig.setIdpClaims(new Claim[]{idpRoleClaim});
        claimConfig.setRoleClaimURI("http://extidp.org/claims/role");
        return claimConfig;
    }

    private static PermissionsAndRoleConfig getPermissionsAndRoleConfig() {
        PermissionsAndRoleConfig roleConfig = new PermissionsAndRoleConfig();
        roleConfig.addIdpRoles("idp_admin");
        RoleMapping roleMapping = new RoleMapping();
        LocalRole localRole = new LocalRole();
        localRole.setLocalRoleName("admin");
        roleMapping.setLocalRole(localRole);
        roleMapping.setRemoteRole("idp_admin");
        roleConfig.addRoleMappings(roleMapping);
        return roleConfig;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.jwtApplicationId);
        this.identityProviderMgtServiceClient.deleteIdP("jwtgrant_test_issuer");
        this.restAPIPublisher.removeSharedScope(this.scopeId);
        super.cleanUp();
    }
}

