/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.jwt.BackendJWTUtil;
import org.wso2.andes.util.Strings;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.identity.application.common.model.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceIdentityApplicationManagementException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceIdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceUserStoreExceptionException;
import org.wso2.carbon.user.core.UserStoreException;

public class JWTTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(JWTTestCase.class);
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private final String DEFAULT_PROFILE = "default";
    private String apiName = "JWTUserClaimAPI";
    private String apiContext = "jwtTest";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String oauthApplicationName = "OauthAppForJWTTest";
    private String jwtApplicationName = "JWTAppForJWTTest";
    private String apiKeyApplicationName = "ApiKeyAppForJWTTest";
    private String authCodeApplicationName = "AuthCodeAppForJWTTest";
    private String api2Name = "ApiKeyOnlyAPI";
    private String api2Context = "apiKeyTest";
    private String endpointURL;
    String[] users = new String[]{"subscriberUser2", "subscriberUser2@wso2.com", "subscriberUser2@abc.com"};
    String enduserPassword = "password@123";
    private String oauthApplicationId;
    private String jwtApplicationId;
    private String apiKeyApplicationId;
    private String authCodeApplicationId;
    private String apiId;
    private String api2Id;
    URL tokenEndpointURL;
    private String tokenURL;
    private String identityLoginURL;
    private final String CALLBACK_URL = "https://localhost:9443/store/";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        this.providerName = this.user.getUserName();
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        this.tokenURL = this.getKeyManagerURLHttps() + "oauth2/token";
        this.identityLoginURL = this.getKeyManagerURLHttps() + "oauth2/authorize";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication(this.oauthApplicationName, "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.oauthApplicationId = applicationDTO.getData();
        applicationDTO = this.restAPIStore.createApplication(this.jwtApplicationName, "JWT Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtApplicationId = applicationDTO.getData();
        applicationDTO = this.restAPIStore.createApplication(this.apiKeyApplicationName, "API Key Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.apiKeyApplicationId = applicationDTO.getData();
        applicationDTO = this.restAPIStore.createApplication(this.authCodeApplicationName, "Auth Code Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.authCodeApplicationId = applicationDTO.getData();
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.endpointURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.providerName);
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("oauth2");
        securitySchemes.add("api_key");
        apiRequest.setSecurityScheme(securitySchemes);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.apiId, this.oauthApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiId, this.jwtApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiId, this.apiKeyApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiId, this.authCodeApplicationId, "Gold");
        APIRequest api2Request = new APIRequest(this.api2Name, this.api2Context, new URL(this.endpointURL));
        api2Request.setVersion(this.apiVersion);
        api2Request.setVisibility("public");
        api2Request.setProvider(this.providerName);
        ArrayList<String> api2SecuritySchemes = new ArrayList<String>();
        api2SecuritySchemes.add("api_key");
        api2Request.setSecurityScheme(api2SecuritySchemes);
        this.api2Id = this.createAndPublishAPIUsingRest(api2Request, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.api2Id, this.apiKeyApplicationId, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        grantTypes.add("authorization_code");
        this.restAPIStore.generateKeys(this.oauthApplicationId, "36000", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStore.generateKeys(this.jwtApplicationId, "36000", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStore.generateAPIKeys(this.apiKeyApplicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), 36000, null, null);
        this.restAPIStore.generateKeys(this.authCodeApplicationId, "36000", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.createUser();
        this.createClaimMapping();
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), api2Request.getName(), api2Request.getVersion(), "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for Oauth Based App")
    public void testEnableJWTAndClaimsForOauthApp() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.oauthApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        for (String endUser : this.users) {
            String accessToken = this.generateUserToken(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"default"});
            log.info((Object)("Access Token Generated in oauth ==" + accessToken));
            String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + tokenJti);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            BackendJWTUtil.verifySignature(jwtheader);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            BackendJWTUtil.verifyJWTHeader(decodedJWTHeaderString);
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            Long expiry = jsonObject.getLong("exp");
            Long currentTime = System.currentTimeMillis() / 1000L;
            Assert.assertTrue((currentTime <= expiry ? 1 : 0) != 0, (String)"Token expired");
            this.checkDefaultUserClaims(jsonObject, this.oauthApplicationName);
            this.verifyUserProfileInfoClaims(jsonObject, endUser);
            BackendJWTUtil.verifyWrongClaims(jsonObject);
        }
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for JWT Based App")
    public void testEnableJWTAndClaimsForJWTApp() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        this.updateServiceProviderWithRequiredClaims(applicationKeyDTO.getConsumerKey());
        for (String endUser : this.users) {
            String accessToken = this.generateUserToken(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"openid"});
            log.info((Object)("Access Token Generated in JWT ==" + accessToken));
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + accessToken);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            BackendJWTUtil.verifySignature(jwtheader);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            BackendJWTUtil.verifyJWTHeader(decodedJWTHeaderString);
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            this.checkDefaultUserClaims(jsonObject, this.jwtApplicationName);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            String claim = jsonObject.getString("http://wso2.org/claims/givenname");
            AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name".concat(endUser)));
            claim = jsonObject.getString("http://wso2.org/claims/lastname");
            AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name".concat(endUser)));
            claim = jsonObject.getString("mobile");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("94123456987"));
            claim = jsonObject.getString("organization");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("ABC".concat(endUser)));
            BackendJWTUtil.verifyWrongClaims(jsonObject);
        }
    }

    @Test(groups={"wso2.am"}, description="Test invoking API that is secured only with 'API key' when back end JWT generation is enabled")
    public void testAPIKeyOnlySecuredAPIInvocation() throws Exception {
        APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.apiKeyApplicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), 36000, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        log.info((Object)("Access Token Generated in JWT ==" + apiKeyDTO.getApikey()));
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.api2Context, this.apiVersion));
        get.addHeader("apikey", apiKeyDTO.getApikey());
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for API Key Based App")
    public void testEnableJWTAndClaimsForAPIKeyApp() throws Exception {
        APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.apiKeyApplicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), 36000, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        log.info((Object)("Access Token Generated in JWT ==" + apiKeyDTO.getApikey()));
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("apikey", apiKeyDTO.getApikey());
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        BackendJWTUtil.verifySignature(jwtheader);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        BackendJWTUtil.verifyJWTHeader(decodedJWTHeaderString);
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        this.checkDefaultUserClaims(jsonObject, this.apiKeyApplicationName);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        String claim = jsonObject.getString("http://wso2.org/claims/apiname");
        AssertJUnit.assertTrue((String)("JWT claim API name not received " + claim), (boolean)claim.contains(this.apiName));
        claim = jsonObject.getString("http://wso2.org/claims/version");
        AssertJUnit.assertTrue((String)("JWT claim API version not received " + claim), (boolean)claim.contains(this.apiVersion));
        claim = jsonObject.getString("http://wso2.org/claims/apicontext");
        AssertJUnit.assertTrue((String)("JWT claim API context not received " + claim), (boolean)claim.contains(this.apiContext));
        BackendJWTUtil.verifyWrongClaims(jsonObject);
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation with Client Credentials Grant Type")
    public void testBackendJWTWithClientCredentialsGrant() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        String accessToken = this.generateTokenWithClientCredentialsGrant(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), new String[]{"default"});
        log.info((Object)("Access Token Generated in JWT ==" + accessToken));
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        BackendJWTUtil.verifySignature(jwtheader);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        BackendJWTUtil.verifyJWTHeader(decodedJWTHeaderString);
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        this.checkDefaultUserClaims(jsonObject, this.jwtApplicationName);
        Header activityId_request_path = this.pickHeader(responseHeaders, "in_activityid");
        Header activityId_response_path = this.pickHeader(responseHeaders, "activityid");
        Assert.assertTrue((boolean)activityId_request_path.getValue().equals(activityId_response_path.getValue()), (String)("activityid in request path ( " + activityId_request_path + ") does not match with the response path ( " + activityId_response_path + " )."));
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation with Auth Code Grant Type")
    public void testBackendJWTWithAuthCodeGrant() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.authCodeApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        for (String endUser : this.users) {
            String accessToken = this.generateTokenWithAuthCodeGrant(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"default"});
            log.info((Object)("Access Token Generated in JWT ==" + accessToken));
            String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + tokenJti);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            BackendJWTUtil.verifySignature(jwtheader);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            BackendJWTUtil.verifyJWTHeader(decodedJWTHeaderString);
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            this.checkDefaultUserClaims(jsonObject, this.authCodeApplicationName);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            this.verifyUserProfileInfoClaims(jsonObject, endUser);
            BackendJWTUtil.verifyWrongClaims(jsonObject);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (String user : this.users) {
            this.userManagementClient.deleteUser(user);
        }
        this.removeClaimMapping();
        this.restAPIStore.deleteApplication(this.oauthApplicationId);
        this.restAPIStore.deleteApplication(this.jwtApplicationId);
        this.restAPIStore.deleteApplication(this.apiKeyApplicationId);
        this.restAPIStore.deleteApplication(this.authCodeApplicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.api2Id, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.api2Id);
        super.cleanUp();
    }

    private void checkDefaultUserClaims(JSONObject jsonObject, String applicationName) throws JSONException {
        String claim = jsonObject.getString("iss");
        AssertJUnit.assertTrue((String)"JWT assertion is invalid", (boolean)claim.contains("wso2.org/products/am"));
        claim = jsonObject.getString("http://wso2.org/claims/subscriber");
        AssertJUnit.assertTrue((String)("JWT claim subscriber invalid. Received " + claim), (boolean)claim.contains(this.user.getUserName()));
        claim = jsonObject.getString("http://wso2.org/claims/applicationname");
        AssertJUnit.assertTrue((String)("JWT claim applicationname invalid. Received " + claim), (boolean)claim.contains(applicationName));
        claim = jsonObject.getString("http://wso2.org/claims/applicationtier");
        AssertJUnit.assertTrue((String)("JWT claim applicationtier invalid. Received " + claim), (boolean)claim.contains("50PerMin"));
        claim = jsonObject.getString("http://wso2.org/claims/keytype");
        AssertJUnit.assertTrue((String)("JWT claim keytype invalid. Received " + claim), (boolean)claim.contains("PRODUCTION"));
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public JWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    private void createUser() throws RemoteException, RemoteUserStoreManagerServiceUserStoreExceptionException, UserStoreException {
        for (String user : this.users) {
            this.remoteUserStoreManagerServiceClient.addUser(user, this.enduserPassword, new String[0], new ClaimValue[0], "default", false);
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/givenname", "first name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/lastname", "last name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/organization", "ABC".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/mobile", "94123456987", "default");
        }
    }

    private void createClaimMapping() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException, OAuthAdminServiceIdentityOAuthAdminException {
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "mobile", "http://wso2.org/claims/mobile");
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "organization", "http://wso2.org/claims/organization");
        this.oAuthAdminServiceClient.updateScope("openid", new String[]{"given_name", "family_name", "mobile", "organization"}, new String[0]);
    }

    private void updateServiceProviderWithRequiredClaims(String consumerKey) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException, IdentityApplicationManagementServiceIdentityApplicationManagementException {
        String[] requestedClaims = new String[]{"http://wso2.org/claims/givenname", "http://wso2.org/claims/lastname", "http://wso2.org/claims/organization", "http://wso2.org/claims/mobile"};
        OAuthConsumerAppDTO oAuthApplicationData = this.oAuthAdminServiceClient.getOAuthApplicationData(consumerKey);
        String applicationName = oAuthApplicationData.getApplicationName();
        ServiceProvider application = this.applicationManagementClient.getApplication(applicationName);
        ClaimConfig claimConfig = new ClaimConfig();
        for (String claimUri : requestedClaims) {
            ClaimMapping claimMapping = new ClaimMapping();
            Claim claim = new Claim();
            claim.setClaimUri(claimUri);
            claimMapping.setLocalClaim(claim);
            claimMapping.setRemoteClaim(claim);
            claimMapping.setRequested(true);
            claimMapping.setMandatory(true);
            claimConfig.addClaimMappings(claimMapping);
        }
        application.setClaimConfig(claimConfig);
        this.applicationManagementClient.updateApplication(application);
    }

    private void removeClaimMapping() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException, OAuthAdminServiceIdentityOAuthAdminException {
        this.oAuthAdminServiceClient.updateScope("openid", new String[0], new String[]{"given_name", "family_name", "mobile", "organization"});
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "http://wso2.org/oidc/claim/mobile");
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "http://wso2.org/oidc/claim/organization");
    }

    private String generateUserToken(String consumerKey, String consumerSecret, String enduserName, String enduserPassword, User user, String[] scopes) throws APIManagerIntegrationTestException, JSONException {
        String username = enduserName.concat("@").concat(user.getUserDomain());
        String requestBody = "grant_type=password&username=" + username + "&password=" + enduserPassword + "&scope=" + Strings.join((String)" ", (Object[])scopes);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, this.tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        return accessTokenGenerationResponse.getString("access_token");
    }

    private String generateTokenWithClientCredentialsGrant(String consumerKey, String consumerSecret, String[] scopes) throws APIManagerIntegrationTestException, JSONException {
        String requestBody = "grant_type=client_credentials&scope=" + Strings.join((String)" ", (Object[])scopes);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, this.tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        return accessTokenGenerationResponse.getString("access_token");
    }

    private String generateTokenWithAuthCodeGrant(String consumerKey, String consumerSecret, String enduserName, String enduserPassword, User user, String[] scopes) throws JSONException, IOException {
        String username = enduserName.concat("@").concat(user.getUserDomain());
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        String APPLICATION_CONTENT_TYPE = "application/x-www-form-urlencoded";
        headers.put("Content-Type", APPLICATION_CONTENT_TYPE);
        String url = this.identityLoginURL + "?response_type=code&client_id=" + consumerKey + "&scope=" + Strings.join((String)" ", (Object[])scopes) + "&redirect_uri=" + "https://localhost:9443/store/";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse res = HTTPSClientUtils.doGet((String)url, headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String LOCATION_HEADER = "Location";
        String locationHeader = (String)res.getHeaders().get(LOCATION_HEADER);
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String SET_COOKIE_HEADER = "Set-Cookie";
        String sessionNonceCookie = (String)res.getHeaders().get(SET_COOKIE_HEADER);
        Assert.assertNotNull((Object)sessionNonceCookie, (String)"Couldn't find the sessionNonceCookie Header");
        String sessionDataKey = this.getURLParameter(locationHeader, "sessionDataKey");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKey from the Location Header");
        headers.clear();
        headers.put("Content-Type", APPLICATION_CONTENT_TYPE);
        headers.put("Cookie", sessionNonceCookie);
        urlParameters.add(new BasicNameValuePair("username", username));
        urlParameters.add(new BasicNameValuePair("password", enduserPassword));
        urlParameters.add(new BasicNameValuePair("tocommonauth", "true"));
        urlParameters.add(new BasicNameValuePair("sessionDataKey", sessionDataKey));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, headers, urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get(LOCATION_HEADER);
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKeyConsent = this.getURLParameter(locationHeader, "sessionDataKeyConsent");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKeyConsent from the Location Header");
        headers.clear();
        urlParameters.clear();
        headers.put("Content-Type", APPLICATION_CONTENT_TYPE);
        headers.put("Cookie", sessionNonceCookie);
        urlParameters.add(new BasicNameValuePair("consent", "approve"));
        urlParameters.add(new BasicNameValuePair("hasApprovedAlways", "false"));
        urlParameters.add(new BasicNameValuePair("sessionDataKeyConsent", sessionDataKeyConsent));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, headers, urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get(LOCATION_HEADER);
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String tempCode = this.getURLParameter(locationHeader, "code");
        Assert.assertNotNull((Object)tempCode, (String)"Couldn't found auth code from the Location Header");
        headers.clear();
        urlParameters.clear();
        String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
        urlParameters.add(new BasicNameValuePair("grant_type", AUTHORIZATION_CODE_GRANT_TYPE));
        urlParameters.add(new BasicNameValuePair("code", tempCode));
        urlParameters.add(new BasicNameValuePair("redirect_uri", "https://localhost:9443/store/"));
        urlParameters.add(new BasicNameValuePair("client_secret", consumerSecret));
        urlParameters.add(new BasicNameValuePair("client_id", consumerKey));
        res = HTTPSClientUtils.doPost((String)this.tokenURL, headers, urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't found accessToken");
        return accessToken;
    }

    private String getURLParameter(String url, String attribute) {
        try {
            Pattern p = Pattern.compile(attribute + "=([^&]+)");
            Matcher m = p.matcher(url);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private void verifyUserProfileInfoClaims(JSONObject decodedJWTJSONObject, String endUser) throws JSONException {
        String claim = decodedJWTJSONObject.getString("http://wso2.org/claims/givenname");
        AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name".concat(endUser)));
        claim = decodedJWTJSONObject.getString("http://wso2.org/claims/lastname");
        AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name".concat(endUser)));
        claim = decodedJWTJSONObject.getString("http://wso2.org/claims/mobile");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("94123456987"));
        claim = decodedJWTJSONObject.getString("http://wso2.org/claims/organization");
        AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("ABC".concat(endUser)));
    }
}

