/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APILoggingTest
extends APIManagerLifecycleBaseTest {
    private String apiId;
    private String applicationId;

    @Factory(dataProvider="userModeDataProvider")
    public APILoggingTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, AxisFault, XPathExpressionException {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Sending http request to per API logging enabled API: ")
    public void testAPIPerAPILoggingTestcase() throws Exception {
        String logLine;
        HashMap<String, String> header = new HashMap<String, String>();
        byte[] encodedBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes(StandardCharsets.UTF_8));
        header.put("Authorization", "Basic " + new String(encodedBytes, StandardCharsets.UTF_8));
        header.put("Content-Type", "application/json");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse loggingResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis"), header);
        Assert.assertEquals((String)loggingResponse.getData(), (String)"{\"apis\":[]}");
        String API_NAME = "APILoggingTestAPI";
        String API_CONTEXT = "apiloggingtest";
        String API_TAGS = "testTag1, testTag2, testTag3";
        String API_END_POINT_POSTFIX_URL = "xmlapi";
        String API_VERSION = "1.0.0";
        String APPLICATION_NAME = "APILoggingTestApp";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(APPLICATION_NAME, "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        String apiEndPointUrl = this.getAPIInvocationURLHttp(API_END_POINT_POSTFIX_URL, API_VERSION);
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(apiEndPointUrl));
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags(API_TAGS);
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        loggingResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis"), header);
        Assert.assertEquals((String)loggingResponse.getData(), (String)("{\"apis\":[{\"context\":\"/" + API_CONTEXT + "/" + API_VERSION + "\",\"logLevel\":\"OFF\",\"apiId\":\"" + this.apiId + "\"}]}"));
        String addNewLoggerPayload = "{ \"logLevel\": \"FULL\" }";
        HTTPSClientUtils.doPut((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis/" + this.apiId), header, (String)addNewLoggerPayload);
        loggingResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/tenant-logs/carbon.super/apis?log-level=full"), header);
        Assert.assertEquals((String)loggingResponse.getData(), (String)("{\"apis\":[{\"context\":\"/" + API_CONTEXT + "/" + API_VERSION + "\",\"logLevel\":\"FULL\",\"apiId\":\"" + this.apiId + "\"}]}"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION));
        request.setHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        String apiLogFilePath = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "logs" + File.separator + "api.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((boolean)logLine.contains("INFO {API_LOG} " + API_NAME));
        }
    }

    @AfterClass(alwaysRun=true)
    void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

