/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.awaitility.Awaitility;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class CorrelationLoggingTest
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(CorrelationLoggingTest.class);
    private String apiId;
    private String applicationId;
    private ServerConfigurationManager serverConfigurationManager;
    private Map<String, String> header = new HashMap<String, String>();
    BufferedReader bufferedReader;
    private final String API_CONTEXT = "correlationloggingtest";
    private final String API_VERSION = "1.0.0";
    private final String APPLICATION_NAME = "CorrelationTestApp";
    private final String API_END_POINT_POSTFIX_URL = "xmlapi";
    private final String CORRELATION_CONFIG_PATH = "api/am/devops/v0/config/correlation";
    private final String CORRELATION_ID = "9e3ec6ed-2a37-4b20-8dd4-d5fbc754a7d9";
    private String accessToken;
    private Boolean httpLog;
    private Boolean jdbcLog;
    private Boolean synapseLog;
    private Boolean methodCallsLog;
    private Boolean correlationIDLog;
    private Boolean logHandlerStarted;

    @Factory(dataProvider="userModeDataProvider")
    public CorrelationLoggingTest(TestUserMode userMode) throws Exception {
        this.userMode = userMode;
        byte[] encodedBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes(StandardCharsets.UTF_8));
        this.header.put("Authorization", "Basic " + new String(encodedBytes, StandardCharsets.UTF_8));
        this.header.put("Content-Type", "application/json");
        this.header.put("Accept", "application/json");
        String correlationLogFilePath = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "logs" + File.separator + "correlation.log";
        this.bufferedReader = new BufferedReader(new FileReader(correlationLogFilePath));
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        AutomationContext superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverConfigurationManager = new ServerConfigurationManager(superTenantKeyManagerContext);
        log.info((Object)"Creating an application");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("CorrelationTestApp", "Test Application for Correlation Logs Test", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        log.info((Object)"Creating a test API for CorrelationLoggingTest ");
        String apiEndPointUrl = this.getAPIInvocationURLHttp("xmlapi", "1.0.0");
        log.info((Object)"Creating an API request ");
        String API_NAME = "CorrelationLoggingTestAPI";
        APIRequest apiRequest = new APIRequest(API_NAME, "correlationloggingtest", new URL(apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        String API_TAGS = "testTag1, testTag2, testTag3";
        apiRequest.setTags(API_TAGS);
        apiRequest.setProvider(this.user.getUserName());
        log.info((Object)"Creating an API and Publishing");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        log.info((Object)"Generating keys");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken());
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Testing the default correlation configs using the devops API ")
    public void testRetrieveDefaultCorrelationLoggingConfigsTest() throws Exception {
        String logLine;
        log.info((Object)("***testRetrieveDefaultCorrelationLoggingConfigsTest:userMode: " + this.userMode));
        String expectedResponse = "{\"components\":[{\"name\":\"http\",\"enabled\":\"false\",\"properties\":[]},{\"name\":\"jdbc\",\"enabled\":\"false\",\"properties\":[{\"name\":\"deniedThreads\",\"value\":[\"MessageDeliveryTaskThreadPool\",\"HumanTaskServer\",\"BPELServer\",\"CarbonDeploymentSchedulerThread\"]}]},{\"name\":\"ldap\",\"enabled\":\"false\",\"properties\":[]},{\"name\":\"synapse\",\"enabled\":\"false\",\"properties\":[]},{\"name\":\"method-calls\",\"enabled\":\"false\",\"properties\":[]}]}";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse loggingResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/config/correlation"), this.header);
        log.info((Object)("***testRetrieveDefaultCorrelationLoggingConfigsTest:actualResponse: " + loggingResponse.getData()));
        log.info((Object)("***testRetrieveDefaultCorrelationLoggingConfigsTest:expectedResponse: " + expectedResponse));
        Assert.assertEquals((String)loggingResponse.getData(), (String)expectedResponse);
        while ((logLine = this.bufferedReader.readLine()) != null) {
        }
    }

    @Test(groups={"wso2.am"}, description="Testing enabling all correlation configs using the devops API ", dependsOnMethods={"testRetrieveDefaultCorrelationLoggingConfigsTest"})
    public void testEnableAllCorrelationLoggingConfigsTest() throws Exception {
        this.configureCorrelationLoggingComponent(new String[]{"http", "synapse", "ldap", "method-calls"}, true);
        log.info((Object)("***testEnableAllCorrelationLoggingConfigsTest:userMode: " + this.userMode));
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.resetAllLogs();
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testEnableAllCorrelationLoggingConfigsTest:logLine: " + logLine));
                this.isSynapseLogLine(logLine);
                this.isHTTPLogLine(logLine);
                this.isMethodCallsLogLine(logLine);
                this.isCorrelationIDLogLine(logLine);
            }
            log.info((Object)String.format("***testEnableAllCorrelationLoggingConfigsTest:Enable: httpLog:%b, synapseLog:%b, methodCallsLog:%b, correlationIDLog:%b", this.httpLog, this.synapseLog, this.methodCallsLog, this.correlationIDLog));
            Assert.assertTrue((this.httpLog != false && this.synapseLog != false && this.methodCallsLog != false && this.correlationIDLog != false ? 1 : 0) != 0);
        });
        this.configureCorrelationLoggingComponent(new String[]{"http", "jdbc", "synapse", "ldap", "method-calls"}, false);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.resetAllLogs();
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testEnableAllCorrelationLoggingConfigsTest:logLine: " + logLine));
                this.isSynapseLogLine(logLine);
                this.isJDBCLogLine(logLine);
                this.isHTTPLogLine(logLine);
                this.isMethodCallsLogLine(logLine);
                this.isCorrelationIDLogLine(logLine);
            }
            log.info((Object)String.format("***testEnableAllCorrelationLoggingConfigsTest:Disable: httpLog:%b, synapseLog:%b, methodCallsLog:%b, correlationIDLog:%b", this.httpLog, this.synapseLog, this.methodCallsLog, this.correlationIDLog));
            Assert.assertFalse((this.httpLog != false || this.synapseLog != false || this.methodCallsLog != false || this.correlationIDLog != false ? 1 : 0) != 0);
        });
    }

    @Test(groups={"wso2.am"}, description="Testing enabling specific correlation configs using the devops API ", dependsOnMethods={"testEnableAllCorrelationLoggingConfigsTest"})
    public void testSpecificCorrelationLoggingConfigsTest() throws Exception {
        log.info((Object)"Enabling Method-calls component correlation logs");
        this.configureCorrelationLoggingComponent(new String[]{"method-calls"}, true);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.methodCallsLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testSpecificCorrelationLoggingConfigsTest:Enable method: " + logLine));
                this.isMethodCallsLogLine(logLine);
            }
            Assert.assertTrue((boolean)this.methodCallsLog);
        });
        log.info((Object)"Disabling Method-calls component correlation logs");
        this.configureCorrelationLoggingComponent(new String[]{"method-calls"}, false);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.methodCallsLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testSpecificCorrelationLoggingConfigsTest:Disable method: " + logLine));
                this.isMethodCallsLogLine(logLine);
            }
            Assert.assertFalse((boolean)this.methodCallsLog);
        });
        log.info((Object)"Enabling Synapse component correlation logs");
        this.configureCorrelationLoggingComponent(new String[]{"synapse"}, true);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.synapseLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testSpecificCorrelationLoggingConfigsTest:Enable synapse: " + logLine));
                this.isSynapseLogLine(logLine);
            }
            Assert.assertTrue((boolean)this.synapseLog);
        });
        log.info((Object)"Disabling Synapse component correlation logs");
        this.configureCorrelationLoggingComponent(new String[]{"synapse"}, false);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.synapseLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testSpecificCorrelationLoggingConfigsTest:Disable synapse: " + logLine));
                this.isSynapseLogLine(logLine);
            }
            Assert.assertFalse((boolean)this.synapseLog);
        });
    }

    @Test(groups={"wso2.am"}, description="Testing persisted correlation component configurations ", dependsOnMethods={"testSpecificCorrelationLoggingConfigsTest"})
    public void testPersistedCorrelationConfigs() throws Exception {
        log.info((Object)"Enabling http, method-calls correlation component logs before a restart");
        this.configureCorrelationLoggingComponent(new String[]{"http", "method-calls"}, true);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.httpLog = false;
            this.methodCallsLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testPersistedCorrelationConfigs:Enable:logLine: " + logLine));
                this.isHTTPLogLine(logLine);
                this.isMethodCallsLogLine(logLine);
            }
            Assert.assertTrue((this.httpLog != false && this.methodCallsLog != false ? 1 : 0) != 0);
        });
        this.serverConfigurationManager.restartGracefully();
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.logHandlerStarted = false;
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testPersistedCorrelationConfigs:Check handler start:logLine: " + logLine));
                this.isLogHandlerStarted(logLine);
            }
            Assert.assertTrue((boolean)this.logHandlerStarted);
        });
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.httpLog = false;
            this.methodCallsLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testPersistedCorrelationConfigs:Check:logLine: " + logLine));
                this.isHTTPLogLine(logLine);
                this.isMethodCallsLogLine(logLine);
            }
            Assert.assertTrue((this.httpLog != false && this.methodCallsLog != false ? 1 : 0) != 0);
        });
        this.configureCorrelationLoggingComponent(new String[]{"http", "method-calls"}, false);
        Awaitility.with().pollInterval(5L, TimeUnit.SECONDS).await().atMost(60L, TimeUnit.SECONDS).untilAsserted(() -> {
            String logLine;
            this.httpLog = false;
            this.methodCallsLog = false;
            this.InvokeTestAPI();
            while ((logLine = this.bufferedReader.readLine()) != null) {
                log.info((Object)("***testPersistedCorrelationConfigs:Disable:logLine: " + logLine));
                this.isHTTPLogLine(logLine);
                this.isMethodCallsLogLine(logLine);
            }
            Assert.assertFalse((this.httpLog != false || this.methodCallsLog != false ? 1 : 0) != 0);
        });
    }

    private void InvokeTestAPI() throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("correlationloggingtest", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        request.setHeader("activityid", "9e3ec6ed-2a37-4b20-8dd4-d5fbc754a7d9");
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
    }

    private void configureCorrelationLoggingComponent(String[] componentNames, Boolean enable) throws Exception {
        log.info((Object)("***configureCorrelationLoggingComponent:args: " + Arrays.asList(componentNames) + ", enable:" + enable));
        String[] DEFAULT_DENIED_THREADS = new String[]{"MessageDeliveryTaskThreadPool", "HumanTaskServer", "BPELServer", "CarbonDeploymentSchedulerThread"};
        String[] DEFAULT_COMPONENTS = new String[]{"http", "jdbc", "ldap", "synapse", "method-calls"};
        List<String> components = Arrays.asList(componentNames);
        JSONObject payload = new JSONObject();
        JSONArray componentArray = new JSONArray();
        for (String c : DEFAULT_COMPONENTS) {
            JSONObject componentConfigs = new JSONObject();
            componentConfigs.put("name", (Object)c);
            if (components.contains(c)) {
                componentConfigs.put("enabled", (Object)Boolean.toString(enable));
            } else {
                componentConfigs.put("enabled", (Object)"false");
            }
            JSONArray properties = new JSONArray();
            if (c.equals("jdbc")) {
                JSONObject property = new JSONObject();
                JSONArray deniedThreads = new JSONArray();
                property.put("name", (Object)"deniedThreads");
                for (String s : DEFAULT_DENIED_THREADS) {
                    deniedThreads.put((Object)s);
                }
                property.put("value", (Object)deniedThreads);
                properties.put((Object)property);
            }
            componentConfigs.put("properties", (Object)properties);
            componentArray.put((Object)componentConfigs);
        }
        payload.put("components", (Object)componentArray);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = HTTPSClientUtils.doPut((String)(this.getStoreURLHttps() + "api/am/devops/v0/config/correlation"), this.header, (String)payload.toString());
        log.info((Object)("***configureCorrelationLoggingComponent:PUT response: " + httpResponse.getData()));
        Assert.assertEquals((String)httpResponse.getData(), (String)payload.toString());
        httpResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "api/am/devops/v0/config/correlation"), this.header);
        log.info((Object)("***configureCorrelationLoggingComponent:GET response: " + httpResponse.getData()));
        Assert.assertEquals((String)httpResponse.getData(), (String)payload.toString());
    }

    private boolean isSynapseLogLine(String logLine) {
        Boolean status = logLine.contains("HTTP State Transition") || logLine.contains("ROUND-TRIP LATENCY") || logLine.contains("Thread switch latency") || logLine.contains("BACKEND LATENCY");
        if (status.booleanValue()) {
            this.synapseLog = true;
        }
        return status;
    }

    private boolean isHTTPLogLine(String logLine) {
        Boolean status = logLine.contains("HTTP");
        if (status.booleanValue()) {
            this.httpLog = true;
        }
        return status;
    }

    private boolean isJDBCLogLine(String logLine) {
        Boolean status = logLine.contains("jdbc");
        if (status.booleanValue()) {
            this.jdbcLog = true;
        }
        return status;
    }

    private boolean isMethodCallsLogLine(String logLine) {
        boolean status;
        boolean bl = status = logLine.contains("METHOD") || logLine.contains("CorrelationTestApp");
        if (status) {
            this.methodCallsLog = true;
        }
        return status;
    }

    private boolean isCorrelationIDLogLine(String logLine) {
        boolean status = logLine.contains("9e3ec6ed-2a37-4b20-8dd4-d5fbc754a7d9");
        if (status) {
            this.correlationIDLog = true;
        }
        return status;
    }

    private boolean isLogHandlerStarted(String logLine) {
        boolean status = logLine.contains("Started log handler");
        if (status) {
            this.logHandlerStarted = true;
        }
        return status;
    }

    private void resetAllLogs() {
        this.httpLog = false;
        this.synapseLog = false;
        this.jdbcLog = false;
        this.methodCallsLog = false;
        this.correlationIDLog = false;
        this.logHandlerStarted = false;
    }

    @AfterClass(alwaysRun=true)
    void destroy() throws Exception {
        this.configureCorrelationLoggingComponent(new String[]{"http", "jdbc", "synapse", "ldap", "method-calls"}, false);
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

