/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.login;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceStub;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;

public class EmailUserNameLoginTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(EmailUserNameLoginTestCase.class);
    private ServerConfigurationManager serverConfigurationManager;
    private UserManagementClient userManagementClient = null;
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String INTERNAL_ROLE_PUBLISHER = "Internal/publisher";
    private final String INTERNAL_ROLE_CREATOR = "Internal/creator";
    private APIListDTO apiListDTO = null;
    private final String TENANT_ADMIN_USERNAME = "emailuser@email.com";
    private final String PASSWORD = "emailuser@email.com";
    private final String TENANT_DOMAIN = "emailuserdomain.com";
    private final String TENANT_USER_USERNAME = "user1@email.com";

    @BeforeTest(alwaysRun=true)
    public void loadConfiguration() throws Exception {
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        String apiManagerXml = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "emailusernametest" + File.separator + "deployment.toml";
        try {
            this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
            this.serverConfigurationManager.applyConfiguration(new File(apiManagerXml));
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error while changing server configuration", (Throwable)e);
        }
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Email username login test case")
    public void LoginWithEmailUserNameTestCase() throws APIManagerIntegrationTestException, org.wso2.am.integration.clients.store.api.ApiException, XPathExpressionException, ApiException {
        boolean isSuccessful = false;
        try {
            isSuccessful = this.createTenantWithEmailUserName("emailuser@email.com", "emailuser@email.com", "emailuserdomain.com", this.publisherContext.getContextUrls().getBackEndUrl());
        }
        catch (RemoteException | XPathExpressionException | TenantMgtAdminServiceExceptionException e) {
            throw new APIManagerIntegrationTestException(e.getMessage(), e);
        }
        Assert.assertEquals((boolean)isSuccessful, (boolean)true);
        try {
            HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttps("/t/emailuserdomain.com/services"), Collections.emptyMap());
        }
        catch (IOException ignored) {
            log.error((Object)ignored);
        }
        this.restAPIPublisher = new RestAPIPublisherImpl("emailuser@email.com", "emailuser@email.com", "emailuserdomain.com", "https://localhost:9943/");
        try {
            this.apiListDTO = this.restAPIPublisher.apIsApi.getAllAPIs(null, null, "emailuserdomain.com", null, null, null, null, null);
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            throw new APIManagerIntegrationTestException("Login to Publisher with email username failed due to " + e.getMessage(), (Throwable)e);
        }
        this.restAPIStore = new RestAPIStoreImpl("emailuser@email.com", "emailuser@email.com", "emailuserdomain.com", "https://localhost:9943/");
        ApplicationListDTO responseData = this.restAPIStore.getAllApps();
        Assert.assertNotNull((Object)responseData, (String)"Login to Store with email username failed");
        this.restAPIAdmin = new RestAPIAdminImpl("emailuser@email.com", "emailuser@email.com", "emailuserdomain.com", "https://localhost:9943/");
        ApplicationThrottlePolicyListDTO listDTO = this.restAPIAdmin.applicationPolicyCollectionApi.throttlingPoliciesApplicationGet(null, null, null);
        Assert.assertNotNull((Object)listDTO, (String)"Login to Admin portal with email username failed");
    }

    @Test(groups={"wso2.am"}, description="Login with email username for tenant user", dependsOnMethods={"LoginWithEmailUserNameTestCase"})
    public void LoginWithTenantUserEmailUserNameTestCase() throws Exception {
        String fullUserName = "emailuser@email.com@emailuserdomain.com";
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), fullUserName, "emailuser@email.com");
        this.userManagementClient.addUser("user1@email.com", "emailuser@email.com", new String[]{"Internal/subscriber", "Internal/publisher", "Internal/creator"}, "user1@email.com");
        this.restAPIPublisher = new RestAPIPublisherImpl("user1@email.com", "emailuser@email.com", "emailuserdomain.com", this.publisherURLHttps);
        try {
            this.apiListDTO = this.restAPIPublisher.apIsApi.getAllAPIs(null, null, "emailuserdomain.com", null, null, null, null, null);
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            throw new APIManagerIntegrationTestException("Login to Publisher with email username failed due to " + e.getMessage(), (Throwable)e);
        }
        this.restAPIStore = new RestAPIStoreImpl("user1@email.com", "emailuser@email.com", "emailuserdomain.com", this.storeURLHttps);
        ApplicationListDTO responseData = this.restAPIStore.getAllApps();
        Assert.assertNotNull((Object)responseData, (String)"Login to Store with email username failed");
        this.restAPIAdmin = new RestAPIAdminImpl("user1@email.com", "emailuser@email.com", "emailuserdomain.com", this.adminURLHttps);
        ApplicationThrottlePolicyListDTO listDTO = this.restAPIAdmin.applicationPolicyCollectionApi.throttlingPoliciesApplicationGet(null, null, null);
        Assert.assertNotNull((Object)listDTO, (String)"Login to Admin portal with email username failed");
    }

    private boolean createTenantWithEmailUserName(String userNameWithEmail, String pwd, String domainName, String backendUrl) throws XPathExpressionException, RemoteException, TenantMgtAdminServiceExceptionException {
        boolean isSuccess = false;
        String endPoint = backendUrl + "TenantMgtAdminService";
        TenantMgtAdminServiceStub tenantMgtAdminServiceStub = new TenantMgtAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub((String)this.publisherContext.getSuperTenant().getContextUser().getUserName(), (String)this.publisherContext.getSuperTenant().getContextUser().getUserName(), (Stub)tenantMgtAdminServiceStub);
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        tenantInfoBean.setActive(true);
        tenantInfoBean.setEmail(userNameWithEmail);
        tenantInfoBean.setAdminPassword(pwd);
        tenantInfoBean.setAdmin(userNameWithEmail);
        tenantInfoBean.setTenantDomain(domainName);
        tenantInfoBean.setCreatedDate((Calendar)calendar);
        tenantInfoBean.setFirstname("emailuser first name");
        tenantInfoBean.setLastname("email user last name");
        tenantInfoBean.setSuccessKey("true");
        tenantInfoBean.setUsagePlan("demo");
        TenantInfoBean tenantInfoBeanGet = tenantMgtAdminServiceStub.getTenant(domainName);
        if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() != 0) {
            tenantMgtAdminServiceStub.activateTenant(domainName);
            log.info((Object)("Tenant domain " + domainName + " Activated successfully"));
        } else if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() == 0) {
            tenantMgtAdminServiceStub.addTenant(tenantInfoBean);
            tenantMgtAdminServiceStub.activateTenant(domainName);
            log.info((Object)("Tenant domain " + domainName + " created and activated successfully"));
            log.info((Object)("Tenant domain " + domainName + " created and activated successfully"));
            isSuccess = true;
        } else {
            log.info((Object)("Tenant domain " + domainName + " already registered"));
        }
        return isSuccess;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @AfterTest(alwaysRun=true)
    public void restoreConfiguration() throws Exception {
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

