/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.login;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class PasswordChangeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(PasswordChangeTestCase.class);
    private final String USER_NAME = "user1";
    private final String CURRENT_USER_PASSWORD = "password123";
    private final String NEW_USER_PASSWORD = "123password";
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";

    @Factory(dataProvider="userModeDataProvider")
    public PasswordChangeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.userManagementClient.addUser("user1", "password123", new String[]{"Internal/subscriber"}, null);
    }

    @Test(groups={"wso2.am"}, description="Change devportal user password")
    public void testChangeSubscriberUserPassword() throws Exception {
        String tenantDomain = this.storeContext.getContextTenant().getDomain();
        this.restAPIStore = new RestAPIStoreImpl("user1", "password123", tenantDomain, "https://localhost:9943/");
        HttpResponse changePasswordResponse = this.restAPIStore.changePassword("password123", "123password");
        org.testng.Assert.assertEquals((int)changePasswordResponse.getResponseCode(), (int)200, (String)("Error in making the subscriber user password change request:" + changePasswordResponse.getResponseMessage()));
        try {
            new RestAPIStoreImpl("user1", "123password", tenantDomain, "https://localhost:9943/");
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Password change has not been executed correctly. New password is not honored. Error occurred: " + e.getMessage()));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.userManagementClient.deleteUser("user1");
    }
}

