/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.oas;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.tests.oas.OASBaseUtils;

public class OAS3Utils {
    public static void validateSwaggerDataInPublisher(APIDTO apidto, String oasDefinition) throws Exception {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(oasDefinition, null, null);
        OpenAPI openAPI = parseAttemptForV3.getOpenAPI();
        Map extensions = openAPI.getExtensions();
        OASBaseUtils.validateSwaggerExtensionDataInPublisher(extensions, apidto);
    }

    public static void validateOperationCount(APIDTO apidto, String oasDefinition) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(oasDefinition, null, null);
        OpenAPI openAPI = parseAttemptForV3.getOpenAPI();
        int count = 0;
        for (Map.Entry entry : openAPI.getPaths().entrySet()) {
            PathItem path = (PathItem)entry.getValue();
            count += path.readOperations().size();
        }
        Assert.assertEquals((long)apidto.getOperations().size(), (long)count);
    }

    public static void validateResourcesOfOASDefinition(APIDTO apidto, String oasDefinition) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(oasDefinition, null, null);
        OpenAPI openAPI = parseAttemptForV3.getOpenAPI();
        Assert.assertNotNull((Object)openAPI);
        for (APIOperationsDTO operation : apidto.getOperations()) {
            Paths paths = openAPI.getPaths();
            Assert.assertNotNull((Object)paths);
            PathItem path = (PathItem)paths.get(operation.getTarget());
            Assert.assertNotNull((Object)path);
            Operation oasOperation = (Operation)path.readOperationsMap().get(PathItem.HttpMethod.valueOf((String)operation.getVerb()));
            Assert.assertNotNull((Object)oasOperation);
            for (String scope : operation.getScopes()) {
                boolean found = false;
                List securities = oasOperation.getSecurity();
                Assert.assertNotNull((Object)securities);
                for (Map aSec : securities) {
                    List defaultScopes = (List)aSec.get("default");
                    if (defaultScopes == null) continue;
                    Assert.assertTrue((boolean)((List)aSec.get("default")).contains(scope));
                    found = true;
                    break;
                }
                if (found) continue;
                Assert.fail((String)"Security not found");
            }
            Map ex = oasOperation.getExtensions();
            Assert.assertNotNull((Object)ex);
            Assert.assertEquals((Object)operation.getAuthType(), ex.get("x-auth-type"));
            Assert.assertEquals((Object)operation.getThrottlingPolicy(), ex.get("x-throttling-tier"));
        }
    }

    public static void validateSwaggerDataInStore(String oasDefinition) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(oasDefinition, null, null);
        OpenAPI openAPI = parseAttemptForV3.getOpenAPI();
        Map extensions = openAPI.getExtensions();
        if (extensions != null) {
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-auth-header"));
            Assert.assertFalse((boolean)extensions.containsKey("x-throttling-tier"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-cors"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-production-endpoints"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-sandbox-endpoints"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-transports"));
        }
        Paths paths = openAPI.getPaths();
        Assert.assertNotNull((Object)paths);
        for (String pathKey : paths.keySet()) {
            PathItem path = (PathItem)paths.get(pathKey);
            Map operationMap = path.readOperationsMap();
            for (Map.Entry entry : operationMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                Map opsExMap = operation.getExtensions();
                if (operationMap == null) continue;
                Assert.assertFalse((boolean)opsExMap.containsKey("x-mediation-script"));
            }
        }
    }

    public static void validateUpdatedDefinition(String originalDefinition, String publisherDefinition) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(originalDefinition, null, null);
        OpenAPI originalObj = parseAttemptForV3.getOpenAPI();
        parseAttemptForV3 = openAPIV3Parser.readContents(publisherDefinition, null, null);
        OpenAPI updatedObj = parseAttemptForV3.getOpenAPI();
        Assert.assertEquals((long)originalObj.getPaths().size(), (long)updatedObj.getPaths().size());
        for (Map.Entry entry : originalObj.getPaths().entrySet()) {
            PathItem originalPath = (PathItem)entry.getValue();
            PathItem updatedPath = (PathItem)updatedObj.getPaths().get(entry.getKey());
            Map originalOperationMap = originalPath.readOperationsMap();
            Map updatedOperationMap = updatedPath.readOperationsMap();
            Assert.assertEquals((long)originalOperationMap.size(), (long)updatedOperationMap.size());
            for (Map.Entry opEntry : originalOperationMap.entrySet()) {
                Operation originalOperation = (Operation)opEntry.getValue();
                Operation updatedOperation = (Operation)updatedOperationMap.get(opEntry.getKey());
                Assert.assertEquals((Object)originalOperation, (Object)updatedOperation);
            }
        }
    }

    public static void validateUpdatedDefinition(String original, APIDTO apidto) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult parseAttemptForV3 = openAPIV3Parser.readContents(original, null, null);
        OpenAPI originalObj = parseAttemptForV3.getOpenAPI();
        Map<String, Map<String, APIOperationsDTO>> updatedPaths = OASBaseUtils.getMapFromDTO(apidto);
        Assert.assertEquals((long)originalObj.getPaths().size(), (long)updatedPaths.size());
        for (Map.Entry entry : originalObj.getPaths().entrySet()) {
            PathItem originalPath = (PathItem)entry.getValue();
            Map<String, APIOperationsDTO> updatedOps = updatedPaths.get(entry.getKey());
            Map originalOperationMap = originalPath.readOperationsMap();
            Assert.assertEquals((long)originalOperationMap.size(), (long)updatedOps.size());
            for (Map.Entry opEntry : originalOperationMap.entrySet()) {
                Operation originalOperation = (Operation)opEntry.getValue();
                APIOperationsDTO updatedOperation = updatedOps.get(((PathItem.HttpMethod)opEntry.getKey()).name());
                Assert.assertNotNull((Object)updatedOperation);
                if (updatedOperation.getScopes() != null && !updatedOperation.getScopes().isEmpty()) {
                    Assert.assertEquals(((List)((SecurityRequirement)originalOperation.getSecurity().get(0)).get((Object)"default")).get(0), updatedOperation.getScopes().get(0));
                    continue;
                }
                Assert.assertTrue((boolean)((List)((SecurityRequirement)originalOperation.getSecurity().get(0)).get((Object)"default")).isEmpty());
            }
        }
    }
}

