/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.oas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OASBaseUtils {
    public static void validateSwaggerExtensionDataInPublisher(Map<String, Object> extensions, APIDTO apidto) {
        String authorizationHeader = apidto.getAuthorizationHeader();
        if (authorizationHeader == null) {
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-auth-header"));
        } else {
            Assert.assertTrue((boolean)extensions.containsKey("x-wso2-auth-header"));
            Assert.assertEquals((Object)authorizationHeader, (Object)extensions.get("x-wso2-auth-header"));
        }
        if (apidto.getApiThrottlingPolicy() != null) {
            Assert.assertTrue((boolean)extensions.containsKey("x-throttling-tier"));
            Assert.assertEquals((Object)apidto.getApiThrottlingPolicy(), (Object)extensions.get("x-throttling-tier"));
        } else {
            Assert.assertFalse((boolean)extensions.containsKey("x-throttling-tier"));
        }
        String context = apidto.getContext() + "/" + apidto.getVersion();
        String organization = MultitenantUtils.getTenantDomain((String)apidto.getProvider());
        if (!"carbon.super".equals(organization) && !context.contains("/t/" + organization)) {
            context = "/t/" + organization + "" + context;
        }
        Assert.assertEquals((Object)context, (Object)extensions.get("x-wso2-basePath"));
        Assert.assertTrue((boolean)extensions.containsKey("x-wso2-cors"));
        Assert.assertTrue((boolean)extensions.containsKey("x-wso2-production-endpoints"));
        Assert.assertTrue((boolean)extensions.containsKey("x-wso2-sandbox-endpoints"));
        Assert.assertTrue((boolean)extensions.containsKey("x-wso2-transports"));
    }

    public static Map<String, Map<String, APIOperationsDTO>> getMapFromDTO(APIDTO apidto) {
        List dtos = apidto.getOperations();
        HashMap<String, Map<String, APIOperationsDTO>> map = new HashMap<String, Map<String, APIOperationsDTO>>();
        for (APIOperationsDTO dto : dtos) {
            Map ops;
            if (!map.containsKey(dto.getTarget())) {
                map.put(dto.getTarget(), new HashMap());
            }
            if ((ops = (Map)map.get(dto.getTarget())).containsKey(dto.getVerb())) continue;
            ops.put(dto.getVerb(), dto);
        }
        return map;
    }
}

