/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.operationPolicy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationPoliciesDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDataDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;

public class OperationPolicyTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(OperationPolicyTestCase.class);
    private final String API_NAME = "AddNewPolicyAndInvokeAPITest";
    private final String API_CONTEXT = "AddNewPolicyAndInvokeAPI";
    private final String API_END_POINT_POSTFIX_URL = "xmlapi";
    private final String TEST_POLICY_NAME = "customCommonLogPolicy";
    private final String TEST_JSON_POLICY_NAME = "customCommonLogJSONPolicy";
    private final String JSON_POLICY_TYPE = "JSON";
    private final String YAML_POLICY_TYPE = "YAML";
    private final String TEST_INVALID_POLICY_NAME = "customCommonLogPolicyInvalid";
    private final String TEST_POLICY_VERSION = "v1";
    private final int TEST_POLICY_LIMIT = 100;
    private final char[] PUBLISHER_USER_PASS = "pass@123".toCharArray();
    private String publisherUser = "importExportPublisher";
    private String applicationId;
    private String apiId;
    private String newVersionAPIId;
    private String accessToken;
    private Map<String, String> policyMap;
    private File exportedOperationPolicyZip;
    private String exportUrl;
    private RestAPIPublisherImpl restAPIPublisherExport;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("ApplicationTest", "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.policyMap = this.restAPIPublisher.getAllCommonOperationPolicies();
        String apiEndPointUrl = this.getAPIInvocationURLHttp("xmlapi", "1.0.0");
        APIRequest apiRequest = new APIRequest("AddNewPolicyAndInvokeAPITest", "AddNewPolicyAndInvokeAPI", new URL(apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.exportUrl = this.publisherURLHttps + "api/am/publisher/v4" + "/operation-policies/export";
        this.restAPIPublisherExport = new RestAPIPublisherImpl("admin", "admin", "carbon.super", this.publisherURLHttps);
    }

    @Test(groups={"wso2.am"}, description="Add common operation policy")
    public void testAddNewCommonOperationPolicy() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse addPolicyResponse = this.addPolicy(null, "customCommonLogPolicy.json", "customCommonLogPolicy.j2");
        Assert.assertNotNull((Object)addPolicyResponse, (String)"Error adding operation policy customCommonLogPolicy");
        Assert.assertEquals((int)addPolicyResponse.getResponseCode(), (int)201, (String)"Response code mismatched");
        OperationPolicyDataDTO policyDTO = (OperationPolicyDataDTO)new Gson().fromJson(addPolicyResponse.getData(), OperationPolicyDataDTO.class);
        String newPolicyId = policyDTO.getId();
        Assert.assertNotNull((Object)newPolicyId, (String)"Policy Id is null");
        Map updatedCommonPolicyMap = this.restAPIPublisher.getAllCommonOperationPolicies();
        Assert.assertNotNull(updatedCommonPolicyMap.get("customCommonLogPolicy"), (String)"Unable to find the newly added common policy");
        this.policyMap.put("customCommonLogPolicy", newPolicyId);
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Common API Policy", dependsOnMethods={"testAddNewCommonOperationPolicy"})
    public void testCommonOperationPolicyExport() throws Exception {
        this.exportedOperationPolicyZip = this.exportCommonOperationPolicyArtifact("customCommonLogPolicy", "v1", "YAML", true);
        String extractedCommonAPIPolicyDir = this.exportedOperationPolicyZip.getParent();
        try {
            ZipFile zipFile = new ZipFile(this.exportedOperationPolicyZip);
            zipFile.extractAll(extractedCommonAPIPolicyDir);
        }
        catch (ZipException e) {
            throw new APIManagerIntegrationTestException("Error in extracting the exported API archive.", (Throwable)e);
        }
        String yamlPolicySpecPath = extractedCommonAPIPolicyDir + File.separator + "customCommonLogPolicy" + File.separator + "customCommonLogPolicy" + ".yaml";
        File policySpecFile = new File(yamlPolicySpecPath);
        Assert.assertTrue((boolean)policySpecFile.exists(), (String)"API Policy Specification file does not exist");
        String synapseDefinitionPath = extractedCommonAPIPolicyDir + File.separator + "customCommonLogPolicy" + File.separator + "customCommonLogPolicy" + ".j2";
        File synapseDefFile = new File(synapseDefinitionPath);
        Assert.assertTrue((boolean)synapseDefFile.exists(), (String)"Synapse Definition file does not exist");
        StringBuilder contentBuilderForPolicySpec = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(yamlPolicySpecPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForPolicySpec.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted api file " + yamlPolicySpecPath, (Throwable)e);
        }
        String policySpecContent = contentBuilderForPolicySpec.toString();
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object operationPolicySpec = yamlReader.readValue(policySpecContent, Object.class);
        String expectedPolicySpecPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + "customCommonLogPolicy" + ".yaml";
        StringBuilder contentBuilderForExpectedPolicySpec = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(expectedPolicySpecPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForExpectedPolicySpec.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted api file " + expectedPolicySpecPath, (Throwable)e);
        }
        String expectedPolicySpecContent = contentBuilderForExpectedPolicySpec.toString();
        yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object expectedOperationPolicySpec = yamlReader.readValue(expectedPolicySpecContent, Object.class);
        Assert.assertEquals((Object)operationPolicySpec, (Object)expectedOperationPolicySpec, (String)"Exported & Expected Policy Specifications are not matching");
        StringBuilder contentBuilderForSynapseDef = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(synapseDefinitionPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForSynapseDef.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted api file " + synapseDefinitionPath, (Throwable)e);
        }
        String synapseDefContent = contentBuilderForSynapseDef.toString();
        yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object synapseDefinition = yamlReader.readValue(synapseDefContent, Object.class);
        String expectedSynapsePolicyDefPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + "customCommonLogPolicy" + ".j2";
        StringBuilder contentBuilderForExpectedSynapseDef = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(expectedSynapsePolicyDefPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForExpectedSynapseDef.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted api file " + expectedSynapsePolicyDefPath, (Throwable)e);
        }
        String expectedSynapseDefinitionContent = contentBuilderForExpectedSynapseDef.toString();
        yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object expectedSynapseDefinition = yamlReader.readValue(expectedSynapseDefinitionContent, Object.class);
        Assert.assertEquals((Object)synapseDefinition, (Object)expectedSynapseDefinition, (String)"Exported & Expected Synapse Definitions are not matching");
    }

    @Test(groups={"wso2.am"}, description="Exporting Non Existing Common API Policy", dependsOnMethods={"testCommonOperationPolicyExport"})
    public void testNonExistingCommonOperationPolicyExport() throws Exception {
        this.exportCommonOperationPolicyArtifact("customCommonLogPolicyInvalid", "v1", "YAML", false);
    }

    @Test(groups={"wso2.am"}, description="Delete common operation policy", dependsOnMethods={"testNonExistingCommonOperationPolicyExport"})
    public void testDeleteCommonOperationPolicy() throws Exception {
        int responseCode = this.deleteOperationPolicy(this.policyMap.get("customCommonLogPolicy"), null);
        Assert.assertEquals((int)responseCode, (int)200);
        Map updatedCommonPolicyMap = this.restAPIPublisher.getAllCommonOperationPolicies();
        Assert.assertNull(updatedCommonPolicyMap.get("customCommonLogPolicy"));
        this.policyMap.remove("customCommonLogPolicy");
    }

    @Test(groups={"wso2.am"}, description="Import common operation policy", dependsOnMethods={"testDeleteCommonOperationPolicy"})
    public void testImportNewCommonOperationPolicy() throws Exception {
        ApiResponse importPolicyResponse = this.restAPIPublisher.importOperationPolicy(this.exportedOperationPolicyZip);
        Assert.assertNotNull((Object)importPolicyResponse, (String)"Error adding operation policy customCommonLogPolicy");
        Assert.assertEquals((int)importPolicyResponse.getStatusCode(), (int)201, (String)"Response code mismatched");
        Map commonPolicyMap = this.restAPIPublisher.getAllCommonOperationPolicies(100);
        Assert.assertNotNull(commonPolicyMap.get("customCommonLogPolicy"), (String)"Unable to find the newly added common policy");
        this.policyMap.put("customCommonLogPolicy", (String)commonPolicyMap.get("customCommonLogPolicy"));
    }

    @Test(groups={"wso2.am"}, description="Import existing common operation policy", dependsOnMethods={"testImportNewCommonOperationPolicy"})
    public void testImportExistingCommonOperationPolicy() {
        try {
            this.restAPIPublisher.importOperationPolicy(this.exportedOperationPolicyZip);
        }
        catch (ApiException ex) {
            Assert.assertEquals((int)ex.getCode(), (int)409, (String)"Response code mismatched");
        }
    }

    @Test(groups={"wso2.am"}, description="Import invalid common operation policy", dependsOnMethods={"testImportExistingCommonOperationPolicy"})
    public void testImportInvalidCommonOperationPolicy() throws Exception {
        int res;
        String yamlPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + "customCommonLogPolicyInvalid" + ".yaml";
        String j2Path = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + "customCommonLogPolicy" + ".j2";
        File directory = wiremock.com.google.common.io.Files.createTempDir();
        String zipDirectoryName = directory.getParentFile().getAbsolutePath() + File.separator + "customCommonLogPolicy" + "_" + "v1";
        directory.delete();
        directory = new File(zipDirectoryName);
        directory.mkdir();
        String destYaml = directory.getAbsolutePath() + File.separator + "customCommonLogPolicy" + ".yaml";
        String destJ2 = directory.getAbsolutePath() + File.separator + "customCommonLogPolicy" + ".j2";
        FileReader fileReader = new FileReader(yamlPath);
        FileWriter fileWriter = new FileWriter(destYaml);
        while ((res = fileReader.read()) != -1) {
            fileWriter.write(res);
        }
        fileReader.close();
        fileWriter.close();
        fileReader = new FileReader(j2Path);
        fileWriter = new FileWriter(destJ2);
        while ((res = fileReader.read()) != -1) {
            fileWriter.write(res);
        }
        fileReader.close();
        fileWriter.close();
        File directoryToZip = new File(directory.getAbsolutePath());
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = directoryToZip.listFiles();
        if (files != null) {
            for (File file : files) {
                fileList.add(file);
            }
        }
        this.writeArchiveFile(directoryToZip, fileList);
        File zipFileToBeExported = new File(directoryToZip.getAbsolutePath() + ".zip");
        try {
            this.restAPIPublisher.importOperationPolicy(zipFileToBeExported);
        }
        catch (ApiException ex) {
            Assert.assertEquals((int)ex.getCode(), (int)500, (String)"Response code mismatched");
        }
    }

    @Test(groups={"wso2.am"}, description="Exporting Sample Common API Policy with JSON Policy Definition", dependsOnMethods={"testImportExistingCommonOperationPolicy"})
    public void testCommonOperationPolicyExportWithJSONContent() throws Exception {
        this.exportedOperationPolicyZip = this.exportCommonOperationPolicyArtifact("customCommonLogPolicy", "v1", "JSON", true);
        String extractedCommonAPIPolicyDir = this.exportedOperationPolicyZip.getParent();
        try {
            ZipFile zipFile = new ZipFile(this.exportedOperationPolicyZip);
            zipFile.extractAll(extractedCommonAPIPolicyDir);
        }
        catch (ZipException e) {
            throw new APIManagerIntegrationTestException("Error in extracting the exported API archive.", (Throwable)e);
        }
        String jsonPolicySpecPath = extractedCommonAPIPolicyDir + File.separator + "customCommonLogPolicy" + File.separator + "customCommonLogPolicy" + ".json";
        File policySpecFile = new File(jsonPolicySpecPath);
        Assert.assertTrue((boolean)policySpecFile.exists(), (String)"API Policy Specification file does not exist");
        String synapseDefinitionPath = extractedCommonAPIPolicyDir + File.separator + "customCommonLogPolicy" + File.separator + "customCommonLogPolicy" + ".j2";
        File synapseDefFile = new File(synapseDefinitionPath);
        Assert.assertTrue((boolean)synapseDefFile.exists(), (String)"Synapse Definition file does not exist");
        StringBuilder contentBuilderForPolicySpec = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(jsonPolicySpecPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForPolicySpec.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from extracted API Policy file " + jsonPolicySpecPath, (Throwable)e);
        }
        String policySpecContent = contentBuilderForPolicySpec.toString();
        ObjectMapper jsonReader = new ObjectMapper();
        Object operationPolicySpec = jsonReader.readValue(policySpecContent, Object.class);
        String expectedPolicySpecPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + "customCommonLogJSONPolicy" + ".json";
        StringBuilder contentBuilderForExpectedPolicySpec = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(expectedPolicySpecPath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilderForExpectedPolicySpec.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in reading from expected Policy Specification file " + expectedPolicySpecPath, (Throwable)e);
        }
        String expectedPolicySpecContent = contentBuilderForExpectedPolicySpec.toString();
        jsonReader = new ObjectMapper();
        Object expectedOperationPolicySpec = jsonReader.readValue(expectedPolicySpecContent, Object.class);
        Assert.assertEquals((Object)operationPolicySpec, (Object)expectedOperationPolicySpec, (String)"Exported & Expected Policy Specifications are not matching");
    }

    @Test(groups={"wso2.am"}, description="Add API specific operation policy")
    public void testAddAPISpecificOperationPolicy() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse addPolicyResponse = this.addPolicy(this.apiId, "customAPISpecificLogPolicy.json", "customAPISpecificLogPolicy.j2");
        Assert.assertNotNull((Object)addPolicyResponse, (String)"Error adding operation policy customAPISpecificLogPolicy");
        Assert.assertEquals((int)addPolicyResponse.getResponseCode(), (int)201, (String)"Response code mismatched");
        OperationPolicyDataDTO policyDTO = (OperationPolicyDataDTO)new Gson().fromJson(addPolicyResponse.getData(), OperationPolicyDataDTO.class);
        String newPolicyId = policyDTO.getId();
        Assert.assertNotNull((Object)newPolicyId, (String)"Policy Id is null");
        Map apiSpecificPolicyMap = this.restAPIPublisher.getAllAPISpecificOperationPolicies(this.apiId);
        Assert.assertTrue((apiSpecificPolicyMap.size() > 0 ? 1 : 0) != 0);
        this.policyMap.put("customAPISpecificLogPolicy", newPolicyId);
    }

    @Test(groups={"wso2.am"}, description="Add another API specific operation policy with same name", dependsOnMethods={"testAddAPISpecificOperationPolicy"})
    public void testAddAPISpecificOperationPolicyWithSamePolicyName() throws Exception {
        try {
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse addPolicyResponse = this.addPolicy(this.apiId, "customAPISpecificLogPolicy.json", "customAPISpecificLogPolicy.j2");
            Assert.assertNotEquals((Object)addPolicyResponse.getResponseCode(), (Object)201);
        }
        catch (ApiException e) {
            this.log.error((Object)e);
        }
    }

    @Test(groups={"wso2.am"}, description="Delete API specific operation policy", dependsOnMethods={"testAddAPISpecificOperationPolicyWithSamePolicyName"})
    public void testDeleteAPISpecificOperationPolicy() throws Exception {
        int responseCode = this.deleteOperationPolicy(this.policyMap.get("customAPISpecificLogPolicy"), this.apiId);
        Assert.assertEquals((int)responseCode, (int)200);
        Map updatedAPISpecificPolicyMap = this.restAPIPublisher.getAllAPISpecificOperationPolicies(this.apiId);
        Assert.assertNull(updatedAPISpecificPolicyMap.get("customAPISpecificLogPolicy"));
        this.policyMap.remove("customAPISpecificLogPolicy");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API before adding the log mediation")
    public void testAPIInvocationBeforeAddingNewOperationPolicy() throws Exception {
        HttpResponse invokeAPIResponse = this.invokeAPI("1.0.0");
        Assert.assertEquals((int)invokeAPIResponse.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((int)invokeAPIResponse.getHeaders("TestHeader").length, (int)0);
        Assert.assertEquals((String)invokeAPIResponse.getHeaders("Content-Type")[0].getValue(), (String)"application/xml; charset=UTF-8");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the add header operation policy", dependsOnMethods={"testAPIInvocationBeforeAddingNewOperationPolicy"})
    public void testAPIInvocationAfterAddingNewOperationPolicy() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        String policyName = "addHeader";
        Assert.assertNotNull((Object)this.policyMap.get(policyName), (String)("Unable to find a common policy with name " + policyName));
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("headerName", "TestHeader");
        attributeMap.put("headerValue", "TestValue");
        APIOperationPoliciesDTO apiOperationPoliciesDTO = new APIOperationPoliciesDTO();
        apiOperationPoliciesDTO.setRequest(this.getPolicyList(policyName, this.policyMap, attributeMap));
        apiOperationPoliciesDTO.setResponse(this.getPolicyList(policyName, this.policyMap, attributeMap));
        ((APIOperationsDTO)apidto.getOperations().get(0)).setOperationPolicies(apiOperationPoliciesDTO);
        this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        HttpResponse invokeAPIResponse = this.invokeAPI("1.0.0");
        Assert.assertEquals((String)invokeAPIResponse.getHeaders("TestHeader")[0].getValue(), (String)"TestValue");
    }

    @Test(groups={"wso2.am"}, description="Validate the common operation policy clone at the update", dependsOnMethods={"testAPIInvocationAfterAddingNewOperationPolicy"})
    public void testCommonOperationPolicyCloneToAPILevelWithUpdate() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        String clonedPolicyId = ((OperationPolicyDTO)((APIOperationsDTO)apidto.getOperations().get(0)).getOperationPolicies().getRequest().get(0)).getPolicyId();
        Assert.assertNotEquals((Object)clonedPolicyId, (Object)this.policyMap.get("addHeader"));
        OperationPolicyDataDTO commonPolicy = this.restAPIPublisher.getCommonOperationPolicy(this.policyMap.get("addHeader"));
        OperationPolicyDataDTO clonedPolicy = this.restAPIPublisher.getAPISpecificOperationPolicy(clonedPolicyId, this.apiId);
        Assert.assertEquals((String)commonPolicy.getMd5(), (String)clonedPolicy.getMd5());
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the add header operation policy", dependsOnMethods={"testCommonOperationPolicyCloneToAPILevelWithUpdate"})
    public void testOperationPolicyAdditionWithMissingAttributes() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        String policyName = "removeHeader";
        Assert.assertNotNull((Object)this.policyMap.get(policyName), (String)("Unable to find a common policy with name " + policyName));
        APIOperationPoliciesDTO apiOperationPoliciesDTO = new APIOperationPoliciesDTO();
        apiOperationPoliciesDTO.setRequest(this.getPolicyList(policyName, this.policyMap, null));
        apiOperationPoliciesDTO.setResponse(this.getPolicyList(policyName, this.policyMap, null));
        ((APIOperationsDTO)apidto.getOperations().get(0)).setOperationPolicies(apiOperationPoliciesDTO);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateResponse = this.restAPIPublisher.updateAPIWithHttpInfo(apidto);
        Assert.assertEquals((int)updateResponse.getResponseCode(), (int)500);
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the add header operation policy", dependsOnMethods={"testCommonOperationPolicyCloneToAPILevelWithUpdate"})
    public void testAddOperationPolicyForNotSupportedFlow() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        String policyName = "jsonFault";
        Assert.assertNotNull((Object)this.policyMap.get(policyName), (String)("Unable to find a common policy with name " + policyName));
        APIOperationPoliciesDTO apiOperationPoliciesDTO = new APIOperationPoliciesDTO();
        apiOperationPoliciesDTO.setRequest(this.getPolicyList(policyName, this.policyMap, null));
        apiOperationPoliciesDTO.setResponse(this.getPolicyList(policyName, this.policyMap, null));
        ((APIOperationsDTO)apidto.getOperations().get(0)).setOperationPolicies(apiOperationPoliciesDTO);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateResponse = this.restAPIPublisher.updateAPIWithHttpInfo(apidto);
        Assert.assertEquals((int)updateResponse.getResponseCode(), (int)500);
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the add header operation policy", dependsOnMethods={"testAPIInvocationAfterAddingNewOperationPolicy"})
    public void testCreateNewVersionAfterAddingOperationPolicy() throws Exception {
        String newVersion = "2.0.0";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI(newVersion, this.apiId, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
        this.newVersionAPIId = newVersionResponse.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getNewAPIResponse = this.restAPIPublisher.getAPI(this.newVersionAPIId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getNewAPIResponse.getData(), APIDTO.class);
        Assert.assertNotNull((Object)((APIOperationsDTO)apidto.getOperations().get(0)).getOperationPolicies(), (String)"Unable to find a operation policies for the new version");
        Assert.assertNotNull((Object)((APIOperationsDTO)apidto.getOperations().get(0)).getOperationPolicies().getRequest(), (String)"Unable to find a operation policies for the new version request flow");
        String newVersionClonedPolicyId = ((OperationPolicyDTO)((APIOperationsDTO)apidto.getOperations().get(0)).getOperationPolicies().getRequest().get(0)).getPolicyId();
        Assert.assertNotEquals((Object)newVersionClonedPolicyId, (Object)this.policyMap.get("addHeader"));
        OperationPolicyDataDTO clonedPolicy = this.restAPIPublisher.getAPISpecificOperationPolicy(newVersionClonedPolicyId, this.newVersionAPIId);
        Assert.assertNotNull((Object)clonedPolicy);
        this.createAPIRevisionAndDeployUsingRest(this.newVersionAPIId, this.restAPIPublisher);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiLifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.newVersionAPIId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)apiLifecycleChangeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to change lifecycle stage to PUBLISHED for the new version " + this.newVersionAPIId));
        this.waitForAPIDeployment();
        this.subscribeToAPIUsingRest(this.newVersionAPIId, this.applicationId, "Unlimited", this.restAPIStore);
        HttpResponse invokeAPIResponse = this.invokeAPI(newVersion);
        Assert.assertEquals((String)invokeAPIResponse.getHeaders("TestHeader")[0].getValue(), (String)"TestValue");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the add header operation policy", dependsOnMethods={"testCreateNewVersionAfterAddingOperationPolicy"})
    public void testAPIInvocationAfterAddingNewMultipleOperationPolicies() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        APIOperationPoliciesDTO apiOperationPoliciesDTO = new APIOperationPoliciesDTO();
        ArrayList<OperationPolicyDTO> requestPolicyList = new ArrayList<OperationPolicyDTO>();
        ArrayList<OperationPolicyDTO> responsePolicyList = new ArrayList<OperationPolicyDTO>();
        String[] policyList = new String[]{"disableChunking", "jsonToXML", "xmlToJson"};
        String policyName = "addHeader";
        Assert.assertNotNull((Object)this.policyMap.get(policyName), (String)("Unable to find a common policy with name " + policyName));
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("headerName", "TestHeader");
        attributeMap.put("headerValue", "TestValue");
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)this.policyMap.get(policyList[i]), (String)("Unable to find a common policy with name " + policyList[i]));
            requestPolicyList.add(this.getPolicyList(policyList[i], this.policyMap, null).get(0));
            responsePolicyList.add(this.getPolicyList(policyList[i], this.policyMap, null).get(0));
        }
        requestPolicyList.add(this.getPolicyList(policyName, this.policyMap, attributeMap).get(0));
        responsePolicyList.add(this.getPolicyList(policyName, this.policyMap, attributeMap).get(0));
        apiOperationPoliciesDTO.setRequest(requestPolicyList);
        apiOperationPoliciesDTO.setResponse(responsePolicyList);
        ((APIOperationsDTO)apidto.getOperations().get(0)).setOperationPolicies(apiOperationPoliciesDTO);
        this.restAPIPublisher.updateAPI(apidto);
        HttpResponse invokeAPIResponse = this.invokeAPI("1.0.0");
        Assert.assertEquals((String)invokeAPIResponse.getHeaders("TestHeader")[0].getValue(), (String)"TestValue");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.newVersionAPIId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newVersionAPIId);
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addPolicy(String apiId, String policySpecName, String policyDefinitionName) throws ApiException {
        String policySpecPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + policySpecName;
        String synapsePolicyDefPath = this.getAMResourceLocation() + File.separator + "operationPolicy" + File.separator + policyDefinitionName;
        File specification = new File(policySpecPath);
        File synapseDefinition = new File(synapsePolicyDefPath);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse addPolicyResponse = apiId == null ? this.restAPIPublisher.addCommonOperationPolicy(specification, synapseDefinition, null) : this.restAPIPublisher.addAPISpecificOperationPolicy(apiId, specification, synapseDefinition, null);
        return addPolicyResponse;
    }

    private File exportCommonOperationPolicyArtifact(String policyName, String policyVersion, String format, boolean isValid) throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + policyName + "&version=" + policyVersion + "&format=" + format);
        File zipTempDir = com.google.common.io.Files.createTempDir();
        String fileName = policyName + "_" + policyVersion;
        File apiZip = new File(zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportArtifact(exportRequest, apiZip, isValid);
        return apiZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportArtifact(URL exportRequest, File fileName, boolean isValid) throws URISyntaxException, IOException {
        CloseableHttpResponse response = this.exportAPIRequest(exportRequest);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (FileOutputStream outStream = new FileOutputStream(fileName);){
                entity.writeTo((OutputStream)outStream);
            }
        }
        if (isValid) {
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Response code is not as expected");
        } else {
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)404, (String)"Response code is not as expected");
        }
        Assert.assertTrue((boolean)fileName.exists(), (String)"File save was not successful");
    }

    private CloseableHttpResponse exportAPIRequest(URL exportRequest) throws IOException, URISyntaxException {
        CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();
        HttpGet get = new HttpGet(exportRequest.toURI());
        String accessToken = this.restAPIPublisherExport.getAccessToken();
        get.addHeader("Authorization", "Bearer " + accessToken);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        return response;
    }

    public int deleteOperationPolicy(String policyId, String apiId) throws ApiException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse deletePolicyResponse = apiId == null ? this.restAPIPublisher.deleteCommonOperationPolicy(policyId) : this.restAPIPublisher.deleteAPISpecificPolicy(policyId, apiId);
        return deletePolicyResponse.getResponseCode();
    }

    public List<OperationPolicyDTO> getPolicyList(String policyName, Map<String, String> policyMap, Map<String, Object> attributeMap) {
        ArrayList<OperationPolicyDTO> policyList = new ArrayList<OperationPolicyDTO>();
        OperationPolicyDTO policyDTO = new OperationPolicyDTO();
        policyDTO.setPolicyName(policyName);
        policyDTO.setPolicyId(policyMap.get(policyName));
        policyDTO.setParameters(attributeMap);
        policyList.add(policyDTO);
        return policyList;
    }

    public HttpResponse invokeAPI(String version) throws XPathExpressionException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewPolicyAndInvokeAPI", version));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        return response;
    }

    private void writeArchiveFile(File directoryToZip, List<File> fileList) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(directoryToZip.getPath() + ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            this.addToArchive(directoryToZip, file, zipOutputStream);
        }
        zipOutputStream.close();
    }

    private void addToArchive(File directoryToZip, File file, ZipOutputStream zipOutputStream) throws IOException {
        byte[] bytes = wiremock.com.google.common.io.Files.toByteArray((File)file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1);
        if (File.separatorChar != '/') {
            zipFilePath = zipFilePath.replace(File.separatorChar, '/');
        }
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(bytes, 0, bytes.length);
        zipOutputStream.closeEntry();
    }
}

