/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.APICategoryDTO;
import org.wso2.am.integration.clients.admin.api.dto.APICategoryListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APICategoriesTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APICategoriesTestCase.class);
    private AdminApiTestHelper adminApiTestHelper;
    private APICategoryDTO apiCategoryDTO;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APICategoriesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add API category")
    public void testAddAPICategory() throws Exception {
        String name = "Marketing";
        String description = "Marketing category";
        this.apiCategoryDTO = DtoFactory.createApiCategoryDTO((String)name, (String)description);
        ApiResponse addedApiCategory = this.restAPIAdmin.addApiCategory(this.apiCategoryDTO);
        Assert.assertEquals((int)addedApiCategory.getStatusCode(), (int)201);
        APICategoryDTO addedApiCategoryDTO = (APICategoryDTO)addedApiCategory.getData();
        String apiCategoryId = addedApiCategoryDTO.getId();
        Assert.assertNotNull((Object)apiCategoryId, (String)"The api category ID cannot be null or empty");
        this.apiCategoryDTO.setId(apiCategoryId);
        this.adminApiTestHelper.verifyApiCategoryDTO(this.apiCategoryDTO, addedApiCategoryDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add API category without Name", dependsOnMethods={"testAddAPICategory"})
    public void testAddAPICategoryWithoutName() {
        String description = "Marketing Category";
        APICategoryDTO apiCategoryDTO = DtoFactory.createApiCategoryDTO(null, (String)description);
        try {
            ApiResponse addedAPICategory = this.restAPIAdmin.addApiCategory(apiCategoryDTO);
            Assert.assertNotEquals((Object)addedAPICategory.getStatusCode(), (Object)201, (String)"API category was added without a name");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API category Name With Special Characters", dependsOnMethods={"testAddAPICategoryWithoutName"})
    public void testAddAPICategoryNameWithSpecialCharacters() {
        String name = "Marketing Category";
        String description = "This is Marketing Category";
        APICategoryDTO apiCategoryDTO = DtoFactory.createApiCategoryDTO((String)name, (String)description);
        try {
            ApiResponse addedAPICategory = this.restAPIAdmin.addApiCategory(apiCategoryDTO);
            Assert.assertNotEquals((Object)addedAPICategory.getStatusCode(), (Object)201, (String)"API category was added with special characters in the name");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API category with duplicate name", dependsOnMethods={"testAddAPICategoryNameWithSpecialCharacters"})
    public void addAPICategoryWithDuplicateName() {
        try {
            ApiResponse addedApiCategory = this.restAPIAdmin.addApiCategory(this.apiCategoryDTO);
            Assert.assertNotEquals((Object)addedApiCategory.getStatusCode(), (Object)201, (String)"Duplicate API category was added");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Category with name 'Marketing' already exists"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test update API category", dependsOnMethods={"addAPICategoryWithDuplicateName"})
    public void testUpdateAPICategory() throws Exception {
        String newDescription = "This is marketing category";
        this.apiCategoryDTO.setDescription(newDescription);
        ApiResponse updatedApiCategory = this.restAPIAdmin.updateApiCategory(this.apiCategoryDTO.getId(), this.apiCategoryDTO);
        APICategoryDTO updatedApiCategoryDTO = (APICategoryDTO)updatedApiCategory.getData();
        Assert.assertEquals((int)updatedApiCategory.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyApiCategoryDTO(this.apiCategoryDTO, updatedApiCategoryDTO);
    }

    @Test(groups={"wso2.am"}, description="Test get API categories", dependsOnMethods={"testUpdateAPICategory"})
    public void testGetAPICategoriesFromAdminAPI() throws Exception {
        ApiResponse retrievedApiCategories = this.restAPIAdmin.getApiCategories();
        Assert.assertEquals((int)retrievedApiCategories.getStatusCode(), (int)200);
        APICategoryListDTO apiCategoryListDTO = (APICategoryListDTO)retrievedApiCategories.getData();
        List apiCategoryDTOS = apiCategoryListDTO.getList();
        for (APICategoryDTO apiCategory : apiCategoryDTOS) {
            this.adminApiTestHelper.verifyApiCategoryDTO(this.apiCategoryDTO, apiCategory);
        }
    }

    @Test(groups={"wso2.am"}, description="Test attach API category to API", dependsOnMethods={"testGetAPICategoriesFromAdminAPI"})
    public void testAttachAPICategoryToAPI() throws Exception {
        String apiName = "CategoryTestAPI";
        String apiContext = "category";
        String apiVersion = "1.0";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse postResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = postResponse.getData();
        ArrayList<String> apiCategories = new ArrayList<String>();
        apiCategories.add("Marketing");
        apiRequest.setApiCategories(apiCategories);
        HttpResponse updateResponse = this.restAPIPublisher.updateAPI(apiRequest, this.apiId);
        this.waitForAPIDeployment();
        HttpResponse getResponse = this.restAPIPublisher.getAPI(updateResponse.getData());
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(getResponse.getData(), APIDTO.class);
        List categoriesInReceivedAPI = apidto.getCategories();
        Assert.assertNotNull((Object)categoriesInReceivedAPI);
        Assert.assertTrue((boolean)categoriesInReceivedAPI.contains("Marketing"));
        this.removeAPICategoryFromAPI(apiRequest);
    }

    private void removeAPICategoryFromAPI(APIRequest apiRequest) throws Exception {
        ArrayList apiCategories = new ArrayList();
        apiRequest.setApiCategories(apiCategories);
        this.restAPIPublisher.updateAPI(apiRequest, this.apiId);
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Test delete API category", dependsOnMethods={"testGetAPICategoriesFromAdminAPI"})
    public void testDeleteAPICategory() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteApiCategory(this.apiCategoryDTO.getId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

