/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.BlockingConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.BlockingConditionStatusDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIDenyPolicyTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIDenyPolicyTestCase.class);
    private BlockingConditionDTO blockingConditionDTO;
    private List<String> addedPolicyIds = new ArrayList<String>();
    private ArrayList<String> grantTypes;
    private String invokingAPIId;

    @Factory(dataProvider="userModeDataProvider")
    public APIDenyPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.grantTypes = new ArrayList();
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
    }

    @Test(groups={"wso2.am"}, description="Test add API deny policy")
    public void testAddAPIDenyPolicy() throws Exception {
        String apiName = "DenyPolicyTestAPI";
        String apiContext = "deny";
        String apiVersion = "1.0";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse postResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiId = postResponse.getData();
        this.waitForAPIDeployment();
        boolean conditionStatus = true;
        String conditionValue = "/deny/1.0";
        this.blockingConditionDTO = new BlockingConditionDTO();
        this.blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        this.blockingConditionDTO.setConditionValue((Object)conditionValue);
        this.blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.API);
        ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(this.blockingConditionDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        BlockingConditionDTO addedBlockingConditionDTO = (BlockingConditionDTO)addedPolicy.getData();
        String policyId = addedBlockingConditionDTO.getConditionId();
        Assert.assertNotNull((Object)policyId, (String)"The deny policy ID cannot be null or empty");
        this.blockingConditionDTO.setConditionId(policyId);
    }

    @Test(groups={"wso2.am"}, description="Test get API deny policy", dependsOnMethods={"testAddAPIDenyPolicy"})
    public void testGetAddedDenyPolicy() throws ApiException {
        ApiResponse response = this.restAPIAdmin.getDenyThrottlingPolicy(this.blockingConditionDTO.getConditionId());
        String retrievedConditionId = ((BlockingConditionDTO)response.getData()).getConditionId();
        Assert.assertEquals((String)this.blockingConditionDTO.getConditionId(), (String)retrievedConditionId);
    }

    @Test(groups={"wso2.am"}, description="Test add API deny policy with non existing context", dependsOnMethods={"testGetAddedDenyPolicy"})
    public void testAddDenyPolicyWithNonExistingContext() {
        boolean conditionStatus = true;
        String conditionValue = "/denyNonExisting/1.0.0/";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.API);
        try {
            ApiResponse apiResponse = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Couldn't Save Block Condition Due to Invalid API Context /denyNonExisting/1.0.0/"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API deny policy with the same name", dependsOnMethods={"testAddDenyPolicyWithNonExistingContext"})
    public void testAddAPIDenyPolicyWithTheSameContext() {
        boolean conditionStatus = true;
        String conditionValue = "/deny/1.0";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.API);
        try {
            ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
            Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201, (String)"Duplicated Context Deny Policy Added");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
            Assert.assertTrue((boolean)e.getResponseBody().contains("A black list item with type: API, value: /deny/1.0 already exists"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test update API deny policy", dependsOnMethods={"testAddAPIDenyPolicyWithTheSameContext"})
    public void testUpdateAPIDenyPolicyStatus() throws ApiException {
        String denyPolicyId = this.blockingConditionDTO.getConditionId();
        String conditionType = this.blockingConditionDTO.getConditionType().toString();
        boolean conditionStatus = false;
        BlockingConditionStatusDTO blockingConditionStatusDTO = new BlockingConditionStatusDTO();
        blockingConditionStatusDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionStatusDTO.setConditionId(denyPolicyId);
        ApiResponse updatedCondition = this.restAPIAdmin.updateDenyThrottlingPolicy(denyPolicyId, conditionType, blockingConditionStatusDTO);
        Assert.assertEquals((int)updatedCondition.getStatusCode(), (int)200);
        BlockingConditionDTO updatedBlockedCondition = (BlockingConditionDTO)updatedCondition.getData();
        Assert.assertEquals((boolean)updatedBlockedCondition.isConditionStatus(), (boolean)conditionStatus);
    }

    @Test(groups={"wso2.am"}, description="Test delete API deny policy", dependsOnMethods={"testUpdateAPIDenyPolicyStatus"})
    public void testDeleteAPIDenyPolicy() throws ApiException {
        String denyPolicyId = this.blockingConditionDTO.getConditionId();
        ApiResponse response = this.restAPIAdmin.deleteDenyThrottlingPolicy(denyPolicyId);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test add API Application Vise deny policy", dependsOnMethods={"testDeleteAPIDenyPolicy"})
    public void testAddAPIDenyPolicyApplicationVise() throws Exception {
        String userName = this.user.getUserName();
        HttpResponse applicationResponse = this.restAPIStore.createApplication("denyPolicyCheckApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        boolean conditionStatus = true;
        String conditionValue = userName + ":denyPolicyCheckApp";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.APPLICATION);
        ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        BlockingConditionDTO addedBlockingConditionDTO = (BlockingConditionDTO)addedPolicy.getData();
        String policyId = addedBlockingConditionDTO.getConditionId();
        Assert.assertNotNull((Object)policyId, (String)"The deny policy ID cannot be null or empty");
        this.restAPIAdmin.deleteDenyThrottlingPolicy(policyId);
        this.restAPIStore.deleteApplication(applicationResponse.getData());
    }

    @Test(groups={"wso2.am"}, description="Test add API Deny Policy to Non Existing Application", dependsOnMethods={"testAddAPIDenyPolicyApplicationVise"})
    public void testAddAPIDenyPolicyToNonExistingApplication() {
        String userName = this.user.getUserName();
        boolean conditionStatus = true;
        String conditionValue = userName + ":NonExistingApp";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.APPLICATION);
        try {
            ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
            Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201, (String)"Deny Policy Added without a non-existing application");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API User Vise deny policy", dependsOnMethods={"testAddAPIDenyPolicyToNonExistingApplication"})
    public void testAddAPIDenyPolicyUserVise() throws Exception {
        boolean conditionStatus = true;
        String conditionValue = "admin";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.USER);
        ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        BlockingConditionDTO addedBlockingConditionDTO = (BlockingConditionDTO)addedPolicy.getData();
        String policyId = addedBlockingConditionDTO.getConditionId();
        Assert.assertNotNull((Object)policyId, (String)"The deny policy ID cannot be null or empty");
        this.restAPIAdmin.deleteDenyThrottlingPolicy(policyId);
    }

    @Test(groups={"wso2.am"}, description="Test add API Deny Policy to Invalid User", dependsOnMethods={"testAddAPIDenyPolicyUserVise"})
    public void testAddAPIDenyPolicyWithInvalidUser() {
        boolean conditionStatus = true;
        String conditionValue = "nonExistingAdmin";
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue((Object)conditionValue);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.USER);
        try {
            ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
            Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201, (String)"Deny Policy Added with an invalid IP");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API IP Address Vise deny policy", dependsOnMethods={"testAddAPIDenyPolicyWithInvalidUser"})
    public void testAddAPIDenyPolicyIPAddressWise() throws Exception {
        boolean conditionStatus = true;
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        valueMap.put("invert", false);
        valueMap.put("fixedIp", "127.0.0.1");
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue(valueMap);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.IP);
        ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        BlockingConditionDTO addedBlockingConditionDTO = (BlockingConditionDTO)addedPolicy.getData();
        String policyId = addedBlockingConditionDTO.getConditionId();
        Assert.assertNotNull((Object)policyId, (String)"The deny policy ID cannot be null or empty");
        this.restAPIAdmin.deleteDenyThrottlingPolicy(policyId);
    }

    @Test(groups={"wso2.am"}, description="Test add API deny policy with invalid IP Address", dependsOnMethods={"testAddAPIDenyPolicyIPAddressWise"})
    public void testAddAPIDenyPolicyInvalidIPAddress() {
        boolean conditionStatus = true;
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        valueMap.put("invert", false);
        valueMap.put("fixedIp", "127..0.0.1");
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue(valueMap);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.IP);
        try {
            ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
            Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201, (String)"Deny Policy Added with an invalid IP");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Test add API IP Address Range Vise deny policy", dependsOnMethods={"testAddAPIDenyPolicyInvalidIPAddress"})
    public void testAddAPIDenyPolicyIPRangeWise() throws Exception {
        boolean conditionStatus = true;
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        valueMap.put("invert", false);
        valueMap.put("startingIp", "127.0.0.1");
        valueMap.put("endingIp", "127.0.0.5");
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue(valueMap);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.IPRANGE);
        ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        BlockingConditionDTO addedBlockingConditionDTO = (BlockingConditionDTO)addedPolicy.getData();
        String policyId = addedBlockingConditionDTO.getConditionId();
        Assert.assertNotNull((Object)policyId, (String)"The deny policy ID cannot be null or empty");
        this.restAPIAdmin.deleteDenyThrottlingPolicy(policyId);
    }

    @Test(groups={"wso2.am"}, description="Test add API deny policy with invalid Ip Address range", dependsOnMethods={"testAddAPIDenyPolicyIPRangeWise"})
    public void testAddAPIDenyPolicyInvalidIPAddressRange() {
        boolean conditionStatus = true;
        LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
        valueMap.put("startingIp", "127..0.0.1");
        valueMap.put("endingIp", "127.0.0.5");
        BlockingConditionDTO blockingConditionDTO = new BlockingConditionDTO();
        blockingConditionDTO.setConditionStatus(Boolean.valueOf(conditionStatus));
        blockingConditionDTO.setConditionValue(valueMap);
        blockingConditionDTO.setConditionType(BlockingConditionDTO.ConditionTypeEnum.IP);
        try {
            ApiResponse addedPolicy = this.restAPIAdmin.addDenyThrottlingPolicy(blockingConditionDTO);
            Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201, (String)"Deny Policy Added with an invalid IP");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (String conditionId : this.addedPolicyIds) {
            this.restAPIAdmin.deleteDenyThrottlingPolicy(conditionId);
        }
        super.cleanUp();
    }
}

