/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIInvocationFailureTestCase
extends APIMIntegrationBaseTest {
    private String publisherURLHttp;
    private APIPublisherRestClient apiPublisher;
    private String APIName = "TokenInvocationTestAPI";
    private String APIContext = "tokenInvocationTestAPI";
    private String tags = "youtube, token, media";
    private String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private String description = "This is test API create by API manager integration test";
    private String APIVersion = "1.0.0";
    private String apiID;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
    }

    @Test(groups={"wso2.am"}, description="Calling API with invalid token")
    public void APIInvocationFailure() throws Exception {
        String providerName = this.user.getUserName();
        APIRequest apiRequest = new APIRequest(this.APIName, this.APIContext, new URL(this.url));
        apiRequest.setTags(this.tags);
        apiRequest.setProvider(providerName);
        apiRequest.setDescription(this.description);
        apiRequest.setVersion(this.APIVersion);
        apiRequest.setSandbox(this.url);
        apiRequest.setResourceMethod("GET");
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        this.apiID = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        serviceResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.PUBLISH.getAction(), null);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer xxxxxxxxxxxx");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.APIContext, this.APIVersion) + "/most_popular"), requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("900901"), (String)"Error code mismach");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiID);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIInvocationFailureTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

