/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIM4765ResourceOrderInSwagger
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIM4765ResourceOrderInSwagger.class);
    private String apiId;
    private final String SWAGGER_FOLDER = "swagger";

    @Factory(dataProvider="userModeDataProvider")
    public APIM4765ResourceOrderInSwagger(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Test resource order in the swagger")
    public void swaggerResourceOrderTest() throws Exception {
        String APIName = "SwaggerReorderTest";
        String APIContext = "swagger_reorder_test";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        String resourcePath = "artifacts" + File.separator + "AM" + File.separator + "swagger" + File.separator + "ordered_resources_api_oas.json";
        String swagger = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath), (String)"UTF-8");
        String orderedResourcesFilePath = "artifacts" + File.separator + "AM" + File.separator + "swagger" + File.separator + "ordered_resources_paths.json";
        String orderedResources = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(orderedResourcesFilePath), (String)"UTF-8");
        this.restAPIPublisher.updateSwagger(this.apiId, swagger);
        String storeDefinition = this.restAPIStore.getSwaggerByID(this.apiId, this.user.getUserDomain());
        boolean isResourceOrderEqual = storeDefinition.contains(orderedResources);
        Assert.assertTrue((boolean)isResourceOrderEqual, (String)"Resource order is not equal to the given order.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        super.cleanUp();
    }
}

