/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APICorsConfigurationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER3965TestCase
extends APIManagerLifecycleBaseTest {
    private String apiName = "APIMANAGER3965";
    private String apiContext = "apimanager3965";
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String apiId;
    APIRequest apiRequest;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER3965TestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String backendEndPoint = this.getBackendEndServiceEndPointHttp("jaxrs_basic/services/customers/customerservice");
        this.apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(backendEndPoint));
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreationWithOutCorsConfiguration() throws Exception {
        this.apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(this.apiContext + "/1.0.0/customers/123");
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpOptions option = new HttpOptions(apiInvocationUrl);
        option.addHeader("Origin", "http://localhost:9443");
        option.addHeader("Access-Control-Request-Method", "GET");
        HttpResponse serviceResponse = httpclient.execute((HttpUriRequest)option);
        String accessControlAllowOrigin = serviceResponse.getFirstHeader("Access-Control-Allow-Origin").getValue();
        String accessControlAllowHeaders = serviceResponse.getFirstHeader("Access-Control-Allow-Headers").getValue();
        String accessControlAllowMethods = serviceResponse.getFirstHeader("Access-Control-Allow-Methods").getValue();
        Assert.assertEquals((int)serviceResponse.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertEquals((String)accessControlAllowOrigin, (String)"*", (String)"Access Control allow origin values get mismatched in option Call");
        Assert.assertEquals((String)accessControlAllowHeaders, (String)"authorization,Access-Control-Allow-Origin,Content-Type,SOAPAction,Authorization", (String)"Access Control allow Headers values get mismatched in option Call");
        Assert.assertTrue((accessControlAllowMethods.contains("GET") && !accessControlAllowMethods.contains("POST") && !accessControlAllowMethods.contains("DELETE") && !accessControlAllowMethods.contains("PUT") && !accessControlAllowMethods.contains("PATCH") ? 1 : 0) != 0, (String)"Access Control allow Method values get mismatched in option Call");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testAPICreationWithOutCorsConfiguration"})
    public void testAPICreationWithCorsConfiguration() throws Exception {
        JSONObject corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : true, \"accessControlAllowOrigins\" : [\"https://localhost:9443,http://localhost:8080\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\", \"SOAPAction\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId, this.user.getUserDomain());
        ArrayList<String> accessControlAllowOrigins = new ArrayList<String>();
        accessControlAllowOrigins.add("https://localhost:9443");
        accessControlAllowOrigins.add("http://localhost:8080");
        ArrayList<String> accessControlAllowHeadersList = new ArrayList<String>();
        accessControlAllowHeadersList.add("Access-Control-Allow-Origin");
        accessControlAllowHeadersList.add("authorization");
        accessControlAllowHeadersList.add("Content-Type");
        accessControlAllowHeadersList.add("SOAPAction");
        ArrayList<String> accessControlAllowMethodsList = new ArrayList<String>();
        accessControlAllowMethodsList.add("PATCH");
        accessControlAllowMethodsList.add("GET");
        accessControlAllowMethodsList.add("DELETE");
        accessControlAllowMethodsList.add("OPTIONS");
        accessControlAllowMethodsList.add("PUT");
        APICorsConfigurationDTO apiCorsConfigurationDTO = apiDto.getCorsConfiguration();
        apiCorsConfigurationDTO.setCorsConfigurationEnabled(Boolean.valueOf(true));
        apiCorsConfigurationDTO.setAccessControlAllowOrigins(accessControlAllowOrigins);
        apiCorsConfigurationDTO.setAccessControlAllowCredentials(Boolean.valueOf(true));
        apiCorsConfigurationDTO.setAccessControlAllowHeaders(accessControlAllowHeadersList);
        apiCorsConfigurationDTO.setAccessControlAllowMethods(accessControlAllowMethodsList);
        apiDto.setCorsConfiguration(apiCorsConfigurationDTO);
        this.restAPIPublisher.updateAPI(apiDto);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(this.apiContext + "/1.0.0/customers/123");
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpOptions option = new HttpOptions(apiInvocationUrl);
        option.addHeader("Origin", "http://localhost:8080");
        option.addHeader("Access-Control-Request-Method", "GET");
        HttpResponse serviceResponse = httpclient.execute((HttpUriRequest)option);
        String accessControlAllowOrigin = serviceResponse.getFirstHeader("Access-Control-Allow-Origin").getValue();
        String accessControlAllowHeaders = serviceResponse.getFirstHeader("Access-Control-Allow-Headers").getValue();
        String accessControlAllowMethods = serviceResponse.getFirstHeader("Access-Control-Allow-Methods").getValue();
        String accessControlAllowCredentials = serviceResponse.getFirstHeader("Access-Control-Allow-Credentials").getValue();
        Assert.assertEquals((int)serviceResponse.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertEquals((String)accessControlAllowOrigin, (String)"http://localhost:8080", (String)"Access Control allow origin values get mismatched in option Call");
        Assert.assertEquals((String)accessControlAllowHeaders, (String)"Access-Control-Allow-Origin,authorization,Content-Type,SOAPAction,Authorization", (String)"Access Control allow Headers values get mismatched in option Call");
        Assert.assertTrue((accessControlAllowMethods.contains("GET") && !accessControlAllowMethods.contains("POST") && !accessControlAllowMethods.contains("DELETE") && !accessControlAllowMethods.contains("PUT") && !accessControlAllowMethods.contains("PATCH") ? 1 : 0) != 0, (String)"Access Control allow Method values get mismatched in option Call");
        Assert.assertEquals((String)accessControlAllowCredentials, (String)"true", (String)"Access Control allow Credentials values get mismatched in option Call");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

