/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;

public class APIMANAGER4081PaginationCountTestCase
extends APIMIntegrationBaseTest {
    private String tenantDomain = "paginationtest.com";
    private int numberOfAPIs = 5;
    private int numberOfPublisherAPIs = 15;
    private List<String> createdAPIs = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(APIMANAGER4081PaginationCountTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() {
        try {
            super.init();
            this.tenantManagementServiceClient.addTenant(this.tenantDomain, this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), "demo");
        }
        catch (XPathExpressionException e) {
            Assert.fail((String)"Error occurred while retrieving context. Pagination count test case failed.");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.fail((String)"Error occurred while adding tenant. Pagination count test case failed.");
        }
        catch (RemoteException e) {
            Assert.fail((String)"Error occurred while creating session. Pagination count test case failed.");
        }
        catch (TenantMgtAdminServiceExceptionException e) {
            Assert.fail((String)"Error while getting tenant management service. Pagination count test case failed.");
        }
    }

    @Test(groups={"wso2.am"}, description="Pagination test case")
    public void testPaginationWithMultipleVersions() throws Exception {
        HashMap<Integer, String[]> versionsOfAPIs = new HashMap<Integer, String[]>();
        String[] api1Versions = new String[]{"1.0", "2.0.1", "1.0.2", "3.0"};
        String[] api2Versions = new String[]{"1.0.1", "2.0.0", "1.0.3", "2.1.0"};
        String[] api3Versions = new String[]{"1.0.0b", "2.0.1c", "2.0.1a", "2.0.1d"};
        String[] api4Versions = new String[]{"1.0.0-SNAPSHOT", "1.1.0-SNAPSHOT", "1.0.1-SNAPSHOT", "2.0.0-SNAPSHOT"};
        String[] api5Versions = new String[]{"1.0.0.wso2v1", "2.0.0.wso2v1", "1.1.3.wso2v1", "2.0.0.wso2v2"};
        versionsOfAPIs.put(1, api1Versions);
        versionsOfAPIs.put(2, api2Versions);
        versionsOfAPIs.put(3, api3Versions);
        versionsOfAPIs.put(4, api4Versions);
        versionsOfAPIs.put(5, api5Versions);
        int counter = 0;
        while (counter < versionsOfAPIs.size()) {
            String[] apiVersionsArray = (String[])versionsOfAPIs.get(++counter);
            int numberOfVersions = apiVersionsArray.length;
            String apiId = "";
            for (int i = 0; i < numberOfVersions; ++i) {
                String APIName = "PaginationTestVersionedAPI" + Integer.toString(counter);
                String APIContext = "paginationTestVersioned" + Integer.toString(counter);
                String tags = "pagination";
                String providerName = this.publisherContext.getContextTenant().getTenantAdmin().getUserName();
                String url = "https://localhost:9443/test";
                String description = "This is test API create by API manager integration test";
                String APIVersion = apiVersionsArray[i];
                APIListDTO devportalAPIs = new APIListDTO();
                this.waitForAPIDeployment();
                APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
                apiRequest.setTags(tags);
                apiRequest.setDescription(description);
                apiRequest.setVersion(APIVersion);
                apiRequest.setSandbox(url);
                apiRequest.setResourceMethod("GET");
                if (i < 1) {
                    APIDTO createdAPI = this.restAPIPublisher.addAPI(apiRequest, "v2");
                    if (createdAPI != null) {
                        apiId = createdAPI.getId();
                        this.createdAPIs.add(createdAPI.getId());
                    } else {
                        Assert.fail((String)("API creation has failed for APIName=" + APIName + " APIVersion=" + APIVersion));
                    }
                } else {
                    apiId = this.restAPIPublisher.createNewAPIVersion(APIVersion, apiId, false);
                    if (i == 2 && (devportalAPIs = this.restAPIStore.getAllAPIs()).getList() != null) {
                        for (APIInfoDTO apiInfoDTO : devportalAPIs.getList()) {
                            if (!APIName.equals(apiInfoDTO.getName()) || !providerName.equals(apiInfoDTO.getProvider())) continue;
                            Assert.assertEquals((String)apiInfoDTO.getVersion(), (String)((String[])versionsOfAPIs.get(counter))[i - 1]);
                        }
                    }
                    if (i > 1) {
                        this.createdAPIs.add(apiId);
                    }
                }
                int publisherAPIsCount = 3 * (counter - 1) + (i + 1);
                publisherAPIsCount = i == 3 ? publisherAPIsCount - 1 : publisherAPIsCount;
                boolean isAPIAvailableInPublisher = false;
                for (int j = 0; j < 24; ++j) {
                    org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO publisherAPIs = this.restAPIPublisher.getAllAPIs();
                    if (null != publisherAPIs && null != publisherAPIs.getCount() && publisherAPIs.getCount() == publisherAPIsCount) {
                        isAPIAvailableInPublisher = true;
                        break;
                    }
                    Thread.sleep(5000L);
                }
                if (!isAPIAvailableInPublisher) {
                    Assert.fail((String)(" Versioned API apiId=" + apiId + " APIName = " + APIName + "APIVersion" + APIVersion + "is not visible properly in Publisher."));
                }
                log.info((Object)("publishing API apiId=" + apiId + " APIName = " + APIName + "APIVersion" + APIVersion));
                HttpResponse lifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(apiId, false);
                Assert.assertNotNull((Object)lifecycleChangeResponse, (String)("Failed to publish the API " + APIName + ":" + APIVersion));
                boolean apisAvailableForTesting = false;
                org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO publisherAPIs = new org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO();
                this.waitForAPIDeployment();
                for (int j = 0; j < 10; ++j) {
                    devportalAPIs = this.restAPIStore.getAllAPIs();
                    publisherAPIs = this.restAPIPublisher.getAllAPIs();
                    if (null != publisherAPIs && null != devportalAPIs && publisherAPIs.getCount() == publisherAPIsCount && devportalAPIs.getCount() == counter) {
                        apisAvailableForTesting = true;
                        break;
                    }
                    Thread.sleep(5000L);
                }
                if (!apisAvailableForTesting) {
                    Assert.fail((String)" Versioned APIs are not visible properly in Devportal or Publisher");
                }
                Assert.assertTrue((devportalAPIs.getCount() == counter ? 1 : 0) != 0);
                String latestVersionInDevportal = "";
                String latestVersionApiId = "";
                if (devportalAPIs.getList() != null) {
                    for (APIInfoDTO apiInfoDTO : devportalAPIs.getList()) {
                        if (!APIName.equals(apiInfoDTO.getName()) || !providerName.equals(apiInfoDTO.getProvider())) continue;
                        latestVersionInDevportal = apiInfoDTO.getVersion();
                        latestVersionApiId = apiInfoDTO.getId();
                    }
                }
                log.info((Object)("apiVersionsArray = " + apiVersionsArray + " i= " + i + "apiVersionsArray[i] = " + apiVersionsArray[i] + " latestVersionInDevportal= " + latestVersionInDevportal));
                switch (i) {
                    case 0: 
                    case 1: 
                    case 3: {
                        Assert.assertEquals((String)latestVersionInDevportal, (String)apiVersionsArray[i], (String)(" count = " + counter + " i=" + i));
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((String)latestVersionInDevportal, (String)apiVersionsArray[i - 1], (String)(" count = " + counter + " i=" + i));
                        break;
                    }
                }
                if (i != 2 || !StringUtils.isNotEmpty((CharSequence)latestVersionApiId)) continue;
                this.restAPIPublisher.deleteAPI(latestVersionApiId);
                this.waitForAPIDeployment();
                devportalAPIs = this.restAPIStore.getAllAPIs();
                if (devportalAPIs != null) {
                    for (APIInfoDTO apiInfoDTO : devportalAPIs.getList()) {
                        if (!APIName.equals(apiInfoDTO.getName()) || !providerName.equals(apiInfoDTO.getProvider())) continue;
                        latestVersionInDevportal = apiInfoDTO.getVersion();
                    }
                }
                Assert.assertEquals((String)latestVersionInDevportal, (String)((String[])versionsOfAPIs.get(counter))[i]);
            }
        }
        this.getPaginatedAPIsFromPublisherAndVerify(0, 4, 4);
        this.getPaginatedAPIsFromPublisherAndVerify(4, 4, 4);
        this.getPaginatedAPIsFromPublisherAndVerify(8, 4, 4);
        this.getPaginatedAPIsFromPublisherAndVerify(12, 4, 3);
        this.getPaginatedAPIsFromDevportalAndVerify(0, 2, 2);
        this.getPaginatedAPIsFromDevportalAndVerify(2, 2, 2);
        this.getPaginatedAPIsFromDevportalAndVerify(4, 3, 1);
    }

    private void getPaginatedAPIsFromPublisherAndVerify(int offset, int limit, int expect) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO publisherAPIs = this.restAPIPublisher.getAPIs(offset, limit);
        Assert.assertEquals((int)publisherAPIs.getCount(), (int)expect, (String)("Expected " + expect + " of APIs in the page with offset:" + offset + " but was " + publisherAPIs.getCount()));
        Assert.assertNotNull((Object)publisherAPIs.getPagination(), (String)"pagination element cannot be null in get APIs response");
        Assert.assertEquals((int)publisherAPIs.getPagination().getTotal(), (int)this.numberOfPublisherAPIs, (String)("Expected " + this.numberOfPublisherAPIs + " as total number of APIs in the system but was " + publisherAPIs.getPagination().getTotal()));
    }

    private void getPaginatedAPIsFromDevportalAndVerify(int offset, int limit, int expect) throws ApiException {
        APIListDTO storeAPIs = this.restAPIStore.getAPIs(offset, limit);
        Assert.assertEquals((int)storeAPIs.getCount(), (int)expect, (String)("Expected " + expect + " of APIs in the page with offset:" + offset + " but was " + storeAPIs.getCount()));
        Assert.assertNotNull((Object)storeAPIs.getPagination(), (String)"pagination element cannot be null in get APIs response");
        Assert.assertEquals((int)storeAPIs.getPagination().getTotal(), (int)this.numberOfAPIs, (String)("Expected " + this.numberOfAPIs + " as total number of APIs in the system but was " + storeAPIs.getPagination().getTotal()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.restAPIPublisher != null) {
            for (String id : this.createdAPIs) {
                log.info((Object)("Delete API from createdAPIs: id" + id));
                this.restAPIPublisher.deleteAPI(id);
            }
        }
        super.cleanUp();
    }
}

