/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.header.util.SimpleSocketServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIMANAGER5326CustomStatusMsgTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5326CustomStatusMsgTestCase.class);
    public static final int PORT = 1989;
    private SimpleSocketServer simpleSocketServer;
    private String apiId;
    private String appId;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String expectedResponse = "HTTP/1.1 400 Custom response\r\nServer: testServer\r\nContent-Type: text/xml; charset=UTF-8\r\n Transfer-Encoding: chunked\r\n\r\n\"<?xml version=\"1.0\" encoding=\"UTF-8\"?><test></test>";
        this.simpleSocketServer = new SimpleSocketServer(1989, expectedResponse);
        this.simpleSocketServer.start();
        Thread.sleep(10000L);
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIErrorResponse() throws Exception {
        String apiName = "ErrorResponseCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "message";
        String endpointUrl = "http://" + InetAddress.getLocalHost().getHostName() + ":1989";
        String appName = "testApplication";
        try {
            ApplicationDTO applicationDTO = this.restAPIStore.addApplication(appName, "Unlimited", "", "this-is-test");
            this.appId = applicationDTO.getApplicationId();
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.appId, "Unlimited");
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("client_credentials");
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
            String accessToken = applicationKeyDTO.getToken().getAccessToken();
            String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext, apiVersion);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet getRequest1 = new HttpGet(apiInvocationUrl);
            getRequest1.addHeader((Header)new BasicHeader("Authorization", "Bearer " + accessToken));
            this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)getRequest1);
            Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)400, (String)"Response Code Mismatched");
            Assert.assertEquals((boolean)httpResponse.getStatusLine().toString().contains("Custom response"), (boolean)true, (String)"Response received with Custom Status Message");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)("IOException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.appId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

