/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class APIMANAGER5327KeyGenerationWithPGSQLTestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    private URL cleanUpURLHttp;
    private String password;
    private ServerConfigurationManager serverConfigurationManager;
    private HttpResponse storeLoginResponse;
    private String userName;
    private static final String UNLIMITED_TIER = "Unlimited";
    private static final String APPLICATION_NAME = "APIMANAGER5327";
    private static final String DATA_SOURCES = "master-datasources.xml";

    @BeforeClass
    public void init() {
        try {
            super.init();
            String storeURLHttp = this.storeUrls.getWebAppURLHttp();
            this.cleanUpURLHttp = new URL(new URL(storeURLHttp), "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag");
            this.userName = this.storeContext.getContextTenant().getTenantAdmin().getUserName();
            this.password = this.storeContext.getContextTenant().getContextUser().getPassword();
            this.apiStore = new APIStoreRestClient(storeURLHttp);
            String carbonHome = System.getProperty("carbon.home");
            String masterDataSources = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "tokengenerationpgsql" + File.separator + DATA_SOURCES;
            File sourceDataSource = new File(masterDataSources);
            File targetDataSource = new File(carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "datasources" + File.separator + DATA_SOURCES);
            this.serverConfigurationManager = new ServerConfigurationManager(this.storeContext);
            this.serverConfigurationManager.applyConfiguration(sourceDataSource, targetDataSource, true, true);
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while initializing testcase: " + e.getCause()));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while configuring the server instance: " + e.getCause()));
        }
    }

    @Test(description="Create new application and generate keys for it")
    public void generateKeyForApplication() throws Exception {
        this.storeLoginResponse = this.apiStore.login(this.userName, this.password);
        this.apiStore.addApplication(APPLICATION_NAME, UNLIMITED_TIER, "", "test");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(APPLICATION_NAME);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String error = response.getString("error");
        if ("true".equals(error)) {
            throw new Exception("Unable to generate the keys.");
        }
    }

    @Test(dependsOnMethods={"generateKeyForApplication"}, description="Try to execute application key cleanup and test if pgsql error occurs")
    public void cleanupKeys() throws Exception {
        HashMap<String, String> cleanupRequestHeaders = new HashMap<String, String>();
        cleanupRequestHeaders.put("Cookie", (String)this.storeLoginResponse.getHeaders().get("Set-Cookie"));
        String requestData = "action=cleanUpApplicationRegistration&applicationName=APIMANAGER5327&keyType=PRODUCTION";
        HttpResponse httpResponse = HttpRequestUtil.doPost((URL)this.cleanUpURLHttp, (String)requestData, cleanupRequestHeaders);
        JSONObject response = new JSONObject(httpResponse.getData());
        String error = response.getString("error");
        Assert.assertNotEquals((Object)"true", (Object)error, (String)"Error occurred while partial key cleanup");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

