/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.bean.APIImplementationBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;

public class APIMANAGER5417PrototypedAPIsInMonetizedTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIMFreePrototypedAPI";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private APIIdentifier apiIdentifierPublisher;
    private String apiEndPointUrl;
    private String tenantConfigBeforeTestCase;
    ServerConfigurationManager serverConfigurationManager;
    private static final Log log = LogFactory.getLog(APIMANAGER5417PrototypedAPIsInMonetizedTestCase.class);
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private final String TENANT_CONFIG_LOCATION = "/_system/config/apimgt/applicationdata/tenant-conf.json";
    private String apiProvider;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws APIManagerIntegrationTestException, XPathExpressionException, IOException, TenantMgtAdminServiceExceptionException, AutomationUtilException {
        super.init();
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "apiManagerXmlWithoutAdvancedThrottling" + File.separator + "api-manager.xml"));
        this.serverConfigurationManager.restartGracefully();
        String apiPrototypeEndpointPostfixUrl = "pizzashack-api-1.0.0/api/";
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiPrototypeEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.apiProvider, this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiIdentifierPublisher = new APIIdentifier(this.apiProvider, "APIMFreePrototypedAPI", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Create an API & deployed as a prototype and check the visibility in prototype API In store")
    public void testVisibilityOfPrototypedAPIInStoreAfterMonetizationEnabled() throws Exception {
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        String tenantConfContent = FileUtils.readFileToString((File)new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "monetization" + File.separator + "tenant-conf.json"), (String)"UTF-8");
        this.tenantConfigBeforeTestCase = this.resourceAdminServiceClient.getTextContent("/_system/config/apimgt/applicationdata/tenant-conf.json");
        this.resourceAdminServiceClient.updateTextContent("/_system/config/apimgt/applicationdata/tenant-conf.json", tenantConfContent);
        String apiContext = "apimfreepizzashack";
        String apiTags = "pizza, order, pizza-menu";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        APIDesignBean apiDesignBean = new APIDesignBean("APIMFreePrototypedAPI", apiContext, "1.0.0", apiDescription, apiTags);
        HttpResponse apiDesignResponse = this.apiPublisher.designAPI(apiDesignBean);
        Assert.assertEquals((int)apiDesignResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiDesignResponse.getData().contains("\"error\" : false"), (String)"APIMFreePrototypedAPIis not created as expected");
        APIImplementationBean apiImplementationBean = new APIImplementationBean("APIMFreePrototypedAPI", "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiImplementationBean.setSwagger(apiDesignBean.getSwagger());
        HttpResponse apiImplementationResponse = this.apiPublisher.implement(apiImplementationBean);
        Assert.assertEquals((int)apiImplementationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiImplementationResponse.getData().contains("\"error\" : false"), (String)"APIMFreePrototypedAPIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIMFreePrototypedAPI", this.apiProvider, APILifeCycleState.PROTOTYPED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PROTOTYPED"), (String)"APIMFreePrototypedAPI  status not updated as Prototyped");
        List implementedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisher, (List)implementedAPIList), (String)"ImplementedAPIMFreePrototypedAPI Api is visible in API Publisher.");
        Thread.sleep(15000L);
        try {
            HttpResponse response = HTTPSClientUtils.doGet((String)(this.storeUrls.getWebAppURLHttps() + "store/?tenant=carbon.super"), null);
            Assert.assertEquals((int)response.getResponseCode(), (int)200);
        }
        catch (IOException e) {
            log.error((Object)"Failed to get super tenant store", (Throwable)e);
            Assert.assertTrue((boolean)false, (String)("Failed to get super tenant store due to " + e.getMessage()));
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.resourceAdminServiceClient.updateTextContent("/_system/config/apimgt/applicationdata/tenant-conf.json", this.tenantConfigBeforeTestCase);
        this.apiPublisher.deleteAPI("APIMFreePrototypedAPI", "1.0.0", this.apiProvider);
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

