/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIScopeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIScopeTestCase.class);
    private UserManagementClient userManagementClient1 = null;
    private static final String API_NAME = "APIScopeTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "NewApplication";
    private String USER_SMITH = "smith";
    private String ADMIN_ROLE = "admin";
    private String INTERNAL_CREATOR_USER = "UserNew1";
    private String INTERNAL_CREATOR_PUBLISHER_USER = "UserNew2";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String INTERNAL_ROLE_CREATOR = "Internal/creator";
    private final String API_VERSION_WITH_SCOPE = "1.0.0";
    private final String API_VERSION_WITH_SCOPE_COPY = "2.0.0";
    private final String API_NAME_WITH_SCOPE = "APIScopeTestWithScopeName";
    private final String API_CONTEXT_WITH_SCOPE = "APIScopeTestWithScopeContext";
    private final String SCOPE_NAME = "APIScopeUpdateCopyScope";
    private final String ALLOWED_ROLE = "admin";
    private final String[] ADMIN_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage", "/permission/admin/configure", "/permission/admin/monitor"};
    private final String[] NEW_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "admin"};
    private final String[] OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "role1"};
    private final String[] SEC_OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone"};
    private final String[] INTERNAL_CREATOR_PUBLISHER_USER_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator"};
    private String apiId;
    private String apiIdWithScope;
    private String copyApiId;
    private String applicationId;
    private ArrayList<String> grantTypes;

    @Factory(dataProvider="userModeDataProvider")
    public APIScopeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.grantTypes = new ArrayList();
    }

    @Test(groups={"wso2.am"}, description="Testing the scopes with admin, subscriber roles")
    public void testSetScopeToResourceTestCase() throws Exception {
        String user2;
        String user1;
        String userSmith;
        String gatewayUrl;
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.USER_SMITH = "secondary/" + this.USER_SMITH;
            this.ADMIN_ROLE = "secondary/" + this.ADMIN_ROLE;
            this.INTERNAL_CREATOR_USER = "secondary/" + this.INTERNAL_CREATOR_USER;
            this.INTERNAL_CREATOR_PUBLISHER_USER = "secondary/" + this.INTERNAL_CREATOR_PUBLISHER_USER;
            this.userManagementClient1.addRole(this.ADMIN_ROLE, new String[]{this.user.getUserNameWithoutDomain()}, this.ADMIN_PERMISSIONS);
        }
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.NEW_ROLE_LIST);
        }
        if (this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super")) {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp();
            userSmith = this.USER_SMITH;
            user1 = this.INTERNAL_CREATOR_USER;
            user2 = this.INTERNAL_CREATOR_PUBLISHER_USER;
        } else {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.keyManagerContext.getContextTenant().getDomain() + "/";
            userSmith = this.USER_SMITH + "@" + this.keyManagerContext.getContextTenant().getDomain();
            user1 = this.INTERNAL_CREATOR_USER + "@" + this.keyManagerContext.getContextTenant().getDomain();
            user2 = this.INTERNAL_CREATOR_PUBLISHER_USER + "@" + this.keyManagerContext.getContextTenant().getDomain();
        }
        this.userManagementClient1.addUser(this.USER_SMITH, "john123", new String[]{"Internal/subscriber"}, this.USER_SMITH);
        this.userManagementClient1.addUser(this.INTERNAL_CREATOR_USER, "john123", new String[]{"Internal/creator"}, this.INTERNAL_CREATOR_USER);
        this.userManagementClient1.addUser(this.INTERNAL_CREATOR_PUBLISHER_USER, "john123", this.INTERNAL_CREATOR_PUBLISHER_USER_ROLE_LIST, this.INTERNAL_CREATOR_PUBLISHER_USER);
        this.restAPIPublisher = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        String apiContext = "testScopeAPI";
        String tags = "thomas-bayer, testing, rest-Apis";
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        APIRequest apiRequest = new APIRequest(API_NAME, apiContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
        String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{ \"description\": \"Successful\" }},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{ \"description\": \"Successful\" }},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{ \"description\": \"Successful\" }},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{ \"description\": \"Successful\" }},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{ \"description\": \"Successful\" }},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"APIScopeTestAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"" + this.ADMIN_ROLE + "\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"" + this.ADMIN_ROLE + ",Internal/subscriber\"}]}}}";
        this.restAPIPublisher.updateSwagger(this.apiId, modifiedResource);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
        HttpResponse applicationResponse = this.restAPIStore.createApplication(APP_NAME, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        String provider = this.user.getUserName();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Gold", this.restAPIStore);
        org.testng.Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful  API Name:APIScopeTestAPI API Version:1.0.0 API Provider Name :" + provider));
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("admin_scope");
        scopes.add("user_scope");
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, scopes, this.grantTypes);
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=admin_scope user_scope";
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(response.getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the GET Method");
        URL endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
        response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the POST Method");
        requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword();
        response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        accessTokenGenerationResponse = new JSONObject(response.getData());
        accessToken = accessTokenGenerationResponse.getString("access_token");
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("default"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("user_scope"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("admin_scope"));
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Admin user can access the GET Method without scope");
        try {
            endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
            response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
            org.testng.Assert.assertTrue((response.getResponseCode() != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Admin user can access the POST Method");
        }
        catch (Exception e) {
            log.error((Object)"user Admin cannot access the resources (expected behaviour)");
            org.testng.Assert.assertTrue((boolean)true, (String)"user admin cannot access the resources");
        }
        requestBody = "grant_type=password&username=" + userSmith + "&password=john123&scope=admin_scope user_scope";
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"User John cannot access the GET Method");
        try {
            endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
            response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
            org.testng.Assert.assertTrue((response.getResponseCode() != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"testRole John can access the POST Method");
        }
        catch (Exception e) {
            log.error((Object)"user john cannot access the resources (expected behaviour)");
            org.testng.Assert.assertTrue((boolean)true, (String)"user john cannot access the resources");
        }
        requestBody = "grant_type=password&username=" + userSmith + "&password=john123";
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessToken = accessTokenGenerationResponse.getString("access_token");
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("default"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("user_scope"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("admin_scope"));
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        org.testng.Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"User John can access the GET Method without scopes");
        String fullScopes = "openid apim:api_view apim:api_create apim:api_delete apim:api_publish apim:subscription_view apim:subscription_block apim:external_services_discover apim:threat_protection_policy_create apim:threat_protection_policy_manage apim:document_create apim:document_manage apim:mediation_policy_view apim:mediation_policy_create apim:mediation_policy_manage apim:client_certificates_view apim:client_certificates_add apim:client_certificates_update apim:ep_certificates_view apim:ep_certificates_add apim:ep_certificates_update apim:publisher_settings apim:pub_alert_manage apim:shared_scope_manage apim:api_generate_key apim:comment_view apim:comment_write apim:subscribe apim:app_update apim:app_manage apim:sub_manage apim:self-signup apim:dedicated_gateway apim:store_settings apim:api_key";
        requestBody = "grant_type=password&username=" + userSmith + "&password=john123&scope=" + fullScopes;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessTokenGenerationResponse.getString("access_token");
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("openid"));
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:subscribe"));
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:app_update"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_create"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_delete"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_publish"));
        requestBody = "grant_type=password&username=" + user1 + "&password=john123&scope=" + fullScopes;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessTokenGenerationResponse.getString("access_token");
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_create"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_publish"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:subscribe"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:app_update"));
        requestBody = "grant_type=password&username=" + user2 + "&password=john123&scope=" + fullScopes;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessTokenGenerationResponse.getString("access_token");
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_create"));
        Assert.assertTrue((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:api_publish"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:subscribe"));
        Assert.assertFalse((boolean)accessTokenGenerationResponse.getString("scope").contains("apim:app_update"));
    }

    @Test(groups={"wso2.am"}, description="Testing Copy api with scopes assigned", dependsOnMethods={"testSetScopeToResourceTestCase"})
    public void testCopyApiWithScopes() throws Exception {
        String tierCollection = "Unlimited";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", API_VERSION, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection(tierCollection);
        String swagger = "{\"paths\": {\"/add\": {\"get\": {\"x-auth-type\": \"" + URLEncoder.encode("Application & Application User", "UTF-8") + "\",\"x-throttling-tier\": \"" + "Unlimited" + "\",\"x-scope\": \"" + "APIScopeUpdateCopyScope" + "\",\"responses\": {\"200\": { \"description\": \"Successful\" }},\"parameters\": [{\"name\": \"x\",\"required\": false,\"type\": \"string\",\"description\": \"First value\",\"in\": \"query\"}, {\"name\": \"y\",\"required\": false,\"type\": \"string\",\"description\": \"Second Value\",\"in\": \"query\"}]}}},\"swagger\": \"2.0\",\"x-wso2-security\": {\"apim\": {\"x-wso2-scopes\": [{\"description\": \"Sample Scope\",\"name\": \"" + "APIScopeUpdateCopyScope" + "\",\"roles\": \"" + "admin" + "\",\"key\": \"" + "APIScopeUpdateCopyScope" + "\"}]}},\"info\": {\"title\": \"" + "APIScopeTestWithScopeName" + "\",\"version\": \"" + API_VERSION + "\"}}";
        apiCreationRequestBean.setSwagger(swagger);
        APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
        this.apiIdWithScope = apiDto.getId();
        this.restAPIPublisher.updateSwagger(this.apiIdWithScope, swagger);
        this.createAPIRevisionAndDeployUsingRest(this.apiIdWithScope, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", API_VERSION, "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", API_VERSION, "\"isApiExists\":true");
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI("2.0.0", this.apiIdWithScope, null);
        org.testng.Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
        this.copyApiId = newVersionResponse.getData();
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", "2.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Testing Update api with scopes assigned", dependsOnMethods={"testCopyApiWithScopes"})
    public void testUpdateApiWithScopes() throws Exception {
        String tierCollection = "Gold";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        APIRequest apiRequest = new APIRequest("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", new URL(endpointUrl));
        apiRequest.setTiersCollection(tierCollection);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setDescription("test api description");
        HttpResponse updateResponse = this.restAPIPublisher.updateAPI(apiRequest, this.apiIdWithScope);
        org.testng.Assert.assertEquals((int)updateResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
        this.createAPIRevisionAndDeployUsingRest(this.apiIdWithScope, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Testing REST API scopes", dependsOnMethods={"testUpdateApiWithScopes"})
    public void testRESTAPIScopes() throws Exception {
        RestAPIStoreImpl restAPIStoreUserSmith = new RestAPIStoreImpl(this.USER_SMITH, "john123", this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        Assert.assertNotNull((Object)restAPIStoreUserSmith.getAccessToken());
        RestAPIPublisherImpl restAPIPublisherUser1 = new RestAPIPublisherImpl(this.INTERNAL_CREATOR_USER, "john123", this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        Assert.assertNotNull((Object)restAPIPublisherUser1.getAccessToken());
        RestAPIPublisherImpl restAPIPublisherUser2 = new RestAPIPublisherImpl(this.INTERNAL_CREATOR_PUBLISHER_USER, "john123", this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        Assert.assertNotNull((Object)restAPIPublisherUser2.getAccessToken());
        RestAPIPublisherImpl restAPIPublisherNegative = new RestAPIPublisherImpl(this.USER_SMITH, "john123", this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        Assert.assertNotNull((Object)restAPIPublisherNegative.getAccessToken());
        try {
            restAPIPublisherNegative.apIsApi.getAllAPIs(null, null, this.keyManagerContext.getContextTenant().getDomain(), null, null, null, null, null);
            Assert.assertTrue((boolean)false);
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            Assert.assertTrue((boolean)true);
        }
        RestAPIStoreImpl restAPIStoreUserNegative = new RestAPIStoreImpl(this.INTERNAL_CREATOR_USER, "john123", this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        Assert.assertNotNull((Object)restAPIStoreUserNegative.getAccessToken());
        try {
            ApplicationListDTO responseData = restAPIStoreUserNegative.getAllApps();
            Assert.fail();
        }
        catch (ApiException e) {
            Assert.assertTrue((boolean)true);
        }
        RestAPIStoreImpl restAPIStoreUserNegative2 = new RestAPIStoreImpl(this.INTERNAL_CREATOR_PUBLISHER_USER, "john123", this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        Assert.assertNotNull((Object)restAPIStoreUserNegative2.getAccessToken());
        try {
            ApplicationListDTO responseData = restAPIStoreUserNegative2.getAllApps();
            Assert.fail();
        }
        catch (ApiException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiIdWithScope, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.apiIdWithScope);
        this.restAPIPublisher.deleteAPI(this.copyApiId);
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.OLD_ROLE_LIST);
        }
        if (this.userManagementClient1 != null) {
            if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
                this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.SEC_OLD_ROLE_LIST);
            }
            this.userManagementClient1.deleteUser(this.USER_SMITH);
            this.userManagementClient1.deleteUser(this.INTERNAL_CREATOR_USER);
            this.userManagementClient1.deleteUser(this.INTERNAL_CREATOR_PUBLISHER_USER);
        }
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }
}

