/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class AdvancedConfigurationsTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(AdvancedConfigurationsTestCase.class);
    private AdminApiTestHelper adminApiTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public AdvancedConfigurationsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test Get Tenant Configuration")
    public void testGetTenantConfiguration() throws Exception {
        String tenantConfigBeforeTestCase = this.restAPIAdmin.getTenantConfig().toString();
        Assert.assertNotNull((Object)tenantConfigBeforeTestCase);
    }

    @Test(groups={"wso2.am"}, description="Test add Tenant Configuration", dependsOnMethods={"testGetTenantConfiguration"})
    public void testUpdateTenantConfiguration() throws Exception {
        String tenantConfContent = FileUtils.readFileToString((File)new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "tenantConf" + File.separator + "tenant-conf.json"), (String)"UTF-8");
        JSONParser jsonParser = new JSONParser();
        JSONObject jsonObject = (JSONObject)jsonParser.parse(tenantConfContent);
        this.restAPIAdmin.updateTenantConfig((Object)jsonObject);
        String updatedConfContent = this.restAPIAdmin.getTenantConfig().toString();
        Assert.assertNotNull((Object)updatedConfContent);
    }

    @Test(groups={"wso2.am"}, description="Test Get Tenant Schema Configuration", dependsOnMethods={"testGetTenantConfiguration"})
    public void testGetTenantConfigurationSchema() throws Exception {
        String tenantConfigSchema = this.restAPIAdmin.getTenantConfigSchema().toString();
        Assert.assertNotNull((Object)tenantConfigSchema);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
    }
}

