/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class AllowedScopesTestCase
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private String apiEndPointUrl;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String ALLOWED_SCOPES_API = "allowedScopesAPI";
    private String apiId;
    private String applicationId;
    private final String API_END_POINT_METHOD = "/customers/123";

    @Factory(dataProvider="userModeDataProvider")
    public AllowedScopesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "allowedScopes" + File.separator + "deployment.toml"));
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest = new APIRequest("allowedScopesAPI", "allowedScopesAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse response = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = response.getData();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(createdApiResponse.getData(), APIDTO.class);
        ArrayList<String> role = new ArrayList<String>();
        role.add("admin");
        ScopeDTO scopeObject = new ScopeDTO();
        scopeObject.setName("scope1");
        scopeObject.setBindings(role);
        APIScopeDTO apiScope1DTO = new APIScopeDTO();
        apiScope1DTO.setScope(scopeObject);
        ScopeDTO scopeObject2 = new ScopeDTO();
        scopeObject2.setName("scope2");
        scopeObject2.setBindings(role);
        APIScopeDTO apiScope2DTO = new APIScopeDTO();
        apiScope2DTO.setScope(scopeObject2);
        ArrayList<APIScopeDTO> apiScopeList = new ArrayList<APIScopeDTO>();
        apiScopeList.add(apiScope1DTO);
        apiScopeList.add(apiScope2DTO);
        apidto.setScopes(apiScopeList);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("scope1");
        scopes.add("scope2");
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        apiOperationsDTO.setAuthType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setScopes(scopes);
        operations.add(apiOperationsDTO);
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.apiId);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId, false);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
    }

    @Test(description="Generate access token for white listed scopes and invoke APIs")
    public void testGenerateAccessTokenWithWhiteListedScopes() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("TestAppScope", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Gold", this.restAPIStore);
        org.testng.Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful  API Name:allowedScopesAPI API Version:1.0.0 API Provider Name :" + this.user.getUserName()));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBodyForScope1 = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=scope1";
        JSONObject accessTokenGenerationResponseScope1 = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBodyForScope1, tokenEndpointURL).getData());
        Assert.assertNotNull((Object)accessTokenGenerationResponseScope1);
        Assert.assertTrue((boolean)accessTokenGenerationResponseScope1.getString("scope").contains("scope1"));
        Assert.assertTrue((boolean)accessTokenGenerationResponseScope1.getString("expires_in").equals("3600"));
        String accessTokenScope1 = accessTokenGenerationResponseScope1.getString("access_token");
        HashMap<String, String> requestHeadersScope1 = new HashMap<String, String>();
        requestHeadersScope1.put("Authorization", "Bearer " + accessTokenScope1);
        requestHeadersScope1.put("accept", "text/xml");
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("allowedScopesAPI", "1.0.0") + "/customers/123"), requestHeadersScope1);
        org.testng.Assert.assertEquals((int)apiResponse.getResponseCode(), (int)200);
        String requestBodyForScope2 = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=scope2";
        JSONObject accessTokenGenerationResponseScope2 = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBodyForScope2, tokenEndpointURL).getData());
        Assert.assertNotNull((Object)accessTokenGenerationResponseScope2);
        Assert.assertTrue((boolean)accessTokenGenerationResponseScope2.getString("scope").contains("scope2"));
        Assert.assertTrue((boolean)accessTokenGenerationResponseScope2.getString("expires_in").equals("3600"));
        String accessTokenScope2 = accessTokenGenerationResponseScope2.getString("access_token");
        HashMap<String, String> requestHeadersScope2 = new HashMap<String, String>();
        requestHeadersScope2.put("Authorization", "Bearer " + accessTokenScope2);
        requestHeadersScope2.put("accept", "text/xml");
        HttpResponse apiResponse2 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("allowedScopesAPI", "1.0.0") + "/customers/123"), requestHeadersScope2);
        org.testng.Assert.assertEquals((int)apiResponse2.getResponseCode(), (int)200);
        HttpResponse apiResponse3 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("allowedScopesAPI", "1.0.0") + "/customers/123"), requestHeadersScope1);
        org.testng.Assert.assertEquals((int)apiResponse3.getResponseCode(), (int)200);
        String requestBodyForWithScope3 = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=scope3";
        JSONObject accessTokenGenerationResponseWithScope3 = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBodyForWithScope3, tokenEndpointURL).getData());
        Assert.assertNotNull((Object)accessTokenGenerationResponseWithScope3);
        Assert.assertTrue((boolean)accessTokenGenerationResponseWithScope3.getString("scope").contains("scope3"));
        Assert.assertTrue((boolean)accessTokenGenerationResponseWithScope3.getString("expires_in").equals("3600"));
        String accessTokenWithScope3 = accessTokenGenerationResponseWithScope3.getString("access_token");
        HashMap<String, String> requestHeadersWithScope3 = new HashMap<String, String>();
        requestHeadersWithScope3.put("Authorization", "Bearer " + accessTokenWithScope3);
        requestHeadersWithScope3.put("accept", "text/xml");
        HttpResponse apiResponse4 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("allowedScopesAPI", "1.0.0") + "/customers/123"), requestHeadersWithScope3);
        org.testng.Assert.assertEquals((int)apiResponse4.getResponseCode(), (int)403);
        String requestBodyForWithoutScope = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword();
        JSONObject accessTokenGenerationResponseWithoutScope = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBodyForWithoutScope, tokenEndpointURL).getData());
        Assert.assertNotNull((Object)accessTokenGenerationResponseWithoutScope);
        Assert.assertTrue((boolean)accessTokenGenerationResponseWithoutScope.getString("scope").contains("default"));
        Assert.assertTrue((boolean)accessTokenGenerationResponseWithoutScope.getString("expires_in").equals("3600"));
        String accessTokenWithoutScope = accessTokenGenerationResponseWithoutScope.getString("access_token");
        HashMap<String, String> requestHeadersWithoutScope = new HashMap<String, String>();
        requestHeadersWithoutScope.put("Authorization", "Bearer " + accessTokenWithoutScope);
        requestHeadersWithoutScope.put("accept", "text/xml");
        HttpResponse apiResponse5 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("allowedScopesAPI", "1.0.0") + "/customers/123"), requestHeadersWithoutScope);
        org.testng.Assert.assertEquals((int)apiResponse5.getResponseCode(), (int)403);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

