/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class DigestAuthenticationTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
    }

    @Test(groups={"wso2.am"}, description="Check functionality of the digest authenticated API")
    public void testDigestAuthentication() throws Exception {
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String apiName = "DigestAuthAPI";
        String apiVersion = "1.0.0";
        String apiContext = "digest";
        String providerName = this.user.getUserName();
        String endpointUrl = this.getGatewayURLNhttp() + "digestAuth";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, apiVersion, providerName, new URL(endpointUrl));
        apiCreationRequestBean.setEndpointType("secured");
        apiCreationRequestBean.setEndpointAuthType("digestAuth");
        apiCreationRequestBean.setEpUsername("DigestAuth");
        apiCreationRequestBean.setEpPassword("digest123");
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(providerName);
        this.apiPublisher.addAPI(apiCreationRequestBean);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.addApplication("DigestAuthAPP", "Unlimited", "", "Test-Digest-Auth");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, providerName, "DigestAuthAPP", "Unlimited");
        this.waitForAPIDeploymentSync(providerName, apiName, apiVersion, "\"isApiExists\":true");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("DigestAuthAPP");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String accessToken = jsonResponse.getJSONObject("data").getJSONObject("key").getString("accessToken");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext, apiVersion);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/xml");
        headers.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)apiInvocationUrl, headers);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"The response code is not 200 OK");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

