/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class ErrorResponseCheckTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(ErrorResponseCheckTestCase.class);
    private String apiId;
    private String applicationId;

    @Factory(dataProvider="userModeDataProvider")
    public ErrorResponseCheckTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIErrorResponse() throws Exception {
        String apiName = "ErrorResponseSecAPI";
        String apiVersion = "1.0.0";
        String apiContext = "sec";
        String endpointUrl = this.getGatewayURLNhttp() + "response_error";
        String applicationName = "SecApp";
        String providerName = this.user.getUserName();
        try {
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setProvider(providerName);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
            this.apiId = serviceResponse.getData();
            this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
            this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
            HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
            this.applicationId = applicationResponse.getData();
            this.waitForAPIDeploymentSync(providerName, apiName, apiVersion, "\"isApiExists\":true");
            this.restAPIStore.createSubscription(this.apiId, this.applicationId, "Unlimited");
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("client_credentials");
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
            String accessToken = applicationKeyDTO.getToken().getAccessToken();
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Authorization", "Bearer " + accessToken);
            HttpResponse apiInvokeResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(apiContext, apiVersion), requestHeaders);
            Assert.assertEquals((int)apiInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
            HttpResponse apiInvokeResponseInvalidContext = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("invalidContext", apiVersion), requestHeaders);
            Assert.assertEquals((int)apiInvokeResponseInvalidContext.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Response Code Mismatched");
            Assert.assertFalse((boolean)apiInvokeResponseInvalidContext.getData().contains("invalidContext/1.0.0"), (String)"The message contains the resource path requested.");
            HashMap requestHeadersModified = new HashMap();
            requestHeaders.put("Authorization", "Bearer invalid_access_token");
            HttpResponse apiInvokeResponseInvalidToken = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(apiContext, apiVersion), requestHeadersModified);
            Assert.assertEquals((int)apiInvokeResponseInvalidToken.getResponseCode(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Response Code Mismatched");
            Assert.assertFalse((boolean)apiInvokeResponseInvalidToken.getData().contains("invalid_access_token"), (String)"Access token entered is valid");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)("IOException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

