/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class LoadBalancedEndPointTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(LoadBalancedEndPointTestCase.class);
    private String apiName = "LoadBalanacedAPITestCase";
    private String context = "LoadBalancedAPI";
    private String version = "1.0.0";
    private String providerName;
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private String appTier = "Unlimited";
    private String endPointType = "load_balance";
    private String applicationName = "LoadBalanceAPIApplication";
    private String apiNameSandbox = "LoadBalanceSandboxAPI";
    private String contextSandbox = "LoadBalanceSandboxAPIContext";
    private String applicationNameSandbox = "LoadBalancedSandboxAPIApplication";
    private String firstProductionEndPoint = "";
    private String secondProductionEndPoint = "";
    private String thirdProductionEndPoint = "";
    private String productionEndpointPrefix = "HelloWSO2 from File ";
    private String gatewayUrl;
    private List<APIOperationsDTO> apiOperationsDTOS;
    private String apiId;
    private String sandboxApiId;
    private String appId;
    private String sandboxAppId;

    @Factory(dataProvider="userModeDataProvider")
    public LoadBalancedEndPointTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode: " + this.userMode));
        this.apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.authType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy(this.resTier);
        apiOperationsDTO.setTarget("/name");
        this.apiOperationsDTOS.add(apiOperationsDTO);
        this.gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Test Load Balance End Points", priority=1)
    public void testCreateApiWithDifferentProductionEndpoints() throws Exception {
        String description = "LoadBalancedEnd-point";
        this.firstProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkOne";
        this.secondProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkTwo";
        this.thirdProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkThree";
        ArrayList<String> endpointLB = new ArrayList<String>();
        endpointLB.add(this.firstProductionEndPoint);
        endpointLB.add(this.secondProductionEndPoint);
        endpointLB.add(this.thirdProductionEndPoint);
        APIRequest apiRequest = new APIRequest(this.apiName, this.context, this.version, endpointLB, null);
        apiRequest.setTiersCollection(this.tier);
        apiRequest.setOperationsDTOS(this.apiOperationsDTOS);
        apiRequest.setProvider(this.providerName);
        apiRequest.setDescription(description);
        apiRequest.setEndpointType(this.endPointType);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
    }

    @Test(groups={"wso2.am"}, description="Verify Round Robin Algorithm by Invoking the Production Endpoint API", dependsOnMethods={"testCreateApiWithDifferentProductionEndpoints"})
    public void testRoundRobinAlgorithmInProductionEndpoints() throws Exception {
        String accessUrl = this.gatewayUrl + this.context + "/" + this.version + "/name";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication(this.applicationName, this.appTier, "", "Test App");
        this.appId = applicationDTO.getApplicationId();
        this.subscribeToAPIUsingRest(this.apiId, this.appId, this.tier, this.restAPIStore);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> applicationHeader = new HashMap<String, String>();
        applicationHeader.put("Authorization", " Bearer " + accessToken);
        int numberOfEndpoints = 3;
        int requestCount = 10;
        this.waitForAPIDeployment();
        for (int requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeader);
            Assert.assertEquals((int)apiInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
            int remainder = requestNumber % numberOfEndpoints;
            if (remainder == 0) {
                log.info((Object)apiInvokeResponse.getData());
                Assert.assertEquals((String)apiInvokeResponse.getData(), (String)(this.productionEndpointPrefix + "3"), (String)("Error in Round Robin Algorithm in cycle " + requestNumber));
                continue;
            }
            log.info((Object)apiInvokeResponse.getData());
            Assert.assertEquals((String)apiInvokeResponse.getData(), (String)(this.productionEndpointPrefix + remainder), (String)("Error in Round Robin Algorithm in Cycle " + requestNumber));
        }
    }

    @Test(groups={"wso2.am"}, description="Test Load balanced function with both Production and Sandbox Endpoints", priority=2)
    public void testCreateApiWithBothProdAndSandboxEndpoints() throws Exception {
        String descriptionSandbox = "SandboxEnd-point";
        this.firstProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkOne";
        this.secondProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkTwo";
        this.thirdProductionEndPoint = this.backEndServerUrl.getWebAppURLHttp() + "name-checkThree";
        ArrayList<String> endpointProd = new ArrayList<String>();
        endpointProd.add(this.firstProductionEndPoint);
        endpointProd.add(this.secondProductionEndPoint);
        endpointProd.add(this.thirdProductionEndPoint);
        String firstSandboxEndpoint = this.backEndServerUrl.getWebAppURLHttp() + "name-check1_SB";
        String secondSandboxEndpoint = this.backEndServerUrl.getWebAppURLHttp() + "name-check2_SB";
        String thirdSandboxEndpoint = this.backEndServerUrl.getWebAppURLHttp() + "name-check3_SB";
        ArrayList<String> endpointSandbox = new ArrayList<String>();
        endpointSandbox.add(firstSandboxEndpoint);
        endpointSandbox.add(secondSandboxEndpoint);
        endpointSandbox.add(thirdSandboxEndpoint);
        APIRequest apiRequestSB = new APIRequest(this.apiNameSandbox, this.contextSandbox, this.version, endpointProd, endpointSandbox);
        apiRequestSB.setTiersCollection(this.tier);
        apiRequestSB.setProvider(this.providerName);
        apiRequestSB.setOperationsDTOS(this.apiOperationsDTOS);
        apiRequestSB.setDescription(descriptionSandbox);
        apiRequestSB.setEndpointType(this.endPointType);
        this.sandboxApiId = this.createAndPublishAPIUsingRest(apiRequestSB, this.restAPIPublisher, false);
    }

    @Test(groups={"wso2.am"}, description="Verify Round Robin Algorithm by Invoking the Sandbox Endpoint API", dependsOnMethods={"testCreateApiWithBothProdAndSandboxEndpoints"})
    public void testRoundRobinAlgorithmInProductionAndSandboxEndpoints() throws Exception {
        int remainder;
        int requestNumber;
        String webAppSandboxResponsePrefix = "HelloWSO2 from File ";
        String webAppSandboxResponseSuffix = "_Sandbox";
        String accessUrl = this.gatewayUrl + this.contextSandbox + "/" + this.version + "/name";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication(this.applicationNameSandbox, this.appTier, "", "Test Application");
        this.sandboxAppId = applicationDTO.getApplicationId();
        this.subscribeToAPIUsingRest(this.sandboxApiId, this.sandboxAppId, this.tier, this.restAPIStore);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.sandboxAppId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessTokenProduction = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> applicationHeaderProduction = new HashMap<String, String>();
        applicationHeaderProduction.put("Authorization", " Bearer " + accessTokenProduction);
        ApplicationKeyDTO applicationKeyDTOSandBox = this.restAPIStore.generateKeys(this.sandboxAppId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String accessTokenSandbox = applicationKeyDTOSandBox.getToken().getAccessToken();
        HashMap<String, String> applicationHeaderSandbox = new HashMap<String, String>();
        applicationHeaderSandbox.put("Authorization", " Bearer " + accessTokenSandbox);
        int requestCount = 10;
        int numberOfProductionEndpoints = 3;
        int numberOfSandboxEndpoints = 3;
        this.waitForAPIDeployment();
        for (requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiProductionInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeaderProduction);
            Assert.assertEquals((int)apiProductionInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched in Production API invoke");
            remainder = requestNumber % numberOfProductionEndpoints;
            if (remainder == 0) {
                log.info((Object)apiProductionInvokeResponse.getData());
                Assert.assertEquals((String)apiProductionInvokeResponse.getData(), (String)(this.productionEndpointPrefix + "3"), (String)"Error in Round Robin Algorithm in cycle ");
                continue;
            }
            log.info((Object)apiProductionInvokeResponse.getData());
            Assert.assertEquals((String)apiProductionInvokeResponse.getData(), (String)(this.productionEndpointPrefix + remainder), (String)("Error in Production Endpoint Round Robin Algorithm in request: " + requestNumber));
        }
        for (requestNumber = 1; requestNumber < requestCount; ++requestNumber) {
            HttpResponse apiSandboxInvokeResponse = HttpRequestUtil.doGet((String)accessUrl, applicationHeaderSandbox);
            Assert.assertEquals((int)apiSandboxInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch in Sandbox Endpoint invoke");
            remainder = requestNumber % numberOfSandboxEndpoints;
            if (remainder == 0) {
                log.info((Object)apiSandboxInvokeResponse.getData());
                Assert.assertEquals((String)apiSandboxInvokeResponse.getData(), (String)(webAppSandboxResponsePrefix + "3" + webAppSandboxResponseSuffix), (String)"Error in Round Robin Algorithm in cycle ");
                continue;
            }
            log.info((Object)apiSandboxInvokeResponse.getData());
            Assert.assertEquals((String)apiSandboxInvokeResponse.getData(), (String)(webAppSandboxResponsePrefix + remainder + webAppSandboxResponseSuffix), (String)("Error in Round Robin Algorithm in Cycle " + requestNumber));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.appId);
        this.restAPIStore.deleteApplication(this.sandboxAppId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.sandboxApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.sandboxApiId);
    }
}

