/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import waffle.apache.NegotiateAuthenticator;
import waffle.util.Base64;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class NTLMTestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    static NegotiateAuthenticator _authenticator = null;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="This test method only runs on windows environment.We exchange NTLM token for access_token")
    public void testGenerateNTLMTokensTestCase() throws Exception {
        String securityPackage = "Negotiate";
        _authenticator = new NegotiateAuthenticator();
        IWindowsCredentialsHandle clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)securityPackage);
        clientCredentials.initialize();
        WindowsSecurityContextImpl clientContext = new WindowsSecurityContextImpl();
        clientContext.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
        clientContext.setCredentialsHandle(clientCredentials.getHandle());
        clientContext.setSecurityPackage(securityPackage);
        clientContext.initialize(null, null, WindowsAccountImpl.getCurrentUsername());
        String clientToken = Base64.encode((byte[])clientContext.getToken());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.addApplication("NTLM", "Unlimited", "some_url", "NewApp");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("NTLM");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        Thread.sleep(4000L);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        byte[] userKey = (consumerKey + ":" + consumerSecret).getBytes();
        String encoding = Base64Utils.encode((byte[])userKey);
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        HttpPost httppost = new HttpPost(String.valueOf(tokenEndpointURL));
        httppost.setHeader("Authorization", "Basic " + encoding);
        ArrayList<BasicNameValuePair> paramVals = new ArrayList<BasicNameValuePair>();
        paramVals.add(new BasicNameValuePair("grant_type", "iwa:ntlm"));
        paramVals.add(new BasicNameValuePair("windows_token", clientToken));
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(paramVals, "UTF-8"));
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        JSONObject accessTokenGenerationResponse = new JSONObject(responseString);
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Error while getting access token.. access token is empty");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

