/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class NotificationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(NotificationTestCase.class);
    private static final String API_NAME = "NOTIFICATION_TEST_API";
    private static final String API_CONTEXT = "NOTIFICATION_TEST_API";
    private static final String API_VERSION = "1.0.0";
    private static final String NEW_API_VERSION = "2.0.0";
    private static final String APP_NAME = "NOTIFICATION_TEST_APP";
    private final String STORE_USERNAME = "api_store";
    private final String STORE_PASSWORD = "admin";
    private static final String EMAIL_USERNAME = "APIM";
    private static final String EMAIL_PASSWORD = "APIM+123";
    private static final String USER_EMAIL_ADDRESS = "apim@gmail.com";
    private static final int SMTP_TEST_PORT = 3025;
    private static final String FIRST_NAME = "John";
    private static final String ORGANIZATION = "Test";
    private GreenMail greenMail;
    private String apiId;
    private String newApiId;
    private String applicationId;
    private String subscriptionId;
    private RestAPIStoreImpl restAPIStoreClient;

    @Factory(dataProvider="userModeDataProvider")
    public NotificationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeURLHttp = "https://localhost:9943/";
    }

    @Test(groups={"wso2.am"}, description="Testing Notification Feature")
    public void notificationTestCase() throws Exception {
        ServerSetup setup = new ServerSetup(3025, "localhost", "smtp");
        this.greenMail = new GreenMail(setup);
        this.greenMail.setUser(USER_EMAIL_ADDRESS, EMAIL_USERNAME, EMAIL_PASSWORD);
        this.greenMail.start();
        log.info((Object)"green mail server started ");
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        APIRequest apiRequest = new APIRequest("NOTIFICATION_TEST_API", "NOTIFICATION_TEST_API", new URL(url));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setDescription(description);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        UserManagementUtils.signupUser((String)"api_store", (String)"admin", (String)FIRST_NAME, (String)ORGANIZATION, (String)USER_EMAIL_ADDRESS);
        this.restAPIStoreClient = new RestAPIStoreImpl("api_store", "admin", "carbon.super", this.storeURLHttp);
        HttpResponse applicationResponse = this.restAPIStoreClient.createApplication(APP_NAME, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        HttpResponse responseStore = this.restAPIStoreClient.createSubscription(this.apiId, this.applicationId, "Unlimited");
        this.subscriptionId = responseStore.getData();
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI(NEW_API_VERSION, this.apiId, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        this.newApiId = newVersionResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.newApiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        HttpResponse newVersionPublishResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.newApiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)newVersionPublishResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        this.greenMail.waitForIncomingEmail(50000L, 1);
        MimeMessage[] messages = this.greenMail.getReceivedMessages();
        if (messages.length > 0) {
            Assert.assertTrue((boolean)true, (String)"Email received BY Greenmail server");
        } else {
            Assert.assertTrue((boolean)false, (String)"Email NOT received BY Greenmail server");
        }
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reade which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStoreClient.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.newApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newApiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

