/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import java.rmi.RemoteException;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class PublisherAccessControlTestCase
extends APIManagerLifecycleBaseTest {
    private static final String VERSION = "1.0.0";
    private static final String RESTRICTED_ACCESS_CONTROL = "restricted";
    private static final String PUBLIC_VISIBILITY = "public";
    private static final String NO_ACCESS_CONTROL = "none";
    private final String[] OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "role1"};
    private String contextUsername = "admin";
    private String FIRST_USER = "pubu1";
    private String SECOND_USER = "pubu2";
    private String PUB_SUB_USER = "pubsu1";
    private String FIRST_ROLE = "publisher_role1";
    private String SECOND_ROLE = "publisher_role2";
    private String SUBSCRIBER_ROLE = "subscriber_role1";
    private String PUB_SUB_ROLE = "pub_sub_role1";
    private final String USER_PASSWORD = "123123";
    private String SUBSCRIBER_USER = "subu1";
    private final String INTERNAL_CREATOR = "Internal/creator";
    private final String INTERNAL_PUBLISHER = "Internal/publisher";
    private final String INTERNAL_SUBSCRIBER = "Internal/subscriber";
    private final String EP_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private final String EMAIL_DOMAIN = "@gmail.com";
    private final String AT = "@";
    private String publisherAccessControlAPI = "PublisherAccessControl";
    private String publisherAccessControlAPI2 = "PublisherAccessControl2";
    private String publicAccessRestrictedVisibilityAPI = "PublicAccessRestrictedVisibility";
    private String accessControlledPublicVisibilityAPI = "AccessControlledPublicVisibility";
    private final String restrictedAccessRestrictedVisibilityAPI = "RestrictedAccessRestrictedVisibility";
    private RestAPIPublisherImpl apiPublisherFirstUser;
    private RestAPIPublisherImpl apiPublisherSecondUser;
    private RestAPIStoreImpl apiStoreSubUser;
    private RestAPIPublisherImpl apiPublisherPubSubUser;
    private RestAPIStoreImpl apiStorePubSubUser;
    private String publisherAccessControlAPIId;
    private String publisherAccessControlAPI2Id;
    private String accessControlledPublicVisibilityAPIId;
    private String publicAccessRestrictedVisibilityAPIId;
    private String restrictedAccessRestrictedVisibilityAPIId;
    UserManagementClient userManagementClient1;

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public PublisherAccessControlTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass
    public void initTestCase() throws APIManagerIntegrationTestException, XPathExpressionException, RemoteException, UserAdminUserAdminException {
        super.init(this.userMode);
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.contextUsername = this.keyManagerContext.getContextTenant().getContextUser().getUserName();
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.FIRST_USER = this.FIRST_USER + "@gmail.com" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.SECOND_USER = this.SECOND_USER + "@gmail.com" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.SUBSCRIBER_USER = this.SUBSCRIBER_USER + "@gmail.com" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.PUB_SUB_USER = this.PUB_SUB_USER + "@gmail.com" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
        } else if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.FIRST_USER = "secondary/" + this.FIRST_USER;
            this.SECOND_USER = "secondary/" + this.SECOND_USER;
            this.SUBSCRIBER_USER = "secondary/" + this.SUBSCRIBER_USER;
            this.PUB_SUB_USER = "secondary/" + this.PUB_SUB_USER;
            this.FIRST_ROLE = "secondary/" + this.FIRST_ROLE;
            this.SECOND_ROLE = "secondary/" + this.SECOND_ROLE;
            this.SUBSCRIBER_ROLE = "secondary/" + this.SUBSCRIBER_ROLE;
            this.PUB_SUB_ROLE = "secondary/" + this.PUB_SUB_ROLE;
        }
        this.userManagementClient1.addRole(this.FIRST_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addRole(this.SECOND_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addRole(this.SUBSCRIBER_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addRole(this.PUB_SUB_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addUser(this.FIRST_USER, "123123", new String[]{"Internal/creator", this.FIRST_ROLE}, this.FIRST_USER);
        this.userManagementClient1.addUser(this.SECOND_USER, "123123", new String[]{"Internal/publisher", this.SECOND_ROLE}, this.SECOND_USER);
        this.userManagementClient1.addUser(this.SUBSCRIBER_USER, "123123", new String[]{"Internal/subscriber", this.SUBSCRIBER_ROLE}, this.SUBSCRIBER_USER);
        this.userManagementClient1.addUser(this.PUB_SUB_USER, "123123", new String[]{"Internal/publisher", "Internal/subscriber", this.PUB_SUB_ROLE}, this.PUB_SUB_USER);
        if (TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            String[] newRoleList = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", this.FIRST_ROLE};
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), newRoleList);
        }
        this.apiPublisherFirstUser = new RestAPIPublisherImpl(this.FIRST_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.apiPublisherSecondUser = new RestAPIPublisherImpl(this.SECOND_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.apiPublisherPubSubUser = new RestAPIPublisherImpl(this.PUB_SUB_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.apiStorePubSubUser = new RestAPIStoreImpl(this.PUB_SUB_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.apiStoreSubUser = new RestAPIStoreImpl(this.SUBSCRIBER_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.restAPIPublisher = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added with a access control restriction.")
    public void testAPIAdditionWithAccessControlRestriction() throws Exception {
        APIRequest brokenApiRequest = new APIRequest(this.publisherAccessControlAPI, this.publisherAccessControlAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion(VERSION);
        brokenApiRequest.setProvider(this.contextUsername);
        brokenApiRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        brokenApiRequest.setAccessControlRoles(this.FIRST_ROLE);
        this.publisherAccessControlAPIId = this.createAndPublishAPIUsingRest(brokenApiRequest, this.restAPIPublisher, false);
        HttpResponse response = this.restAPIPublisher.getAPI(this.publisherAccessControlAPIId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertTrue((boolean)apidto.getAccessControlRoles().contains(this.FIRST_ROLE), (String)"API was not visible to the APIM admin user");
        response = this.apiPublisherFirstUser.getAPI(this.publisherAccessControlAPIId);
        apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertTrue((boolean)apidto.getAccessControlRoles().contains(this.FIRST_ROLE), (String)"API was not visible to the creators who have the relevant access control roles of the API");
        response = this.apiPublisherSecondUser.getAPI(this.publisherAccessControlAPIId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatch");
        Assert.assertTrue((boolean)response.getData().contains("User is not authorized to access the API"), (String)"API is visible to the creators who do not have the relevant access control roles of the API");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added without access control restriction.", dependsOnMethods={"testAPIAdditionWithAccessControlRestriction"})
    public void testAPIAdditionWithoutAccessControlRestriction() throws Exception {
        APIRequest brokenApiRequest = new APIRequest(this.publisherAccessControlAPI2, this.publisherAccessControlAPI2, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion(VERSION);
        brokenApiRequest.setProvider(this.contextUsername);
        this.publisherAccessControlAPI2Id = this.createAndPublishAPIUsingRest(brokenApiRequest, this.restAPIPublisher, false);
        HttpResponse response = this.restAPIPublisher.getAPI(this.publisherAccessControlAPI2Id);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((String)apidto.getName(), (String)this.publisherAccessControlAPI2, (String)"API is not visible to APIM admin without access control restriction");
        response = this.apiPublisherFirstUser.getAPI(this.publisherAccessControlAPI2Id);
        apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((String)apidto.getName(), (String)this.publisherAccessControlAPI2, (String)"API is not visible to creator without access control restriction");
        response = this.apiPublisherSecondUser.getAPI(this.publisherAccessControlAPI2Id);
        apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((String)apidto.getName(), (String)this.publisherAccessControlAPI2, (String)"API is not visible to creator without access control restriction");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which from store which was added without access control restriction and public visibility.", dependsOnMethods={"testAPIAdditionWithoutAccessControlRestriction"})
    public void testGetPublicAPIFromStoreWithRestrictedPublisherAccess() throws Exception {
        APIRequest createAPIRequest = new APIRequest(this.accessControlledPublicVisibilityAPI, this.accessControlledPublicVisibilityAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setAccessControlRoles(this.FIRST_ROLE);
        createAPIRequest.setVisibility(PUBLIC_VISIBILITY);
        this.accessControlledPublicVisibilityAPIId = this.createAndPublishAPIUsingRest(createAPIRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.contextUsername, this.accessControlledPublicVisibilityAPI, VERSION, "\"isApiExists\":true");
        APIDTO apiDto = this.apiStoreSubUser.getAPI(this.accessControlledPublicVisibilityAPIId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)("Public API with name " + this.accessControlledPublicVisibilityAPI + "is not returned"));
    }

    @Test(groups={"wso2.am"}, description="This test case add restricted visibility on store for role1, but user who can log into publisher should be able to view the api even though he does not have the role role1", dependsOnMethods={"testGetPublicAPIFromStoreWithRestrictedPublisherAccess"})
    public void testCheckPublisherRoleCanViewRestrictedVisibilityAPIs() throws Exception {
        APIRequest createAPIRequest = new APIRequest(this.publicAccessRestrictedVisibilityAPI, this.publicAccessRestrictedVisibilityAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(NO_ACCESS_CONTROL);
        createAPIRequest.setVisibility(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setRoles(this.FIRST_ROLE);
        this.publicAccessRestrictedVisibilityAPIId = this.createAndPublishAPIUsingRest(createAPIRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.contextUsername, this.publicAccessRestrictedVisibilityAPI, VERSION, "\"isApiExists\":true");
        APIDTO apiDto = this.apiStorePubSubUser.getAPI(this.publicAccessRestrictedVisibilityAPIId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)("Restricted visible api " + this.publicAccessRestrictedVisibilityAPI + "is not visible to user  " + this.PUB_SUB_USER + ", who can view it in publisher"));
    }

    @Test(groups={"wso2.am"}, description="This test case add restricted access in publisher(role1) and restricted visibility in store(subscriber_role1). So check correct behaviour in publisher and store ", dependsOnMethods={"testCheckPublisherRoleCanViewRestrictedVisibilityAPIs"})
    public void testPublisherAndStoreRestricted() throws Exception {
        APIRequest createAPIRequest = new APIRequest("RestrictedAccessRestrictedVisibility", "RestrictedAccessRestrictedVisibility", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setAccessControlRoles(this.FIRST_ROLE);
        createAPIRequest.setVisibility(PUBLIC_VISIBILITY);
        this.restrictedAccessRestrictedVisibilityAPIId = this.createAndPublishAPIUsingRest(createAPIRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.contextUsername, "RestrictedAccessRestrictedVisibility", VERSION, "\"isApiExists\":true");
        Thread.sleep(10000L);
        HttpResponse response = this.apiPublisherFirstUser.getAPI(this.restrictedAccessRestrictedVisibilityAPIId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertEquals((String)apidto.getName(), (String)"RestrictedAccessRestrictedVisibility", (String)("Restricted visible api RestrictedAccessRestrictedVisibilityis not visible to user  " + this.FIRST_USER + ", who should be able to view it"));
        response = this.apiPublisherPubSubUser.getAPI(this.restrictedAccessRestrictedVisibilityAPIId);
        Assert.assertNotEquals((Object)response.getResponseCode(), (Object)200, (String)("Restricted access api RestrictedAccessRestrictedVisibilityis visible to user  " + this.FIRST_USER + ", who should not be able to view it"));
        createAPIRequest.setVisibility(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setRoles(this.SUBSCRIBER_ROLE);
        this.restAPIPublisher.updateAPI(createAPIRequest, this.restrictedAccessRestrictedVisibilityAPIId);
        this.createAPIRevisionAndDeployUsingRest(this.restrictedAccessRestrictedVisibilityAPIId, this.restAPIPublisher);
        Thread.sleep(10000L);
        APIDTO apiDto = this.apiStoreSubUser.getAPI(this.restrictedAccessRestrictedVisibilityAPIId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)("Restricted visible api RestrictedAccessRestrictedVisibility is not visible to user  " + this.SUBSCRIBER_USER + ", who can view it in store"));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.publisherAccessControlAPIId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.publicAccessRestrictedVisibilityAPIId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.publisherAccessControlAPI2Id, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.restrictedAccessRestrictedVisibilityAPIId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.accessControlledPublicVisibilityAPIId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.publisherAccessControlAPIId);
        this.restAPIPublisher.deleteAPI(this.publicAccessRestrictedVisibilityAPIId);
        this.restAPIPublisher.deleteAPI(this.publisherAccessControlAPI2Id);
        this.restAPIPublisher.deleteAPI(this.restrictedAccessRestrictedVisibilityAPIId);
        this.restAPIPublisher.deleteAPI(this.accessControlledPublicVisibilityAPIId);
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.OLD_ROLE_LIST);
        }
        this.userManagementClient1.deleteUser(this.FIRST_USER);
        this.userManagementClient1.deleteUser(this.SECOND_USER);
        this.userManagementClient1.deleteUser(this.SUBSCRIBER_USER);
        this.userManagementClient1.deleteUser(this.PUB_SUB_USER);
        this.userManagementClient1.deleteRole(this.FIRST_ROLE);
        this.userManagementClient1.deleteRole(this.SECOND_ROLE);
        this.userManagementClient1.deleteRole(this.SUBSCRIBER_ROLE);
        this.userManagementClient1.deleteRole(this.PUB_SUB_ROLE);
    }
}

