/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationPoliciesDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OperationPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class RevokeOneTimeTokenFlowTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_CONTEXT = "RevokeOneTimeTokenAPITest";
    private String applicationId;
    private String apiId;
    private String accessToken;
    private String accessTokenWithoutScope;
    private String accessTokenForOutsider;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String oneTimeTokenScope = "OTT";
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("ApplicationTest", "Test Application RevokeOneTimeToken", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        Map policyMap = this.restAPIPublisher.getAllCommonOperationPolicies();
        String API_END_POINT_POSTFIX_URL = "xmlapi";
        String apiEndPointUrl = this.getAPIInvocationURLHttp(API_END_POINT_POSTFIX_URL, "1.0.0");
        String API_NAME = "RevokeOneTimeTokenAPITest";
        APIRequest apiRequest = new APIRequest(API_NAME, "RevokeOneTimeTokenAPITest", new URL(apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(oneTimeTokenScope);
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, scopes, grantTypes);
        if (applicationKeyDTO.getToken() == null) {
            throw new AssertionError();
        }
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBody = "grant_type=client_credentials&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope= ";
        JSONObject accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        this.accessTokenWithoutScope = accessTokenGenerationResponse.getString("access_token");
        UserManagementClient userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        userManagementClient.addUser("outsideUser", "outsideUserPassword", new String[]{"Internal/everyone"}, "outsideUser");
        requestBody = "grant_type=password&username=outsideUser&password=outsideUserPassword&scope=" + oneTimeTokenScope;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        this.accessTokenForOutsider = accessTokenGenerationResponse.getString("access_token");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(getAPIResponse.getData(), APIDTO.class);
        String policyName = "revokeOneTimeToken";
        Assert.assertNotNull(policyMap.get(policyName), (String)("Unable to find a common policy with name " + policyName));
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("scope", oneTimeTokenScope);
        APIOperationPoliciesDTO apiOperationPoliciesDTO = new APIOperationPoliciesDTO();
        apiOperationPoliciesDTO.setRequest(this.getPolicyList(policyName, policyMap, attributeMap));
        if (apidto.getOperations() == null) {
            throw new AssertionError();
        }
        ((APIOperationsDTO)apidto.getOperations().get(0)).setOperationPolicies(apiOperationPoliciesDTO);
        this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Invoke the API with a JWT that is not an One Time Token")
    public void testAPIInvocationWithoutAddingOneTimeTokenScopeToJWT() throws Exception {
        HttpResponse invokeAPIResponse = this.invokeAPI(this.accessTokenWithoutScope);
        Assert.assertEquals((int)invokeAPIResponse.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK);
        Thread.sleep(15000L);
        HttpResponse invokeAPIResponse2 = this.invokeAPI(this.accessTokenWithoutScope);
        Assert.assertEquals((int)invokeAPIResponse2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK);
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the revoke one time policy")
    public void testAPIInvocationOfAttachedRevokeOneTimePolicyUsingOneTimeToken() throws Exception {
        HttpResponse invokeAPIResponse = this.invokeAPI(this.accessToken);
        Assert.assertEquals((int)invokeAPIResponse.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK);
        Thread.sleep(15000L);
        HttpResponse invokeAPIResponse2 = this.invokeAPI(this.accessToken);
        Assert.assertEquals((int)invokeAPIResponse2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_UNAUTHORIZED);
    }

    @Test(groups={"wso2.am"}, description="Invoke the API with a user who does not have permission to access APIM portals")
    public void testAPIInvocationWithOutsideUser() throws Exception {
        HttpResponse invokeAPIResponse = this.invokeAPI(this.accessTokenForOutsider);
        Assert.assertEquals((int)invokeAPIResponse.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK);
        Thread.sleep(15000L);
        HttpResponse invokeAPIResponse2 = this.invokeAPI(this.accessTokenForOutsider);
        Assert.assertEquals((int)invokeAPIResponse2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_UNAUTHORIZED);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    public List<OperationPolicyDTO> getPolicyList(String policyName, Map<String, String> policyMap, Map<String, Object> attributeMap) {
        ArrayList<OperationPolicyDTO> policyList = new ArrayList<OperationPolicyDTO>();
        OperationPolicyDTO policyDTO = new OperationPolicyDTO();
        policyDTO.setPolicyName(policyName);
        policyDTO.setPolicyId(policyMap.get(policyName));
        policyDTO.setParameters(attributeMap);
        policyList.add(policyDTO);
        return policyList;
    }

    public HttpResponse invokeAPI(String accessToken) throws XPathExpressionException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("RevokeOneTimeTokenAPITest", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + accessToken);
        return client.execute((HttpUriRequest)request);
    }
}

