/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.user.RemoteUserStoreManagerServiceClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.PermissionDTO;

public class SecondaryUserStoreCaseInsensitiveTestCase
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private String FIRST_USER = "SECONDARY/testUser1";
    private String SECOND_USER = "SECONDARY/testUser2";
    private String FIRST_USER_UPPERCASE = "SECONDARY/TESTUSER1";
    private String SECOND_USER_UPPERCASE = "SECONDARY/TESTUSER2";
    private String FIRST_ROLE = "SECONDARY/userrole1";
    private String SECOND_ROLE = "SECONDARY/userrole2";
    private String FIRST_ROLE_UPPERCASE = "SECONDARY/USERROLE1";
    private String SECOND_ROLE_UPPERCASE = "SECONDARY/USERROLE2";
    private String PASSWORD = "password123";
    private final String INTERNAL_PUBLISHER = "Internal/publisher";
    private final String INTERNAL_SUBSCRIBER = "Internal/subscriber";
    String carbonHome = System.getProperty("carbon.home");

    @Factory(dataProvider="userModeDataProvider")
    public SecondaryUserStoreCaseInsensitiveTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        try {
            super.init(this.userMode);
            this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", this.userMode);
            this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
            File secondaryUserStoreFile = new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "caseInsensitiveUsername" + File.separator + "secondary.xml");
            File targetSecondaryUserStoreFile = new File(this.carbonHome + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "userstores" + File.separator + "secondary.xml");
            this.serverConfigurationManager.applyConfiguration(secondaryUserStoreFile, targetSecondaryUserStoreFile, true, true);
            this.remoteUserStoreManagerServiceClient = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while configuring the server instance: " + e.getCause()));
        }
    }

    @Test(groups={"wso2.am"}, description="Add role with any case to the secondary userstore")
    public void testAddSecondaryUserRoleWithAnyCase() throws Exception {
        try {
            Object permissionDTO = null;
            PermissionDTO[] permissionDTOList = new PermissionDTO[]{permissionDTO};
            this.remoteUserStoreManagerServiceClient.addRole(this.FIRST_ROLE, new String[0], permissionDTOList);
            this.remoteUserStoreManagerServiceClient.addRole(this.SECOND_ROLE_UPPERCASE, new String[0], permissionDTOList);
            this.remoteUserStoreManagerServiceClient.addUser(this.FIRST_USER, this.PASSWORD, new String[]{"Internal/publisher", "Internal/subscriber", this.FIRST_ROLE}, new ClaimValue[0], "default", false);
            this.remoteUserStoreManagerServiceClient.addUser(this.SECOND_USER_UPPERCASE, this.PASSWORD, new String[]{"Internal/subscriber", this.SECOND_ROLE_UPPERCASE}, new ClaimValue[0], "default", false);
            Object[] roleListUser1 = this.remoteUserStoreManagerServiceClient.getRoleListOfUser(this.FIRST_USER);
            Object[] roleListUser2 = this.remoteUserStoreManagerServiceClient.getRoleListOfUser(this.SECOND_USER);
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])roleListUser1, (Object)this.FIRST_ROLE));
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])roleListUser2, (Object)this.SECOND_ROLE_UPPERCASE));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while adding user: " + e.getCause()));
        }
    }

    @Test(groups={"wso2.am"}, description="Delete role with any case from secondary userstore", dependsOnMethods={"testAddSecondaryUserRoleWithAnyCase"})
    public void testDeleteSecondaryRoleWithAnyCase() throws Exception {
        try {
            String[] deletedRoles = new String[]{this.SECOND_ROLE_UPPERCASE};
            String[] addedRoles = new String[]{this.FIRST_ROLE};
            this.remoteUserStoreManagerServiceClient.updateRoleListOfUser(this.SECOND_USER, deletedRoles, addedRoles);
            Object[] updatedUser = this.remoteUserStoreManagerServiceClient.getRoleListOfUser(this.SECOND_USER);
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])updatedUser, (Object)this.SECOND_ROLE_UPPERCASE));
            this.remoteUserStoreManagerServiceClient.deleteRole(this.FIRST_ROLE);
            this.remoteUserStoreManagerServiceClient.deleteRole(this.SECOND_ROLE_UPPERCASE);
            Object[] roleListUser1 = this.remoteUserStoreManagerServiceClient.getRoleListOfUser(this.FIRST_USER);
            Object[] roleListUser2 = this.remoteUserStoreManagerServiceClient.getRoleListOfUser(this.SECOND_USER);
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser1, (Object)this.FIRST_ROLE));
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser1, (Object)this.SECOND_ROLE));
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser1, (Object)this.FIRST_ROLE_UPPERCASE));
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser1, (Object)this.SECOND_ROLE_UPPERCASE));
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser2, (Object)this.FIRST_ROLE));
            Assert.assertFalse((boolean)ArrayUtils.contains((Object[])roleListUser2, (Object)this.SECOND_ROLE_UPPERCASE));
            this.remoteUserStoreManagerServiceClient.deleteUser(this.FIRST_USER);
            this.remoteUserStoreManagerServiceClient.deleteUser(this.SECOND_USER_UPPERCASE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while deleting role: " + e.getCause()));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

