/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ResourcePolicyListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class SoapToRestTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(SoapToRestTestCase.class);
    private final String SOAPTOREST_API_NAME = "PhoneVerification";
    private final String API_CONTEXT = "phoneverify";
    private final String API_VERSION_1_0_0 = "1.0";
    private static final String SOAPTOREST_TEST_USER = "soaptorestuser";
    private static final String SOAPTOREST_TEST_USER_PASSWORD = "soaptorestuser";
    private static final String SOAPTOREST_ROLE = "soaptorestrole";
    private String endpointHost = "http://localhost";
    private int endpointPort;
    private int lowerPortLimit = 9950;
    private int upperPortLimit = 9999;
    private String wsdlDefinition;
    private String soapToRestAPIId;
    private WireMockServer wireMockServer;
    private String apiEndPointURL;
    private String wsdlURL;
    private String testAppId1;
    private String testAppId2;
    private String testAppId3;
    private String testAppId4;
    private String testAppId5;
    private String payload = "{\n   \"CheckPhoneNumber\":{\n      \"PhoneNumber\":\"18006785432\",\n      \"LicenseKey\":\"0\"\n   }\n}";
    private String resourceName = "/checkPhoneNumber";
    private String responseBody;
    private APIDTO apidto;
    private List<ResourcePolicyInfoDTO> resourcePoliciesIn;
    private List<ResourcePolicyInfoDTO> resourcePoliciesOut;

    @Factory(dataProvider="userModeDataProvider")
    public SoapToRestTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.userManagementClient.addUser("soaptorestuser", "soaptorestuser", new String[0], null);
        this.userManagementClient.addRole(SOAPTOREST_ROLE, new String[]{"soaptorestuser"}, new String[0]);
        this.wsdlDefinition = this.readFile(this.getAMResourceLocation() + File.separator + "soap" + File.separator + "phoneverify.wsdl");
        this.responseBody = this.readFile(this.getAMResourceLocation() + File.separator + "soap" + File.separator + "checkPhoneNumberResponseBody.xml");
        this.startWiremockServer();
        this.apiEndPointURL = this.endpointHost + ":" + this.endpointPort + "/phoneverify";
        this.wsdlURL = this.endpointHost + ":" + this.endpointPort + "/phoneverify/wsdl";
        File file = this.getTempFileWithContent(this.wsdlDefinition);
        this.restAPIPublisher.validateWsdlDefinition(null, file);
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("Unlimited");
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"PhoneVerification");
        additionalPropertiesObj.put("context", (Object)"phoneverify");
        additionalPropertiesObj.put("version", (Object)"1.0");
        JSONObject endpointObject = new JSONObject();
        endpointObject.put("type", (Object)"address");
        endpointObject.put("url", (Object)this.apiEndPointURL);
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"address");
        endpointConfig.put("sandbox_endpoints", (Object)endpointObject);
        endpointConfig.put("production_endpoints", (Object)endpointObject);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("policies", policies);
        this.apidto = this.restAPIPublisher.importWSDLSchemaDefinition(file, null, additionalPropertiesObj.toString(), "SOAPTOREST");
        this.soapToRestAPIId = this.apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.soapToRestAPIId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"PhoneVerification API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.soapToRestAPIId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.com"}, description="Created API resources validation test case")
    public void testValidateCreatedResources() throws Exception {
        Object[] expectedResources = new String[]{"/checkPhoneNumbers", "/checkPhoneNumber"};
        HttpResponse response = this.restAPIPublisher.getAPI(this.soapToRestAPIId);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        List operations = apidto.getOperations();
        Object[] actualResources = new String[operations.size()];
        for (int index = 0; index < operations.size(); ++index) {
            String resource;
            actualResources[index] = resource = ((APIOperationsDTO)operations.get(index)).getTarget();
        }
        Assert.assertEquals((int)actualResources.length, (int)expectedResources.length, (String)"Unexpected number of resources in the created API");
        Assert.assertEqualsNoOrder((Object[])actualResources, (Object[])expectedResources, (String)"Invalid set of resources");
    }

    @Test(groups={"wso2.am"}, description="In/Out sequence validation test case", dependsOnMethods={"testValidateCreatedResources"})
    public void testValidateInOutSequence() throws Exception {
        String inSequence = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("artifacts" + File.separator + "AM" + File.separator + "soap" + File.separator + "in-sequence-check-phone-numbers.xml"), (String)"UTF-8");
        ResourcePolicyListDTO resourcePolicyInListDTO = this.restAPIPublisher.getApiResourcePolicies(this.soapToRestAPIId, "in", "checkPhoneNumbers", "post");
        this.resourcePoliciesIn = resourcePolicyInListDTO.getList();
        this.resourcePoliciesIn.forEach(item -> Assert.assertEquals((String)item.getContent(), (String)inSequence, (String)"Invalid In-Sequence"));
        String outSequence = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("artifacts" + File.separator + "AM" + File.separator + "soap" + File.separator + "out-sequence-check-phone-numbers.xml"), (String)"UTF-8");
        ResourcePolicyListDTO resourcePolicyOutListDTO = this.restAPIPublisher.getApiResourcePolicies(this.soapToRestAPIId, "out", "checkPhoneNumbers", "post");
        this.resourcePoliciesOut = resourcePolicyOutListDTO.getList();
        this.resourcePoliciesOut.forEach(item -> Assert.assertEquals((String)item.getContent(), (String)outSequence, (String)"Invalid Out-Sequence"));
    }

    @Test(groups={"wso2.am"}, description="Invocation of default API", dependsOnMethods={"testValidateCreatedResources"})
    public void testDefaultAPIInvocation() throws Exception {
        this.apidto.setIsDefaultVersion(Boolean.valueOf(true));
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(this.apidto, this.soapToRestAPIId);
        this.createAPIRevisionAndDeployUsingRest(updatedAPI.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        String soapToRestAppName = "PhoneVerificationDefaultApp";
        this.testAppId1 = this.createSoapToRestAppAndSubscribeToAPI(soapToRestAppName, "OAUTH", this.soapToRestAPIId);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId1, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Invocation of a revisioned and deployed API", dependsOnMethods={"testValidateCreatedResources"})
    public void testRevisionedAPIInvocation() throws Exception {
        this.createAPIRevisionAndDeployUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        String soapToRestAppName = "PhoneVerificationRevisionedApp";
        this.testAppId2 = this.createSoapToRestAppAndSubscribeToAPI(soapToRestAppName, "OAUTH", this.soapToRestAPIId);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId2, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", "1.0") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="API invocation using JWT App")
    public void testInvokeSoapToRestAPIUsingJWTApplication() throws Exception {
        String graphqlJwtAppName = "PhoneVerificationJWTApp";
        this.testAppId3 = this.createSoapToRestAppAndSubscribeToAPI(graphqlJwtAppName, "JWT", this.soapToRestAPIId);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId3, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", "1.0") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="API invocation using oauth App")
    public void testInvokeSoapToRestAPIUsingOAuthApplication() throws Exception {
        String soapToRestOAUTHAppName = "PhoneVerificationOauthApp";
        this.testAppId4 = this.createSoapToRestAppAndSubscribeToAPI(soapToRestOAUTHAppName, "OAUTH", this.soapToRestAPIId);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId4, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", "1.0") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Oauth Scopes", dependsOnMethods={"testInvokeSoapToRestAPIUsingOAuthApplication", "testInvokeSoapToRestAPIUsingJWTApplication"})
    public void testOperationalLevelOAuthScopesForSoapToRest() throws Exception {
        ArrayList<String> role = new ArrayList<String>();
        role.add(SOAPTOREST_ROLE);
        ScopeDTO scopeObject = new ScopeDTO();
        scopeObject.setName("subscriber");
        scopeObject.setBindings(role);
        APIScopeDTO apiScopeDTO = new APIScopeDTO();
        apiScopeDTO.setScope(scopeObject);
        ArrayList<APIScopeDTO> apiScopeList = new ArrayList<APIScopeDTO>();
        apiScopeList.add(apiScopeDTO);
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.soapToRestAPIId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(createdApiResponse.getData(), APIDTO.class);
        apidto.setScopes(apiScopeList);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.soapToRestAPIId);
        this.createAPIRevisionAndDeployUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        ArrayList<String> scope = new ArrayList<String>();
        scope.add("subscriber");
        List operations = updatedAPI.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals(this.resourceName)) {
                item.setScopes((List)scope);
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.soapToRestAPIId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.createAPIRevisionAndDeployUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.testAppId5 = this.createSoapToRestAppAndSubscribeToAPI("testOperationalLevelOAuthScopesForSoapToRest", "OAUTH", this.soapToRestAPIId);
        Thread.sleep(10000L);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", "1.0") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId5, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        log.info((Object)("Access Token response without scope: " + accessToken));
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)403, (String)"Response code is not as expected");
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String username = "soaptorestuser";
        if (this.userMode != TestUserMode.SUPER_TENANT_ADMIN) {
            username = username.concat("@").concat(this.user.getUserDomain());
        }
        String requestBody = "grant_type=password&username=" + username + "&password=" + "soaptorestuser" + "&scope=subscriber";
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(response.getData());
        log.info((Object)("Access Token response with scope: " + response.getData()));
        accessToken = accessTokenGenerationResponse.getString("access_token");
        tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Oauth Scopes", dependsOnMethods={"testOperationalLevelOAuthScopesForSoapToRest"})
    public void testOperationalLevelSecurityForSoapToRest() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.soapToRestAPIId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        List operations = apidto.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals(this.resourceName)) {
                item.setAuthType("None");
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.soapToRestAPIId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.createAPIRevisionAndDeployUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", "1.0") + this.resourceName;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        String accessToken = "";
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)this.payload);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="In/Out sequence validation test case", dependsOnMethods={"testValidateInOutSequence", "testOperationalLevelSecurityForSoapToRest"})
    public void testUpdateInOutSequence() throws Exception {
        String updatedInSequence = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("artifacts" + File.separator + "AM" + File.separator + "soap" + File.separator + "updated-in-sequence-check-phone-numbers.xml"), (String)"UTF-8");
        this.resourcePoliciesIn.forEach(item -> {
            ResourcePolicyInfoDTO updatedResourcePoliciesIn = null;
            item.setContent(updatedInSequence);
            try {
                updatedResourcePoliciesIn = this.restAPIPublisher.updateApiResourcePolicies(this.soapToRestAPIId, item.getId(), item.getResourcePath(), item, null);
            }
            catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
                log.error((Object)e.getMessage());
            }
            Assert.assertEquals((String)updatedResourcePoliciesIn.getContent(), (String)updatedInSequence, (String)"In-Sequence not updated");
        });
        String updatedOutSequence = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("artifacts" + File.separator + "AM" + File.separator + "soap" + File.separator + "updated-out-sequence-check-phone-numbers.xml"), (String)"UTF-8");
        this.resourcePoliciesOut.forEach(item -> {
            item.setContent(updatedOutSequence);
            ResourcePolicyInfoDTO updatedResourcePoliciesOut = null;
            try {
                updatedResourcePoliciesOut = this.restAPIPublisher.updateApiResourcePolicies(this.soapToRestAPIId, item.getId(), item.getResourcePath(), item, null);
            }
            catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
                log.error((Object)e.getMessage());
            }
            Assert.assertEquals((String)updatedResourcePoliciesOut.getContent(), (String)updatedOutSequence, (String)"Out-Sequence not updated");
        });
    }

    private void startWiremockServer() {
        this.endpointPort = this.getAvailablePort();
        Assert.assertNotEquals((Object)this.endpointPort, (Object)-1, (String)("No available port in the range " + this.lowerPortLimit + "-" + this.upperPortLimit + " was found"));
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(this.endpointPort));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/phoneverify/wsdl")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(this.wsdlDefinition)));
        this.wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/phoneverify")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(this.responseBody)));
        this.wireMockServer.start();
    }

    private int getAvailablePort() {
        while (this.lowerPortLimit < this.upperPortLimit) {
            if (this.isPortFree(this.lowerPortLimit)) {
                return this.lowerPortLimit;
            }
            ++this.lowerPortLimit;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortFree(int port) {
        Socket s = null;
        try {
            s = new Socket(this.endpointHost, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    private String createSoapToRestAppAndSubscribeToAPI(String appName, String tokenType, String apiId) throws ApiException, APIManagerIntegrationTestException {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType(appName, "Unlimited", "", "test app for SOAPTOREST API", tokenType);
        String testApiId = applicationDTO.getApplicationId();
        this.restAPIStore.subscribeToAPI(apiId, testApiId, "Unlimited");
        return testApiId;
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("phoneverify", ".wsdl");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.userManagementClient.deleteRole(SOAPTOREST_ROLE);
        this.userManagementClient.deleteUser("soaptorestuser");
        this.restAPIStore.deleteApplication(this.testAppId1);
        this.restAPIStore.deleteApplication(this.testAppId2);
        this.restAPIStore.deleteApplication(this.testAppId3);
        this.restAPIStore.deleteApplication(this.testAppId4);
        this.restAPIStore.deleteApplication(this.testAppId5);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.soapToRestAPIId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.soapToRestAPIId);
        this.wireMockServer.stop();
        super.cleanUp();
    }
}

