/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TagsRatingTestCase
extends APIMIntegrationBaseTest {
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public TagsRatingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Comment Rating Test case")
    public void testTagsTestCase() throws Exception {
        String APIName = "CommentRatingAPI";
        String APIContext = "commentRating";
        String tags = "youtube, video, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        HttpResponse serviceGetResponse = this.restAPIPublisher.getAPI(this.apiId);
        String apiData = serviceGetResponse.getData();
        JSONObject apiObject = new JSONObject(apiData);
        JSONArray tagsList = (JSONArray)apiObject.get("tags");
        for (int i = 0; i < tagsList.length(); ++i) {
            Assert.assertTrue((boolean)tags.contains(tagsList.getString(i)), (String)"API tag data mismatched");
        }
    }

    @Test(dependsOnMethods={"testTagsTestCase"}, groups={"wso2.am"}, description="Test and Verify Added Rating Test Case")
    public void testRatingTest() throws Exception {
        Integer rating = 4;
        HttpResponse ratingAddResponse = this.restAPIStore.addRating(this.apiId, Integer.valueOf(4), this.gatewayContextWrk.getContextTenant().getDomain());
        Assert.assertEquals((int)ratingAddResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error adding rating");
        Gson getRatingsGson = new Gson();
        RatingDTO ratingDTO = (RatingDTO)getRatingsGson.fromJson(ratingAddResponse.getData(), RatingDTO.class);
        Assert.assertEquals((Object)ratingDTO.getRating(), (Object)rating, (String)"Ratings do not match");
        HttpResponse deleteRatingResponse = this.restAPIStore.removeRating(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain());
        Assert.assertEquals((int)deleteRatingResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

