/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenEncryptionScopeTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(TokenEncryptionScopeTestCase.class);
    private UserManagementClient userManagementClient1 = null;
    private static final String API_NAME = "TokenEncryptionAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "TokenEncryptionApp";
    private static final String USER_SAM = "sam";
    private static final String APP_DEV_USER = "mike";
    private static final String APP_DEV_PWD = "mike123";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private static String applicationId;
    private static String apiId;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Check if Scopes work fine with token encryption enabled.")
    public void testTokenEncryptionWithScopes() throws XPathExpressionException {
        try {
            this.userManagementClient1 = new UserManagementClient(this.publisherContext.getContextUrls().getBackEndUrl(), this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
            this.userManagementClient1.addRole(SUBSCRIBER_ROLE, new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient1.addUser(USER_SAM, "sam123", new String[]{SUBSCRIBER_ROLE}, USER_SAM);
            this.userManagementClient1.addUser(APP_DEV_USER, APP_DEV_PWD, new String[]{SUBSCRIBER_ROLE}, APP_DEV_USER);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while creating UserManagementClient " + axisFault.getMessage()));
            Assert.assertTrue((boolean)false, (String)axisFault.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Error when getting backend URLs of the publisher to initialize the UserManagementClient" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        String apiContext = "tokenencapi";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Integration Test error occurred ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        try {
            HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
            apiId = apiResponse.getData();
            this.restAPIPublisher.changeAPILifeCycleStatus(apiId, APILifeCycleAction.PUBLISH.getAction(), null);
            String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"TokenEncryptionAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"admin\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"admin,subscriber\"}]}}}";
            this.restAPIPublisher.updateSwagger(apiId, modifiedResource);
            HttpResponse applicationResponse = this.restAPIStore.createApplication(APP_NAME, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
            applicationId = applicationResponse.getData();
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("client_credentials");
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
            String consumerKey = applicationKeyDTO.getConsumerKey();
            String consumerSecret = applicationKeyDTO.getConsumerSecret();
            URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
            String requestBody = "grant_type=password&username=sam&password=sam123&scope=user_scope";
            HttpResponse firstResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
            JSONObject accessTokenGenerationResponse = new JSONObject(firstResponse.getData());
            String receivedScope = accessTokenGenerationResponse.getString("scope");
            Assert.assertEquals((String)receivedScope, (String)"user_scope", (String)("Received scope is " + receivedScope + ", but expected user_scope"));
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Error occurred while executing Test", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Malformed tokenEndpointURL ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (JSONException e) {
            log.error((Object)"Could not parse response JSON message received from the token endpoint ", (Throwable)e);
        }
        catch (org.wso2.am.integration.clients.publisher.api.ApiException e) {
            e.printStackTrace();
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(applicationId);
        this.restAPIPublisher.deleteAPI(apiId);
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser(USER_SAM);
            this.userManagementClient1.deleteUser(APP_DEV_USER);
            this.userManagementClient1.deleteRole(SUBSCRIBER_ROLE);
        }
    }
}

