/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class WSDLImportTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(WSDLImportTestCase.class);
    private String WSDL_FILE_API_NAME = "WSDLImportAPIWithWSDLFile";
    private String WSDL_FILE_API_CONTEXT = "wsdlimportwithwsdlfile";
    private String WSDL_ZIP_API_NAME = "WSDLImportAPIWithZipFile";
    private String WSDL_ZIP_API_CONTEXT = "wsdlimportwithzipfile";
    private String WSDL_URL_API_NAME = "WSDLImportAPIWithURL";
    private String WSDL_URL_API_CONTEXT = "wsdlimportwithurl";
    private String API_VERSION = "1.0.0";
    private String backendEndUrl;
    private String wsdlFileApiId;
    private String zipFileApiId;
    private String wsdlUrlApiId;
    private ArrayList<String> grantTypes;
    private String publisherURLHttps;
    private String userName;
    private String password;
    private String tenantDomain;
    private final String KEYSTORE_FILE_PATH_CLIENT = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "wso2carbon.jks";
    private final String TRUSTSTORE_FILE_PATH_CLIENT = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "client-truststore.jks";
    private String applicationId;
    private String applicationId2;
    private String accessToken;
    private String wsdlDefinition;
    private String requestBody;
    private String responseBody;
    private String endpointHost = "http://localhost";
    private int endpointPort;
    private int lowerPortLimit = 9950;
    private int upperPortLimit = 9999;
    private WireMockServer wireMockServer;
    private String apiEndPointURL;
    private String wsdlURL;
    private String apiId1;
    private String apiId2;
    private String apiId3;
    private ApplicationKeyDTO applicationKeyDTO;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.log.info((Object)"WSDLImportTestCase initiated");
        super.init();
        this.tenantDomain = this.storeContext.getContextTenant().getDomain();
        this.userName = this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName();
        this.password = this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword();
        this.grantTypes = new ArrayList();
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
        System.setProperty("javax.net.ssl.keyStoreType", "JKS");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("javax.net.ssl.keyStore", this.KEYSTORE_FILE_PATH_CLIENT);
        System.setProperty("javax.net.ssl.keyStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStore", this.TRUSTSTORE_FILE_PATH_CLIENT);
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        this.wsdlDefinition = this.readFile(this.getAMResourceLocation() + File.separator + "soap" + File.separator + "phoneverify.wsdl");
        this.requestBody = this.readFile(this.getAMResourceLocation() + File.separator + "soap" + File.separator + "checkPhoneNumberRequestBody.xml");
        this.responseBody = this.readFile(this.getAMResourceLocation() + File.separator + "soap" + File.separator + "checkPhoneNumberResponseBody.xml");
        this.startWiremockServer();
        this.apiEndPointURL = this.endpointHost + ":" + this.endpointPort + "/phoneverify";
        this.wsdlURL = this.endpointHost + ":" + this.endpointPort + "/phoneverify/wsdl";
    }

    @Test(groups={"wso2.am"}, description="Importing WSDL API definition and create API")
    public void testWsdlDefinitionImport() throws Exception {
        this.log.info((Object)"testWsdlDefinitionImport initiated");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("Unlimited");
        JSONObject url = new JSONObject();
        url.put("url", (Object)this.apiEndPointURL);
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("name", (Object)this.WSDL_FILE_API_NAME);
        additionalPropertiesObj.put("context", (Object)this.WSDL_FILE_API_CONTEXT);
        additionalPropertiesObj.put("version", (Object)this.API_VERSION);
        additionalPropertiesObj.put("policies", policies);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        String wsdlDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "wsdl" + File.separator + "Sample.wsdl";
        File file = new File(wsdlDefinitionPath);
        APIDTO wsdlFileApidto = this.restAPIPublisher.importWSDLSchemaDefinition(file, null, additionalPropertiesObj.toString(), "SOAP");
        Assert.assertEquals((String)wsdlFileApidto.getName(), (String)this.WSDL_FILE_API_NAME);
        Assert.assertEquals((String)wsdlFileApidto.getContext(), (String)("/" + this.WSDL_FILE_API_CONTEXT));
        this.wsdlFileApiId = wsdlFileApidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.wsdlFileApiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.userName, this.WSDL_FILE_API_NAME, this.API_VERSION, "\"isApiExists\":true");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.wsdlFileApiId, "Publish");
        HttpResponse createdApiResponse1 = this.restAPIPublisher.getAPI(this.wsdlFileApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse1.getResponseCode());
        additionalPropertiesObj.put("name", (Object)this.WSDL_ZIP_API_NAME);
        additionalPropertiesObj.put("context", (Object)this.WSDL_ZIP_API_CONTEXT);
        String wsdlZipDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "wsdl" + File.separator + "Sample.zip";
        File zipFile = new File(wsdlZipDefinitionPath);
        APIDTO zipFileApidto = this.restAPIPublisher.importWSDLSchemaDefinition(zipFile, null, additionalPropertiesObj.toString(), "SOAP");
        Assert.assertEquals((String)zipFileApidto.getName(), (String)this.WSDL_ZIP_API_NAME);
        Assert.assertEquals((String)zipFileApidto.getContext(), (String)("/" + this.WSDL_ZIP_API_CONTEXT));
        this.zipFileApiId = zipFileApidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.zipFileApiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.userName, this.WSDL_ZIP_API_NAME, this.API_VERSION, "\"isApiExists\":true");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.zipFileApiId, "Publish");
        HttpResponse createdApiResponse2 = this.restAPIPublisher.getAPI(this.zipFileApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse2.getResponseCode());
        additionalPropertiesObj.put("name", (Object)this.WSDL_URL_API_NAME);
        additionalPropertiesObj.put("context", (Object)this.WSDL_URL_API_CONTEXT);
        APIDTO wsdlUrlApidto = this.restAPIPublisher.importWSDLSchemaDefinition(null, this.wsdlURL, additionalPropertiesObj.toString(), "SOAP");
        Assert.assertEquals((String)wsdlUrlApidto.getName(), (String)this.WSDL_URL_API_NAME);
        Assert.assertEquals((String)wsdlUrlApidto.getContext(), (String)("/" + this.WSDL_URL_API_CONTEXT));
        this.wsdlUrlApiId = wsdlUrlApidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.wsdlUrlApiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.userName, this.WSDL_URL_API_NAME, this.API_VERSION, "\"isApiExists\":true");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.wsdlUrlApiId, "Publish");
        HttpResponse createdApiResponse3 = this.restAPIPublisher.getAPI(this.wsdlUrlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse3.getResponseCode());
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("ApplicationTest", "Unlimited", "", "");
        this.applicationId = applicationDTO.getApplicationId();
        this.restAPIStore.subscribeToAPI(this.wsdlUrlApiId, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken(), (String)"Unable to get access token");
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Get WSDL API definition of the created API", dependsOnMethods={"testWsdlDefinitionImport"})
    public void testGetWsdlDefinitions() throws Exception {
        this.log.info((Object)"testGetWsdlDefinition initiated");
        org.wso2.am.integration.clients.publisher.api.ApiResponse wsdlFileFlowResponse = this.restAPIPublisher.getWSDLSchemaDefinitionOfAPI(this.wsdlFileApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)wsdlFileFlowResponse.getStatusCode());
        org.wso2.am.integration.clients.publisher.api.ApiResponse zipFileFlowResponse = this.restAPIPublisher.getWSDLSchemaDefinitionOfAPI(this.zipFileApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)zipFileFlowResponse.getStatusCode());
        org.wso2.am.integration.clients.publisher.api.ApiResponse wsdlUrlFlowResponse = this.restAPIPublisher.getWSDLSchemaDefinitionOfAPI(this.wsdlUrlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)wsdlUrlFlowResponse.getStatusCode());
    }

    @Test(groups={"wso2.am"}, description="Download WSDL API definition of the created API from the store", dependsOnMethods={"testGetWsdlDefinitions"})
    public void testDownloadWsdlDefinitionsFromStore() throws Exception {
        this.log.info((Object)"testDownloadWsdlDefinitionFromStore initiated");
        String environmentName = "Default";
        ApiResponse wsdlFileFlowResponse = this.restAPIStore.downloadWSDLSchemaDefinitionOfAPI(this.wsdlFileApiId, environmentName);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)wsdlFileFlowResponse.getStatusCode());
        ApiResponse zipFileFlowResponse = this.restAPIStore.downloadWSDLSchemaDefinitionOfAPI(this.zipFileApiId, environmentName);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)zipFileFlowResponse.getStatusCode());
        ApiResponse wsdlUrlFlowResponse = this.restAPIStore.downloadWSDLSchemaDefinitionOfAPI(this.wsdlUrlApiId, environmentName);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)wsdlUrlFlowResponse.getStatusCode());
    }

    @Test(groups={"wso2.am"}, description="Test invoking Check Phone Number method", dependsOnMethods={"testDownloadWsdlDefinitionsFromStore"})
    public void testInvokeCheckPhoneNumber() throws Exception {
        this.log.info((Object)"testInvokeCheckPhoneNumber initiated");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/xml");
        headers.put("accept", "text/xml");
        headers.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp(this.WSDL_URL_API_CONTEXT, this.API_VERSION)), (String)this.requestBody, headers);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Unable to invoke Pass Through SOAP API");
    }

    private void startWiremockServer() {
        this.endpointPort = this.getAvailablePort();
        Assert.assertNotEquals((Object)this.endpointPort, (Object)-1, (String)("No available port in the range " + this.lowerPortLimit + "-" + this.upperPortLimit + " was found"));
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(this.endpointPort));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/phoneverify/wsdl")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(this.wsdlDefinition)));
        this.wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/phoneverify")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(this.responseBody)));
        this.wireMockServer.start();
    }

    @Test(groups={"wso2.am"}, description="Importing WSDL API definition and create API", dependsOnMethods={"testDownloadWsdlDefinitionsFromStore"})
    public void testCreateSOAPAPIFromFile() throws Exception {
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"http://ws.cdyne.com/phoneverify/phoneverify.asmx");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Production and Sandbox");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"PhoneVerification");
        apiProperties.put("context", (Object)"phoneverify");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("policies", tierList);
        String wsdlDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "wsdl" + File.separator + "PhoneVerification.wsdl";
        File file = new File(wsdlDefinitionPath);
        APIDTO apidto = this.restAPIPublisher.importWSDLSchemaDefinition(file, this.backendEndUrl, apiProperties.toString(), "SOAP");
        Assert.assertEquals((String)apidto.getName(), (String)"PhoneVerification");
        this.apiId1 = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId1);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode());
        this.createAPIRevisionAndDeployUsingRest(this.apiId1, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId1, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerification", "1.0.0", "\"isApiExists\":true");
        HttpResponse applicationResponse = this.restAPIStore.createApplication("TestApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId2 = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(this.apiId1, this.applicationId2, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId2, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found ", (String)accessToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "text/xml");
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("phoneverify", this.API_VERSION);
        String requestBody = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> <soap:Body> <CheckPhoneNumber xmlns=\"http://ws.cdyne.com/PhoneVerify/query\"> <PhoneNumber>077383968</PhoneNumber> <LicenseKey>123</LicenseKey> </CheckPhoneNumber> </soap:Body></soap:Envelope>";
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)requestBody);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"API invocation failed");
    }

    @Test(groups={"wso2.am"}, description="Importing WSDL archive and create API", dependsOnMethods={"testCreateSOAPAPIFromFile"})
    public void testCreateSOAPAPIFromArchive() throws Exception {
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"http://ws.cdyne.com/phoneverify/phoneverify.asmx");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Production and Sandbox");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"PhoneVerificationArchive");
        apiProperties.put("context", (Object)"phoneverifyarchive");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("policies", tierList);
        String wsdlDefinitionPath = FrameworkPathUtil.getSystemResourceLocation() + "wsdl" + File.separator + "PhoneVerification.zip";
        File file = new File(wsdlDefinitionPath);
        APIDTO apidto = this.restAPIPublisher.importWSDLSchemaDefinition(file, this.backendEndUrl, apiProperties.toString(), "SOAP");
        Assert.assertEquals((String)apidto.getName(), (String)"PhoneVerificationArchive");
        this.apiId2 = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId2);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode());
        this.createAPIRevisionAndDeployUsingRest(this.apiId2, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId2, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerificationArchive", "1.0.0", "\"isApiExists\":true");
        this.restAPIStore.subscribeToAPI(this.apiId2, this.applicationId2, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found ", (String)accessToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "text/xml");
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("phoneverifyarchive", this.API_VERSION);
        String requestBody = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> <soap:Body> <CheckPhoneNumber xmlns=\"http://ws.cdyne.com/PhoneVerify/query\"> <PhoneNumber>077383968</PhoneNumber> <LicenseKey>123</LicenseKey> </CheckPhoneNumber> </soap:Body></soap:Envelope>";
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)requestBody);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"API invocation failed");
    }

    @Test(groups={"wso2.am"}, description="Creating SOAP API from URL", dependsOnMethods={"testCreateSOAPAPIFromArchive"})
    public void testCreateSOAPAPIFromURL() throws Exception {
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"http://ws.cdyne.com/phoneverify/phoneverify.asmx");
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Production and Sandbox");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"PhoneVerificationURL");
        apiProperties.put("context", (Object)"phoneverifyurl123");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("policies", tierList);
        APIDTO apidto = this.restAPIPublisher.importWSDLSchemaDefinition(null, "http://ws.cdyne.com/phoneverify/phoneverify.asmx?wsdl", apiProperties.toString(), "SOAP");
        Assert.assertEquals((String)apidto.getName(), (String)"PhoneVerificationURL");
        this.apiId3 = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.apiId3);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode());
        this.createAPIRevisionAndDeployUsingRest(this.apiId3, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId3, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "PhoneVerificationURL", "1.0.0", "\"isApiExists\":true");
        this.restAPIStore.subscribeToAPI(this.apiId3, this.applicationId2, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        String accessToken = this.applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found ", (String)accessToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "text/xml");
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("phoneverifyurl123", this.API_VERSION);
        String requestBody = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> <soap:Body> <CheckPhoneNumber xmlns=\"http://ws.cdyne.com/PhoneVerify/query\"> <PhoneNumber>077383968</PhoneNumber> <LicenseKey>123</LicenseKey> </CheckPhoneNumber> </soap:Body></soap:Envelope>";
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)requestBody);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"API invocation failed");
    }

    private int getAvailablePort() {
        while (this.lowerPortLimit < this.upperPortLimit) {
            if (this.isPortFree(this.lowerPortLimit)) {
                return this.lowerPortLimit;
            }
            ++this.lowerPortLimit;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortFree(int port) {
        Socket s = null;
        try {
            s = new Socket(this.endpointHost, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    @AfterClass(alwaysRun=true)
    void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIStore.deleteApplication(this.applicationId2);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.wsdlFileApiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.zipFileApiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.wsdlUrlApiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId1, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId2, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId3, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.wsdlFileApiId);
        this.restAPIPublisher.deleteAPI(this.zipFileApiId);
        this.restAPIPublisher.deleteAPI(this.wsdlUrlApiId);
        this.restAPIPublisher.deleteAPI(this.apiId1);
        this.restAPIPublisher.deleteAPI(this.apiId2);
        this.restAPIPublisher.deleteAPI(this.apiId3);
        this.wireMockServer.stop();
    }
}

