/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.prototype;

import java.net.URL;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM23VisibilityOfPrototypedAPIInStoreTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM23PrototypedAPI";
    private final String apiVersion = "1.0.0";
    private RestAPIPublisherImpl restAPIPublisher;
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiID;
    private APIIdentifier apiIdentifier;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init();
        String apiPrototypeEndpointPostfixUrl = "pizzashack-api-1.0.0/api/";
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiPrototypeEndpointPostfixUrl;
        this.restAPIPublisher = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifier = new APIIdentifier(this.apiProvider, "APIM23PrototypedAPI", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Create an API & deployed as a prototype and check the visibility in prototype API In store")
    public void testVisibilityInPrototypedAPI() throws Exception {
        String apiContext = "apim23pizzashack";
        String apiTags = "pizza, order, pizza-menu";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        APIRequest apiRequest = new APIRequest("APIM23PrototypedAPI", apiContext, new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setDescription(apiDescription);
        apiRequest.setTags(apiTags);
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)addAPIResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Invalid Response Code");
        this.apiID = addAPIResponse.getData();
        WorkflowResponseDTO lcChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction());
        Assert.assertTrue((boolean)lcChangeResponse.getLifecycleState().getState().equals("Prototyped"), (String)"APIM23PrototypedAPI  status not updated as Prototyped");
        Thread.sleep(15000L);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllAPIsResponse = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllAPIsResponse), (String)"ImplementedAPIM23PrototypedAPI Api is not visible in API Publisher.");
        Thread.sleep(15000L);
        APIListDTO prototypedAPIs = this.restAPIStore.getPrototypedAPIs("carbon.super");
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)prototypedAPIs), (String)"APIM23PrototypedAPI is not visible as Prototyped API");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiID);
        super.cleanUp();
    }
}

