/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.prototype;

import com.google.gson.Gson;
import java.net.URL;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TagListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM24VisibilityOfPrototypedAPIOfDifferentViewInStoreTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM24PrototypedAPI";
    private final String apiVersion = "1.0.0";
    private final String apiTags = "pizza, order, pizza-menu";
    private final String superUser = "carbon.super";
    private String apiEndPointUrl;
    private String apiId;
    private APIIdentifier apiIdentifier;
    private APIListDTO apis;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + "pizzashack-api-1.0.0/api/";
    }

    @Test(groups={"wso2.am"}, description="Open already Saved API in design stage and Deploy it as a prototype and check the visibility of prototyped API In store")
    public void testOpenAlreadySavedAPIAndDeployedAsAPrototyped() throws Exception {
        String apiContext = "apim24prototypedApi";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        String apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifier = new APIIdentifier(apiProvider, "APIM24PrototypedAPI", "1.0.0");
        APIRequest apiRequest = new APIRequest("APIM24PrototypedAPI", apiContext, new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(apiProvider);
        apiRequest.setTags("pizza, order, pizza-menu");
        this.apiId = this.restAPIPublisher.addAPI(apiRequest).getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction());
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + this.apiEndPointUrl + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + this.apiEndPointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\",\n  \"implementation_status\": \"prototyped\"\n}";
        JSONParser parser = new JSONParser();
        JSONObject endpoint = (JSONObject)parser.parse(endPointString);
        apidto.setEndpointConfig((Object)endpoint);
        this.restAPIPublisher.updateAPI(apidto);
        HttpResponse response2 = this.restAPIPublisher.getAPI(this.apiId);
        Gson g2 = new Gson();
        APIDTO apidto2 = (APIDTO)g2.fromJson(response2.getData(), APIDTO.class);
        JSONObject endPointConfigUpdated = (JSONObject)apidto.getEndpointConfig();
        String implementation_status = (String)endPointConfigUpdated.get((Object)"implementation_status");
        String lcStatus = apidto2.getLifeCycleStatus();
        Assert.assertEquals((String)implementation_status, (String)"prototyped", (String)"Endpoint implementation is not prototyped");
        Assert.assertEquals((String)lcStatus, (String)"PROTOTYPED", (String)"Lifecycle status is not PROTOTYPED");
        Thread.sleep(20000L);
        this.apis = this.restAPIStore.getPrototypedAPIs("carbon.super");
        Assert.assertTrue((this.apis.getList().size() > 0 ? 1 : 0) != 0, (String)"APIM24PrototypedAPI is not visible as Prototyped API");
    }

    @Test(groups={"wso2.am"}, description="API deployed as a prototype and check the visibility in general store", dependsOnMethods={"testOpenAlreadySavedAPIAndDeployedAsAPrototyped"})
    public void testPrototypedAPIVisibilityInGeneralAPI() {
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)this.apis), (String)"APIM24PrototypedAPIis not in general Store.");
    }

    @Test(groups={"wso2.am"}, description="API deployed as a prototype and check the tags of API visibility in Tag list in store", dependsOnMethods={"testPrototypedAPIVisibilityInGeneralAPI"})
    public void testTagsOfPrototypedAPIVisibilityInTagList() throws ApiException {
        TagListDTO allTags = this.restAPIStore.getAllTags();
        Assert.assertFalse((boolean)allTags.getList().contains("pizza, order, pizza-menu"), (String)"Tags ofAPIM24PrototypedAPI PizzaAPI are visible in Tag List.");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException, JSONException, org.wso2.am.integration.clients.publisher.api.ApiException {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEMOTE_TO_CREATE.getAction());
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

