/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.prototype;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class PrototypedAPITestcase
extends APIMIntegrationBaseTest {
    private final String apiVersion = "1.0.0";
    private String apiProvider;
    private String apiName;
    private String apiEndPointUrl;
    private String resourcePath;
    private String apiID;
    private APIIdentifier apiIdentifier;
    private final String APPLICATION_NAME = "PrototypedAPITestcaseApllication";
    private String accessToken;
    String applicationId1;
    String applicationId2;
    String applicationId3;

    @Factory(dataProvider="userModeDataProvider")
    public PrototypedAPITestcase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init(this.userMode);
        this.apiProvider = this.user.getUserName();
        String apiPrototypeEndpointPostfixUrl = "am/sample/pizzashack/v1/api/menu";
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiPrototypeEndpointPostfixUrl;
    }

    @Test(groups={"wso2.am"}, description="Create an API with a prototype endpoint and invoke")
    public void testPrototypedAPIEndpoint() throws Exception {
        this.apiName = "APIMPrototypedEndpointAPI1";
        String apiContext = "pizzashack-prototype";
        String apiTags = "pizza, order, pizza-menu";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        this.apiIdentifier = new APIIdentifier(this.apiProvider, this.apiName, "1.0.0");
        APIRequest apiRequest = new APIRequest(this.apiName, apiContext, new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setDescription(apiDescription);
        apiRequest.setTags(apiTags);
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest.setProvider(this.apiProvider);
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)addAPIResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Invalid Response Code");
        this.apiID = addAPIResponse.getData();
        WorkflowResponseDTO lcChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction());
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        String endPointString = "{\"implementation_status\":\"prototyped\",\"endpoint_type\":\"http\",\"production_endpoints\":{\"config\":null,\"url\":\"" + this.apiEndPointUrl + "\"},\"sandbox_endpoints\":{\"config\":null,\"url\":\"" + this.apiEndPointUrl + "\"}}";
        JSONParser parser = new JSONParser();
        JSONObject endpoint = (JSONObject)parser.parse(endPointString);
        apidto.setEndpointConfig((Object)endpoint);
        this.restAPIPublisher.updateAPI(apidto);
        Assert.assertTrue((boolean)lcChangeResponse.getLifecycleState().getState().equals("Prototyped"), (String)(this.apiName + "  status not updated as Prototyped"));
        this.waitForAPIDeployment();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllAPIsResponse = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllAPIsResponse), (String)("Implemented" + this.apiName + " Api is not visible in API Publisher."));
        this.waitForAPIDeployment();
        APIListDTO prototypedAPIs = this.restAPIStore.getPrototypedAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)prototypedAPIs), (String)(this.apiName + " is not visible as Prototyped API"));
        HttpResponse applicationResponse = this.restAPIStore.createApplication("PrototypedAPITestcaseApllicationtestPrototypedAPIEndpoint", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        this.applicationId1 = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(this.apiID, this.applicationId1, "Gold");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId1, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        requestHeaders.put("accept", "application/json");
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps(apiContext, "1.0.0") + ""), requestHeaders);
        Assert.assertEquals((int)response1.getResponseCode(), (int)200);
        Assert.assertTrue((boolean)response1.getData().contains("BBQ Chicken Bacon"));
    }

    @Test(groups={"wso2.am"}, description="Create an API with a prototype endpoint, demote to created and invoke", dependsOnMethods={"testPrototypedAPIEndpoint"})
    public void testDemotedPrototypedEndpointAPItoCreated() throws Exception {
        this.apiName = "APIMPrototypedEndpointAPI2";
        String apiContext = "pizzashack-prototype2";
        String apiTags = "pizza, order, pizza-menu";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        this.apiIdentifier = new APIIdentifier(this.apiProvider, this.apiName, "1.0.0");
        APIRequest apiRequest = new APIRequest(this.apiName, apiContext, new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setDescription(apiDescription);
        apiRequest.setTags(apiTags);
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest.setProvider(this.apiProvider);
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)addAPIResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Invalid Response Code");
        this.apiID = addAPIResponse.getData();
        WorkflowResponseDTO lcChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction());
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        String endPointString = "{\"implementation_status\":\"prototyped\",\"endpoint_type\":\"http\",\"production_endpoints\":{\"config\":null,\"url\":\"" + this.apiEndPointUrl + "\"},\"sandbox_endpoints\":{\"config\":null,\"url\":\"" + this.apiEndPointUrl + "\"}}";
        JSONParser parser = new JSONParser();
        JSONObject endpoint = (JSONObject)parser.parse(endPointString);
        apidto.setEndpointConfig((Object)endpoint);
        this.restAPIPublisher.updateAPI(apidto);
        Assert.assertTrue((boolean)lcChangeResponse.getLifecycleState().getState().equals("Prototyped"), (String)(this.apiName + "  status not updated as Prototyped"));
        this.waitForAPIDeployment();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllAPIsResponse = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllAPIsResponse), (String)("Implemented" + this.apiName + " Api is not visible in API Publisher."));
        this.waitForAPIDeployment();
        APIListDTO prototypedAPIs = this.restAPIStore.getPrototypedAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)prototypedAPIs), (String)(this.apiName + " is not visible as Prototyped API"));
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.DEMOTE_TO_CREATE.getAction());
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equals(this.restAPIPublisher.getLifecycleStatus(this.apiID).getData()), (String)(this.apiName + "status not updated as CREATED"));
        this.waitForAPIDeployment();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        HttpResponse response2 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps(apiContext, "1.0.0") + ""), requestHeaders);
        Assert.assertEquals((int)response2.getResponseCode(), (int)401, (String)"User was able to invoke the API demoted to CREATED from PROTOTYPE");
    }

    @Test(groups={"wso2.am"}, description="Create an inline protoype API with OAS3 and Generate mock")
    public void testOAS3InlinePrototypeWithMock() throws Exception {
        String context = "/SwaggerPetstorev3import";
        this.resourcePath = "oas" + File.separator + "v3" + File.separator;
        String originalDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "prototype" + File.separator + "oas_import.json"), (String)"UTF-8");
        String additionalProperties = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "prototype" + File.separator + "additionalProperties.json"), (String)"UTF-8");
        String updatedMock = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "prototype" + File.separator + "updatedMockOas.json"), (String)"UTF-8");
        org.json.JSONObject additionalPropertiesObj = new org.json.JSONObject(additionalProperties);
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            context = "/t/" + this.user.getUserDomain() + context;
        }
        additionalPropertiesObj.put("context", (Object)context);
        org.json.JSONObject updatedMockObj = new org.json.JSONObject(updatedMock);
        updatedMockObj.put("provider", (Object)this.user.getUserName());
        File file = this.getTempFileWithContent(originalDefinition);
        APIDTO apidto = this.restAPIPublisher.importOASDefinition(file, additionalPropertiesObj.toString());
        String apiImportId = apidto.getId();
        this.restAPIPublisher.changeAPILifeCycleStatus(apiImportId, "Deploy as a Prototype");
        HttpResponse mockgenResponse = this.restAPIPublisher.generateMockScript(apiImportId);
        Assert.assertEquals((int)mockgenResponse.getResponseCode(), (int)200);
        HttpResponse mockedGetResponse = this.restAPIPublisher.getGenerateMockScript(apiImportId);
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/pets"));
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/pets/{petId}"));
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/oldpets"));
        this.createAPIRevisionAndDeployUsingRest(apiImportId, this.restAPIPublisher);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("PrototypedAPITestcaseApllicationtestOAS3InlinePrototypeWithMock", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        this.applicationId2 = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(apiImportId, this.applicationId2, "Unlimited");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId2, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        requestHeaders.put("accept", "application/json");
        this.waitForAPIDeployment();
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("SwaggerPetstorev3import", "1.0.0") + "/pets/1"), requestHeaders);
        Assert.assertEquals((int)response1.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Create an inline protoype API with OAS2 and Generate mock")
    public void testOAS2InlinePrototypeWithMock() throws Exception {
        String context = "/SwaggerPetstorev2import";
        this.resourcePath = "oas" + File.separator + "v2" + File.separator;
        String originalDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "prototype" + File.separator + "oas_import.json"), (String)"UTF-8");
        String additionalProperties = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "prototype" + File.separator + "additionalProperties.json"), (String)"UTF-8");
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            context = "/t/" + this.user.getUserDomain() + context;
        }
        org.json.JSONObject additionalPropertiesObj = new org.json.JSONObject(additionalProperties);
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        additionalPropertiesObj.put("context", (Object)context);
        File file = this.getTempFileWithContent(originalDefinition);
        APIDTO apidto = this.restAPIPublisher.importOASDefinition(file, additionalPropertiesObj.toString());
        String apiImportId = apidto.getId();
        this.restAPIPublisher.changeAPILifeCycleStatus(apiImportId, "Deploy as a Prototype");
        HttpResponse mockgenResponse = this.restAPIPublisher.generateMockScript(apiImportId);
        Assert.assertEquals((int)mockgenResponse.getResponseCode(), (int)200);
        HttpResponse mockedGetResponse = this.restAPIPublisher.getGenerateMockScript(apiImportId);
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/pets"));
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/pets/{petId}"));
        Assert.assertTrue((boolean)mockedGetResponse.getData().contains("/oldpets"));
        this.createAPIRevisionAndDeployUsingRest(apiImportId, this.restAPIPublisher);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("PrototypedAPITestcaseApllicationtestOAS2InlinePrototypeWithMock", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        this.applicationId3 = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(apiImportId, this.applicationId3, "Unlimited");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId3, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        requestHeaders.put("accept", "application/json");
        this.waitForAPIDeployment();
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("SwaggerPetstorev2import", "1.0.0") + "/pets/1"), requestHeaders);
        Assert.assertEquals((int)response1.getResponseCode(), (int)200);
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId1);
        this.restAPIStore.deleteApplication(this.applicationId2);
        this.restAPIStore.deleteApplication(this.applicationId3);
        super.cleanUp();
    }

    private File getTempFileWithContent(String swagger) throws Exception {
        File temp = File.createTempFile("swagger", ".json");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(swagger);
        out.close();
        return temp;
    }
}

