/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM18CreateAnAPIThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM18PublisherTest";
    private final String apiVersion = "1.0.0";
    private String apiProviderName;
    private String apiProductionEndPointUrl;
    private String apiId;
    private String apiId2;

    @Factory(dataProvider="userModeDataProvider")
    public APIM18CreateAnAPIThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim18PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag18-1, tag18-2, tag18-3";
        APIRequest apiCreationRequestBean = new APIRequest("APIM18PublisherTest", apiContextTest, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion("1.0.0");
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setTier("Gold");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setDefault_version_checked("true");
        apiCreationRequestBean.setBusinessOwner("api18b");
        apiCreationRequestBean.setBusinessOwnerEmail("api18b@ee.com");
        apiCreationRequestBean.setTechnicalOwner("api18t");
        apiCreationRequestBean.setTechnicalOwnerEmail("api18t@ww.com");
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.apiId = apiCreationResponse.getData();
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertTrue((boolean)response.getData().contains("APIM18PublisherTest"), (String)"Invalid API Name");
        Assert.assertTrue((boolean)response.getData().contains("1.0.0"), (String)"Invalid API Version");
        Assert.assertTrue((boolean)response.getData().contains(apiContextTest), (String)"Invalid API Context");
    }

    @Test(groups={"wso2.am"}, description="Remove an API Through the Publisher Rest API", dependsOnMethods={"testCreateAnAPIThroughThePublisherRest"})
    public void testRemoveAnAPIThroughThePublisherRest() throws Exception {
        HttpResponse removeApiResponse = this.restAPIPublisher.deleteAPI(this.apiId);
        Assert.assertEquals((int)removeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when removing an API");
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Status code mismatch");
    }

    @Test(groups={"wso2.am"}, description="Import swagger definitions and Create two APIs with same context")
    public void testImportSwaggerAndCreateAPIWithSameContext() throws Exception {
        String swaggerPath1 = this.getAMResourceLocation() + File.separator + "swagger" + File.separator + "customer-info-api.yaml";
        String swaggerPath2 = this.getAMResourceLocation() + File.separator + "swagger" + File.separator + "leasing-api.yaml";
        try {
            File definition = new File(swaggerPath1);
            JSONObject apiProperties = this.getAPIDetails("CustomerInfoAPI");
            APIDTO apidto1Response = this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
            Assert.assertNotNull((Object)apidto1Response);
            File definition2 = new File(swaggerPath2);
            apiProperties = this.getAPIDetails("LeasingAPI");
            this.restAPIPublisher.importOASDefinition(definition2, apiProperties.toString());
            Assert.fail((String)"API created with same context");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
            Assert.assertTrue((boolean)e.getResponseBody().contains("The API context already exists"));
        }
    }

    @Test(groups={"wso2.am"}, description="Create APIs with archives with master swagger containing remote references")
    public void testCreateApiWithArchivesWithRemoteReferences() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "swagger" + File.separator + "swagger-archive.zip";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"https://test.com");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"TestAPIWithRemoteReferences");
        apiProperties.put("context", (Object)"/TestAPIWithRemoteReferences");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("policies", tierList);
        APIDTO apidtoResponse = this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
        Assert.assertNotNull((Object)apidtoResponse);
        this.apiId2 = apidtoResponse.getId();
        String retrievedSwagger = this.restAPIPublisher.getSwaggerByID(this.apiId2);
        this.validateRemoteReference(retrievedSwagger);
    }

    @Test(groups={"wso2.am"}, description="Create APIs with only Sandbox Endpoints")
    public void testCreateApiWithOnlySandboxEndpoints() throws Exception {
        String apiContextTest = "publisherTestAPIWithNoProductEndpoint";
        String apiNameNoProdEndpointTest = "APIM18PublisherTestNoProduction";
        String apiDescription = "This is Test API Created by API Manager Integration Test. This has no production endpoints";
        String apiTag = "tag18-1, tag18-2, tag18-3";
        APIRequest apiCreationRequestBean = new APIRequest(apiNameNoProdEndpointTest, apiContextTest, false, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion("1.0.0");
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setTier("Gold");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setDefault_version_checked("true");
        apiCreationRequestBean.setBusinessOwner("api18b");
        apiCreationRequestBean.setBusinessOwnerEmail("api18b@ee.com");
        apiCreationRequestBean.setTechnicalOwner("api18t");
        apiCreationRequestBean.setTechnicalOwnerEmail("api18t@ww.com");
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.apiId = apiCreationResponse.getData();
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertTrue((boolean)response.getData().contains(apiNameNoProdEndpointTest), (String)"Invalid API Name");
        Assert.assertTrue((boolean)response.getData().contains("1.0.0"), (String)"Invalid API Version");
        Assert.assertTrue((boolean)response.getData().contains(apiContextTest), (String)"Invalid API Context");
        ApiResponse apiKeyDTO = this.restAPIPublisher.generateInternalApiKey(this.apiId);
        Assert.assertEquals((int)200, (int)apiKeyDTO.getStatusCode(), (String)"Key generation is failed for APIs which don't have product endpoints");
        String apiKey = ((APIKeyDTO)apiKeyDTO.getData()).getApikey();
        Assert.assertNotNull((Object)apiKey, (String)"API Key is null");
        String[] split_string = apiKey.split("\\.");
        String base64EncodedBody = split_string[1];
        Base64 base64Url = new Base64(true);
        String body = new String(base64Url.decode(base64EncodedBody));
        JSONObject keyBody = new JSONObject(body);
        String keyType = keyBody.getString("keytype");
        Assert.assertEquals((String)"SANDBOX", (String)keyType, (String)"API Key is not type SANDBOX");
    }

    @Test(groups={"wso2.am"}, description="Create APIs with archives with a random master swagger file name")
    public void testCreateApiWithArchivesWithRemoteReferencesWithIncorrectSwagger() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "swagger" + File.separator + "incorrect-swagger-archive.zip";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"https://test.com");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)"TestAPIWithRemoteReferencesWithIncorrectSwaggerName");
        apiProperties.put("context", (Object)"/TestAPIWithRemoteReferencesWithIncorrectSwaggerName");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("policies", tierList);
        try {
            this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
            Assert.fail((String)"API imported successfully with invalid swagger name");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
            Assert.assertTrue((boolean)e.getResponseBody().contains("validating API Definition"));
        }
    }

    private JSONObject getAPIDetails(String apiName) throws JSONException {
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)apiName);
        apiProperties.put("context", (Object)"/SwaggerAPI1");
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.apiProviderName);
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        return apiProperties;
    }

    private void validateRemoteReference(String swaggerContent) {
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult swaggerParseResult = parser.readContents(swaggerContent, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        boolean isRemoteReferenceAvailable = false;
        Map schemas = openAPI.getComponents().getSchemas();
        for (Map.Entry schema : schemas.entrySet()) {
            if (!((String)schema.getKey()).equalsIgnoreCase("dataSetList")) continue;
            isRemoteReferenceAvailable = true;
        }
        Assert.assertTrue((boolean)isRemoteReferenceAvailable, (String)"Remote reference is not available in the schema list");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId2);
        super.cleanUp();
    }
}

