/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM514CreateAnAPIWithoutProvidingMandatoryFieldsTestCase
extends APIManagerLifecycleBaseTest {
    private final String apiNameTest1 = "APIM514PublisherTest1";
    private final String apiVersion = "1.0.0";
    private final String apiDescription = "This is Test API Created by API Manager Integration Test";
    private String apiTag = "tag514-1, tag514-2, tag514-3";
    private String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM514CreateAnAPIWithoutProvidingMandatoryFieldsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving API Name")
    public void testCreateAnAPIThroughThePublisherRestWithoutName() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI1";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("", apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        try {
            APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
            Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)"Api is not created without proving API Name");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400, (String)"Required Parameter name is not provided ");
        }
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving Context")
    public void testCreateAnAPIThroughThePublisherRestWithoutContext() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM514PublisherTest1", "", "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        try {
            APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
            Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)"Api is not created without proving Context");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400, (String)"Required Parameter context is not provided ");
        }
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving version")
    public void testCreateAnAPIThroughThePublisherRestWithoutVersion() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI2";
        String apiNameTest2 = "APIM514PublisherTest2";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest2, apiContextTest, "", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        try {
            APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
            Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)"Api is not created without proving Version");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400, (String)"Required Parameter version is not provided ");
        }
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving tier availability")
    public void testCreateAnAPIThroughThePublisherRestWithoutTierAvailability() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI3";
        String apiNameTest3 = "APIM514PublisherTest3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest3, apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        apiCreationRequestBean.setTiersCollection("");
        apiCreationRequestBean.setTier("");
        try {
            APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
            Assert.assertFalse((boolean)StringUtils.isEmpty((String)apiDto.getId()), (String)"Api is created without proving Version");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500, (String)"Internal Server Error ");
        }
    }

    public void testCreateAnAPIThroughThePublisherRestWithoutEndpoint() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI4";
        String apiNameTest4 = "APIM514PublisherTest4";
        URL url = null;
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest4, apiContextTest, "1.0.0", this.apiProviderName, url);
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
    }

    public void testCreateAnAPIThroughThePublisherRestWithoutResources() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI5";
        String apiNameTest5 = "APIM514PublisherTest5";
        APIDesignBean designBean = new APIDesignBean(apiNameTest5, apiContextTest, "1.0.0", "This is Test API Created by API Manager Integration Test", this.apiTag);
        designBean.setSwagger("");
        HttpResponse apiCreationResponse = this.apiPublisher.designAPI(designBean);
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving Action")
    public void testCreateAnAPIThroughThePublisherRestWithoutAction() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI6";
        String apiNameTest6 = "APIM514PublisherTest6";
        APICreationRequestBeanWithoutAction apiCreationRequestBean = new APICreationRequestBeanWithoutAction(apiNameTest6, apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        apiCreationRequestBean.setAction("");
        try {
            APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
            Assert.assertFalse((boolean)StringUtils.isEmpty((String)apiDto.getId()), (String)"Api is created without proving Action");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500, (String)"Internal Server Error ");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        super.cleanUp();
    }

    private class APICreationRequestBeanWithoutAction
    extends APICreationRequestBean {
        public APICreationRequestBeanWithoutAction(String apiName, String context, String version, String provider, URL endpointUrl) throws APIManagerIntegrationTestException {
            super(apiName, context, version, provider, endpointUrl);
        }

        public void setAction() {
            this.setAction("");
        }
    }
}

