/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM548CopyAnAPIToANewerVersionThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM548PublisherTest";
    private final String apiOldVersion = "1.0.0";
    private final String apiNewVersion = "2.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProviderName;
    private String apiProductionEndPointUrl;
    private String apiId;
    private String copyAPIId;

    @Factory(dataProvider="userModeDataProvider")
    public APIM548CopyAnAPIToANewerVersionThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Copy An API To A Newer Version Through the Publisher Rest API")
    public void testCopyAnAPIToANewerVersionThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim548PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag548-1, tag548-2, tag548-3";
        String defaultVersion = "default_version";
        APIRequest apiCreationRequestBean = new APIRequest("APIM548PublisherTest", apiContextTest, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion("1.0.0");
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefault_version("default_version");
        apiCreationRequestBean.setDefault_version_checked("default_version");
        apiCreationRequestBean.setBusinessOwner("api548b");
        apiCreationRequestBean.setBusinessOwnerEmail("api548b@ee.com");
        apiCreationRequestBean.setTechnicalOwner("api548t");
        apiCreationRequestBean.setTechnicalOwnerEmail("api548t@ww.com");
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.apiId = apiCreationResponse.getData();
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        JSONObject jsonObject = null;
        boolean available = false;
        int maxRetry = 10;
        int currentTry = 0;
        do {
            Thread.sleep(2000L);
            APIListDTO apiResponsePublisher = this.restAPIPublisher.getAllAPIs();
            if (apiResponsePublisher == null) continue;
            jsonObject = new JSONObject((Object)apiResponsePublisher);
            available = true;
            break;
        } while (++currentTry <= maxRetry);
        Assert.assertTrue((boolean)available, (String)"API not available");
        Assert.assertTrue((boolean)jsonObject.getString("list").contains("APIM548PublisherTest"), (String)"APIM548PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)jsonObject.getString("list").contains("1.0.0"), (String)"Version of the APIM548PublisherTestis not a valid version");
        HttpResponse copyResponse = this.restAPIPublisher.copyAPI("2.0.0", this.apiId, Boolean.valueOf(true));
        this.copyAPIId = copyResponse.getData();
        Assert.assertEquals((int)copyResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when copying the API");
        JSONObject allApiObject = null;
        available = false;
        maxRetry = 10;
        currentTry = 0;
        do {
            Thread.sleep(2000L);
            APIListDTO allApiResponse = this.restAPIPublisher.getAllAPIs();
            if (allApiResponse == null) continue;
            allApiObject = new JSONObject((Object)allApiResponse);
            available = true;
            break;
        } while (++currentTry <= maxRetry);
        Assert.assertTrue((boolean)available, (String)"API not available");
        JSONArray jsonArray = allApiObject.getJSONArray("list");
        ArrayList<String> allApiList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String version = jsonArray.getJSONObject(i).getString("version");
            allApiList.add(version);
        }
        Assert.assertTrue((boolean)allApiList.contains("1.0.0"), (String)"Error in API getting:APIM548PublisherTest through publisher rest api");
        Assert.assertTrue((boolean)allApiList.contains("2.0.0"), (String)"Error in API getting:APIM548PublisherTest through publisher rest api");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.copyAPIId);
        super.cleanUp();
    }
}

