/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM570CheckIfAnOlderVersionOfTheAPIExistsThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM570CheckIfAnOlderVersionOfTheAPIExistsThroughThePublisherRestAPITestCase.class);
    private static final String apiNameTest = "APIM570PublisherTest";
    private static final String apiVersion1 = "1.0.0";
    private static final String apiVersion2 = "2.0.0";
    private static final String apiVersion3 = "3.0.0";
    private static final String apiDefaultVersion = "default_version";
    private APIPublisherRestClient apiPublisher;
    private static String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM570CheckIfAnOlderVersionOfTheAPIExistsThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @DataProvider(name="copyAPI")
    public static Object[][] copyanApiWithValidDataProvider() throws Exception {
        return new Object[][]{{apiProviderName, apiNameTest, apiVersion1, apiVersion2, apiDefaultVersion}, {apiProviderName, apiNameTest, apiVersion1, apiVersion3, apiDefaultVersion}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API using valid data and get the API")
    public void testCreateAnApiUsingValidDataAndGetThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim570PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag570-1, tag570-2, tag570-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest, apiContextTest, apiVersion1, apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion(apiDefaultVersion);
        apiCreationRequestBean.setDefaultVersionChecked(apiDefaultVersion);
        apiCreationRequestBean.setBizOwner("api570b");
        apiCreationRequestBean.setBizOwnerMail("api570b@ee.com");
        apiCreationRequestBean.setTechOwner("api570t");
        apiCreationRequestBean.setTechOwnerMail("api570t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM570PublisherTestis not created as expected");
        HttpResponse apiResponsePublisher = this.apiPublisher.getAllAPIs();
        JSONObject jsonObject = new JSONObject(apiResponsePublisher.getData());
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM570PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)jsonObject.getString("apis").contains(apiNameTest), (String)"APIM570PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)jsonObject.getString("apis").contains(apiVersion1), (String)"Version of the APIM570PublisherTestis not a valid version");
    }

    @Test(dataProvider="copyAPI", description="Copy an API with the multiple version check if the older version exist through Publisher Rest API", dependsOnMethods={"testCreateAnApiUsingValidDataAndGetThroughThePublisherRest"})
    public void testCheckIfAnOlderVersionOfTheAPIExistsThroughThePublisherRestAPI(String provider, String apiName, String oldVersion, String newVersion, String defaultVersion) throws Exception {
        JSONObject jsonObjectCopy = new JSONObject(this.apiPublisher.copyAPI(provider, apiName, oldVersion, newVersion, defaultVersion).getData());
        log.info((Object)("API Name: " + apiName + " Old Version: " + oldVersion + " New Version: " + newVersion));
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)" New copy of the APIM570PublisherTest is not created as expected");
        HttpResponse allApiResponse = this.apiPublisher.getAllAPIs();
        JSONObject allApiObject = new JSONObject(allApiResponse.getData());
        JSONArray jsonArray = allApiObject.getJSONArray("apis");
        ArrayList<String> allApiList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String name = jsonArray.getJSONObject(i).toString();
            allApiList.add(name);
            log.info((Object)("API List :" + allApiList));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI(apiNameTest, apiVersion1, apiProviderName);
        this.apiPublisher.deleteAPI(apiNameTest, apiVersion2, apiProviderName);
        this.apiPublisher.deleteAPI(apiNameTest, apiVersion3, apiProviderName);
        super.cleanUp();
    }
}

