/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM611AddDocumentationToAnAPIWithDocTypeHowToThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM620PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIM611AddDocumentationToAnAPIWithDocTypeHowToThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Inline through the publisher rest API ")
    public void testAddDocumentToAnAPIHowToInline() throws Exception {
        String apiContext = "apim611PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag611-1, tag612-2";
        String docName = "APIM611PublisherTestHowTo-Inline-summary";
        String docType = "How To";
        String sourceType = "Inline";
        APIRequest apiRequest = new APIRequest("APIM620PublisherTest", apiContext, new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.apiProvider);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags(apiTags);
        apiRequest.setDescription(apiDescription);
        apiRequest.setBusinessOwner("api611b");
        apiRequest.setBusinessOwnerEmail("api611b@ee.com");
        apiRequest.setTechnicalOwner("api611t");
        apiRequest.setTechnicalOwnerEmail("api611t@ww.com");
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO.setName(docName);
        documentDTO.setSummary("Testing");
        documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse response1 = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        String documentId = response1.getData();
        DocumentListDTO documentListDTO = this.restAPIPublisher.getDocuments(this.apiId);
        DocumentDTO documentOne = (DocumentDTO)documentListDTO.getList().get(0);
        Assert.assertEquals((String)documentId, (String)documentOne.getDocumentId(), (String)"Document addition failed.");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Url through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIHowToInline"})
    public void testAddDocumentToAnAPIHowToUrl() throws Exception {
        String docName = "APIM612PublisherTestHowTo-Url-summary";
        String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.URL);
        documentDTO.setName(docName);
        documentDTO.setSummary("Testing");
        documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        documentDTO.setSourceUrl(docUrl);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse response1 = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        String documentId = response1.getData();
        DocumentListDTO documentListDTO = this.restAPIPublisher.getDocuments(this.apiId);
        boolean available = false;
        for (DocumentDTO documentDTO1 : documentListDTO.getList()) {
            if (!documentId.equals(documentDTO1.getDocumentId())) continue;
            available = true;
            break;
        }
        Assert.assertTrue((boolean)available, (String)"Document addition failed.");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

