/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM620AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String apiName = "APIM620PublisherTest";
    private final String apiVersion = "1.0.0";
    private final String summary = "This is documentation summary";
    private String apiEndPointUrl;
    private String apiId;
    private String sdkInlineDocumentId;
    private String sdkUrlDocumentId;
    private String provider;

    @Factory(dataProvider="userModeDataProvider")
    public APIM620AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.provider = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Inline through the publisher rest API ")
    public void testAddDocumentToAnAPISDKInline() throws Exception {
        String apiContext = "apim620PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag620-1, tag621-2";
        String docName = "APIM611PublisherTestHowTo-Inline-summary";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM620PublisherTest", apiContext, "1.0.0", this.provider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api620b");
        apiCreationRequestBean.setBizOwnerMail("api620b@ee.com");
        apiCreationRequestBean.setTechOwner("api620t");
        apiCreationRequestBean.setTechOwnerMail("api620t@ww.com");
        APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
        this.apiId = apiDto.getId();
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(docName);
        documentDTO.setSummary("This is documentation summary");
        documentDTO.setType(DocumentDTO.TypeEnum.SAMPLES);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        this.sdkInlineDocumentId = documentationResponse.getData();
        HttpResponse docRemoveResponse = this.restAPIPublisher.removeDocumentation(this.apiId, this.sdkInlineDocumentId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)docRemoveResponse.getResponseCode(), (String)"Error when removingdocumentation");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Url through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPISDKInline"})
    public void testAddDocumentToAnAPISDKUrl() throws Exception {
        String docName = "APIM621PublisherTestHowTo-Url-summary";
        String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(docName);
        documentDTO.setSummary("This is documentation summary");
        documentDTO.setType(DocumentDTO.TypeEnum.SAMPLES);
        documentDTO.setSourceUrl(docUrl);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.URL);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        this.sdkUrlDocumentId = documentationResponse.getData();
        HttpResponse docRemoveResponse = this.restAPIPublisher.removeDocumentation(this.apiId, this.sdkUrlDocumentId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)docRemoveResponse.getResponseCode(), (String)"Error when removingdocumentation");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

