/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM623AddDocumentationToAnAPIWithDocTypePublicForumThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM623PublisherTest";
    private final String apiVersion = "1.0.0";
    private final String summary = "This is documentation summary";
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;
    private String forumTypeDocumentId;
    private String apiContext = "apim623PublisherTestAPI";
    private String apiDescription = "This is Test API Created by API Manager Integration Test";
    private String apiTags = "tag623-1, tag623-2";
    private String docName = "APIM611PublisherTestHowTo-Inline-summary";
    private String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";

    @Factory(dataProvider="userModeDataProvider")
    public APIM623AddDocumentationToAnAPIWithDocTypePublicForumThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type  public forum And Source Url through the publisher rest API ")
    public void testAddDocumentToAnAPIPublicInline() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM623PublisherTest", this.apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTags);
        apiCreationRequestBean.setDescription(this.apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api623b");
        apiCreationRequestBean.setBizOwnerMail("api623b@ee.com");
        apiCreationRequestBean.setTechOwner("api623t");
        apiCreationRequestBean.setTechOwnerMail("api623t@ww.com");
        APIDTO apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        String status = apiCreationResponse.getLifeCycleStatus();
        this.apiId = apiCreationResponse.getId();
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(status), (String)"Status of the APIM623PublisherTestis not a valid status");
        HttpResponse apiResponsePublisher = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)apiResponsePublisher.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM623PublisherTest is not visible in publisher");
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(this.docName);
        documentDTO.setType(DocumentDTO.TypeEnum.PUBLIC_FORUM);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.URL);
        documentDTO.setSummary("This is documentation summary");
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        documentDTO.setSourceUrl(this.docUrl);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error while adddocumentation to API");
        this.forumTypeDocumentId = documentationResponse.getData();
        HttpResponse docRemoveResponse = this.restAPIPublisher.removeDocumentation(this.apiId, this.forumTypeDocumentId);
        Assert.assertEquals((int)docRemoveResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error when removingdocumentation");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

