/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.MalformedURLException;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER5834APICreationWithInvalidInputsTestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM18PublisherTest";
    private final String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
    private final String contextMisMatchErrorMsg = "API Context does not exist";
    private String apiProductionEndPointUrl;
    private String apiId;
    private String apiProviderName;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5834APICreationWithInvalidInputsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/customers/123";
    }

    @Test(groups={"wso2.am"}, description="Test API creation with invalid context", expectedExceptions={ApiException.class})
    public void testAPICreationWithInvalidContext() throws MalformedURLException, APIManagerIntegrationTestException, ApiException {
        String backendEndPoint = this.getBackendEndServiceEndPointHttp("jaxrs_basic/services/customers/customerservice");
        APIRequest apiRequest = new APIRequest("APIM18PublisherTest", "/", new URL(backendEndPoint));
        this.restAPIPublisher.addAPI(apiRequest);
    }

    @Test(groups={"wso2.am"}, description="Validate if the context matches the previous API version(s)")
    public void testContextMatchesPreviousAPIVersions() throws ApiException, MalformedURLException, APIManagerIntegrationTestException {
        APIRequest apiRequest = new APIRequest("APIM18PublisherTest", "/test/v1.0.0", new URL(this.apiProductionEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.apiProviderName);
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiCreationResponse.getData();
        APIRequest duplicateRequest = new APIRequest("APIM18PublisherTest", "/test/v2.0.0", new URL(this.apiProductionEndPointUrl));
        duplicateRequest.setVersion("2.0.0");
        duplicateRequest.setProvider(this.apiProviderName);
        try {
            HttpResponse duplicateApiCreationResponse = this.restAPIPublisher.addAPI(duplicateRequest);
            this.restAPIPublisher.deleteAPI(duplicateApiCreationResponse.getData());
            Assert.fail((String)"Added an API with invalid context");
        }
        catch (ApiException e) {
            ApiException apiException = (ApiException)e.getCause();
            Assert.assertTrue((boolean)apiException.getResponseBody().contains("API Context does not exist"), (String)"Invalid API Context");
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        if (this.apiId != null) {
            this.restAPIPublisher.deleteAPI(this.apiId);
        }
        super.cleanUp();
    }
}

