/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionPolicyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionPolicyListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIMGetAllSubscriptionThrottlingPolicies
extends APIMIntegrationBaseTest {
    @Factory(dataProvider="userModeDataProvider")
    public APIMGetAllSubscriptionThrottlingPolicies(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Get all the subscription throttling polices for event count quota type ")
    public void testGetAllSubscriptionThrottlingPoliciesByQuotaType() throws Exception {
        SubscriptionPolicyListDTO subscriptionPolicyList = this.restAPIPublisher.getSubscriptionPolicies("eventCount");
        Assert.assertNotNull((Object)subscriptionPolicyList, (String)"There are no subscription policies available");
        Assert.assertNotNull((Object)subscriptionPolicyList.getCount(), (String)"Subscription policy count should be available");
        Assert.assertEquals((int)subscriptionPolicyList.getCount(), (int)8, (String)"There must be only 8 policies by default");
        SubscriptionPolicyDTO tierAsyncBronze = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(2);
        Assert.assertEquals((String)tierAsyncBronze.getDescription(), (String)"Allows 5000 events per day", (String)"Invalid description of the tier Async Bronze");
        Assert.assertEquals((String)tierAsyncBronze.getDisplayName(), (String)"AsyncBronze", (String)"Invalid display name of the tier Async Bronze");
        Assert.assertEquals((String)tierAsyncBronze.getPolicyName(), (String)"AsyncBronze", (String)"Invalid name of the tier Async Bronze");
        SubscriptionPolicyDTO tierAsyncGold = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(0);
        Assert.assertEquals((String)tierAsyncGold.getDescription(), (String)"Allows 50000 events per day", (String)"Invalid description of the tier Async Gold");
        Assert.assertEquals((String)tierAsyncGold.getDisplayName(), (String)"AsyncGold", (String)"Invalid display name of the tier Async Gold");
        Assert.assertEquals((String)tierAsyncGold.getPolicyName(), (String)"AsyncGold", (String)"Invalid name of the tier Async Gold");
        SubscriptionPolicyDTO tierAsyncSilver = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(1);
        Assert.assertEquals((String)tierAsyncSilver.getDescription(), (String)"Allows 25000 events per day", (String)"Invalid description of the tier Async Silver");
        Assert.assertEquals((String)tierAsyncSilver.getDisplayName(), (String)"AsyncSilver", (String)"Invalid display name of the tier Async Silver");
        Assert.assertEquals((String)tierAsyncSilver.getPolicyName(), (String)"AsyncSilver", (String)"Invalid name of the tier Async Silver");
        SubscriptionPolicyDTO tierAsyncUnlimited = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(3);
        Assert.assertEquals((String)tierAsyncUnlimited.getDescription(), (String)"Allows unlimited events", (String)"Invalid description of the tier Async Unlimited");
        Assert.assertEquals((String)tierAsyncUnlimited.getDisplayName(), (String)"AsyncUnlimited", (String)"Invalid display name of the tier Async Unlimited");
        Assert.assertEquals((String)tierAsyncUnlimited.getPolicyName(), (String)"AsyncUnlimited", (String)"Invalid name of the tier Async Unlimited");
        SubscriptionPolicyDTO tierAsyncWHBronze = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(6);
        Assert.assertEquals((String)tierAsyncWHBronze.getDescription(), (String)"Allows 1000 events per month and 500 active subscriptions", (String)"Invalid description of the tier AsyncWHBronze");
        Assert.assertEquals((String)tierAsyncWHBronze.getDisplayName(), (String)"AsyncWHBronze", (String)"Invalid display name of the tier AsyncWHBronze");
        Assert.assertEquals((String)tierAsyncWHBronze.getPolicyName(), (String)"AsyncWHBronze", (String)"Invalid name of the tier AsyncWHBronze");
        SubscriptionPolicyDTO tierAsyncWHGold = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(4);
        Assert.assertEquals((String)tierAsyncWHGold.getDescription(), (String)"Allows 10000 events per month and 1000 active subscriptions", (String)"Invalid description of the tier AsyncWHGold");
        Assert.assertEquals((String)tierAsyncWHGold.getDisplayName(), (String)"AsyncWHGold", (String)"Invalid display name of the tier AsyncWHGold");
        Assert.assertEquals((String)tierAsyncWHGold.getPolicyName(), (String)"AsyncWHGold", (String)"Invalid name of the tier AsyncWHGold");
        SubscriptionPolicyDTO tierAsyncWHSilver = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(5);
        Assert.assertEquals((String)tierAsyncWHSilver.getDescription(), (String)"Allows 5000 events per month and 500 active subscriptions", (String)"Invalid description of the tier AsyncWHSilver");
        Assert.assertEquals((String)tierAsyncWHSilver.getDisplayName(), (String)"AsyncWHSilver", (String)"Invalid display name of the tier AsyncWHSilver");
        Assert.assertEquals((String)tierAsyncWHSilver.getPolicyName(), (String)"AsyncWHSilver", (String)"Invalid name of the tier AsyncWHSilver");
        SubscriptionPolicyDTO tierAsyncWHUnlimited = (SubscriptionPolicyDTO)subscriptionPolicyList.getList().get(7);
        Assert.assertEquals((String)tierAsyncWHUnlimited.getDescription(), (String)"Allows unlimited events and unlimited active subscriptions", (String)"Invalid description of the tier AsyncWHUnlimited");
        Assert.assertEquals((String)tierAsyncWHUnlimited.getDisplayName(), (String)"AsyncWHUnlimited", (String)"Invalid display name of the tier Bronze");
        Assert.assertEquals((String)tierAsyncWHUnlimited.getPolicyName(), (String)"AsyncWHUnlimited", (String)"Invalid name of the tier AsyncWHUnlimited");
    }
}

